/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.dialog;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;

public class ModifyPropertyDialogCommand
extends Command {
    private EObject currentValueObject;
    private EObject oldPropertyValueObject;
    private EObject newPropertyValueObject;
    private NotificationAdapter adapter;

    public ModifyPropertyDialogCommand(NotificationAdapter adapter, EObject originalValue, EObject newValue) {
        this.currentValueObject = originalValue;
        this.newPropertyValueObject = newValue;
        this.oldPropertyValueObject = EcoreUtil.copy((EObject)originalValue);
        this.adapter = adapter;
    }

    public EObject getNewPropertyValueObject() {
        return this.newPropertyValueObject;
    }

    public void setNewPropertyDialogValueObject(EObject newPropertyDialogValueObject) {
        this.newPropertyValueObject = newPropertyDialogValueObject;
    }

    public void execute() {
        this.currentValueObject.eAdapters().add((Object)this.adapter);
        for (EAttribute attribute : this.newPropertyValueObject.eClass().getEAllAttributes()) {
            Object currentAttributeValue;
            Object newAttributeValue = this.newPropertyValueObject.eGet((EStructuralFeature)attribute);
            if (this.currentValueObject == null || newAttributeValue == null || newAttributeValue.equals(currentAttributeValue = this.currentValueObject.eGet((EStructuralFeature)attribute))) continue;
            this.currentValueObject.eSet((EStructuralFeature)attribute, newAttributeValue);
        }
        this.currentValueObject.eAdapters().remove((Object)this.adapter);
    }

    public void undo() {
        this.currentValueObject.eAdapters().add((Object)this.adapter);
        for (EAttribute attribute : this.oldPropertyValueObject.eClass().getEAllAttributes()) {
            Object currentAttributeValue;
            Object oldAttributeValue = this.oldPropertyValueObject.eGet((EStructuralFeature)attribute);
            if (this.currentValueObject == null || oldAttributeValue == null || oldAttributeValue.equals(currentAttributeValue = this.currentValueObject.eGet((EStructuralFeature)attribute))) continue;
            this.currentValueObject.eSet((EStructuralFeature)attribute, oldAttributeValue);
        }
        this.currentValueObject.eAdapters().remove((Object)this.adapter);
    }

    public void redo() {
        this.currentValueObject.eAdapters().add((Object)this.adapter);
        for (EAttribute attribute : this.newPropertyValueObject.eClass().getEAllAttributes()) {
            Object currentAttributeValue;
            Object newAttributeValue = this.newPropertyValueObject.eGet((EStructuralFeature)attribute);
            if (this.currentValueObject == null || newAttributeValue == null || newAttributeValue.equals(currentAttributeValue = this.currentValueObject.eGet((EStructuralFeature)attribute))) continue;
            this.currentValueObject.eSet((EStructuralFeature)attribute, newAttributeValue);
        }
        this.currentValueObject.eAdapters().remove((Object)this.adapter);
    }

    public EObject getCurrentValueObject() {
        return this.currentValueObject;
    }
}

