/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetActivityControlFlowCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.BoundEObjectPropertyId;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DiagramCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ActivityCommandFactory
extends DefaultPropSheetCmdFactory {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    public static final ActivityCommandFactory INSTANCE = new ActivityCommandFactory();

    @Override
    public Command createSetValueCommand(UndoablePropSheetEntry entry, IPropertyDescriptor descriptor, IPropertySource target, Object value) {
        if (value == null) {
            return this.createResetValueCommand(descriptor, target);
        }
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createSetValueCommand(entry, descriptor, target, value));
        this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, value);
        return result.unwrap();
    }

    @Override
    public Command createResetValueCommand(IPropertyDescriptor descriptor, IPropertySource target) {
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createResetValueCommand(descriptor, target));
        this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, null);
        return result.unwrap();
    }

    private void addUpdateCommand(CompoundCommand result, BoundEObjectPropertyId id, IPropertySource target, Object value) {
        EStructuralFeature feature = id.getId();
        if (feature.equals(CWM_PKG.getActivityType_Implementation())) {
            this.addResetCommands(result, (ActivityType)target.getEditableValue(), (ActivityImplementationType)value);
        } else if (feature.equals(CWM_PKG.getActivityType_Join())) {
            this.addSetJoinSplitType(result, id.getPart(), (ActivityType)target.getEditableValue(), FlowControlType.JOIN_LITERAL, (JoinSplitType)value);
        } else if (feature.equals(CWM_PKG.getActivityType_Split())) {
            this.addSetJoinSplitType(result, id.getPart(), (ActivityType)target.getEditableValue(), FlowControlType.SPLIT_LITERAL, (JoinSplitType)value);
        }
    }

    private void addSetJoinSplitType(CompoundCommand result, EditPart part, ActivityType activity, FlowControlType flowType, JoinSplitType gatewayType) {
        if (gatewayType == null) {
            gatewayType = JoinSplitType.NONE_LITERAL;
        }
        if (this.getGatewayType(activity, flowType) != gatewayType) {
            result.add((Command)new SetActivityControlFlowCmd(null, activity, flowType, gatewayType));
        }
    }

    private JoinSplitType getGatewayType(ActivityType activity, FlowControlType flowType) {
        return FlowControlType.JOIN_LITERAL.equals((Object)flowType) ? activity.getJoin() : activity.getSplit();
    }

    private void addResetCommands(CompoundCommand command, ActivityType activity, ActivityImplementationType implementation) {
        DataMappingType mapping;
        if (!ActivityImplementationType.APPLICATION_LITERAL.equals((Object)implementation) && activity.getApplication() != null) {
            command.add((Command)new DeleteValueCmd((EObject)activity, activity.getApplication(), (EStructuralFeature)CWM_PKG.getActivityType_Application()));
            DiagramCommandFactory.INSTANCE.addDeleteConnectionCommands(command, (IModelElement)activity, (EStructuralFeature)CWM_PKG.getISymbolContainer_ExecutedByConnection());
        }
        if (!ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)implementation)) {
            if (activity.getImplementationProcess() != null) {
                command.add((Command)new DeleteValueCmd((EObject)activity, activity.getImplementationProcess(), (EStructuralFeature)CWM_PKG.getActivityType_ImplementationProcess()));
            }
            if (activity.getSubProcessMode() != null) {
                command.add((Command)new DeleteValueCmd((EObject)activity, activity.getSubProcessMode(), (EStructuralFeature)CWM_PKG.getActivityType_SubProcessMode()));
            }
        }
        if (ActivityImplementationType.ROUTE_LITERAL.equals((Object)implementation) || ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)implementation) || ActivityImplementationType.APPLICATION_LITERAL.equals((Object)implementation) && activity.getApplication() != null && !activity.getApplication().isInteractive()) {
            if (activity.eIsSet((EStructuralFeature)CWM_PKG.getActivityType_AllowsAbortByPerformer())) {
                command.add((Command)new DeleteValueCmd((EObject)activity, activity.isAllowsAbortByPerformer(), (EStructuralFeature)CWM_PKG.getActivityType_AllowsAbortByPerformer()));
            }
            if (activity.eIsSet((EStructuralFeature)CWM_PKG.getActivityType_Performer())) {
                command.add((Command)new DeleteValueCmd((EObject)activity, activity.getPerformer(), (EStructuralFeature)CWM_PKG.getActivityType_Performer()));
                DiagramCommandFactory.INSTANCE.addDeleteConnectionCommands(command, (IModelElement)activity, (EStructuralFeature)CWM_PKG.getISymbolContainer_PerformsConnection());
            }
        }
        List contexts = ActivityUtil.getContextTypes((ActivityType)activity, (ActivityImplementationType)implementation, null);
        HashSet<String> contextIds = new HashSet<String>();
        int i = 0;
        while (i < contexts.size()) {
            ApplicationContextTypeType ctx = (ApplicationContextTypeType)contexts.get(i);
            contextIds.add(ctx.getId());
            ++i;
        }
        HashSet<DataType> usedData = new HashSet<DataType>();
        HashSet<DataType> unusedData = new HashSet<DataType>();
        ArrayList<DataMappingType> mappings2Delete = new ArrayList<DataMappingType>();
        EList mappings = activity.getDataMapping();
        int i2 = 0;
        while (i2 < mappings.size()) {
            mapping = (DataMappingType)mappings.get(i2);
            if (contextIds.contains(mapping.getContext())) {
                usedData.add(mapping.getData());
            } else {
                unusedData.add(mapping.getData());
                mappings2Delete.add(mapping);
            }
            ++i2;
        }
        unusedData.removeAll(usedData);
        if (!unusedData.isEmpty()) {
            for (DataType data : unusedData) {
                DiagramCommandFactory.INSTANCE.addDeleteConnectionCommands(command, (IModelElement)activity, (IModelElement)data, (EStructuralFeature)CWM_PKG.getISymbolContainer_DataMappingConnection());
            }
            if (!(ActivityImplementationType.MANUAL_LITERAL.equals((Object)activity.getImplementation()) || ActivityImplementationType.ROUTE_LITERAL.equals((Object)activity.getImplementation()) || ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)activity.getImplementation()) || ActivityImplementationType.APPLICATION_LITERAL.equals((Object)implementation))) {
                i = 0;
                while (i < mappings2Delete.size()) {
                    mapping = (DataMappingType)mappings.get(i);
                    command.add((Command)new DeleteValueCmd((EObject)activity, mapping, (EStructuralFeature)CWM_PKG.getActivityType_DataMapping()));
                    ++i;
                }
            }
        }
    }

    public static Command getSetImplementationCommand(ActivityImplementationType implType, ActivityType activity) {
        CompoundCommand command = new CompoundCommand();
        ActivityCommandFactory.addUpdateDataMappingCommand(command, activity, implType);
        command.add(INSTANCE.getSetCommand(null, (EObject)activity, (EStructuralFeature)CWM_PKG.getActivityType_Implementation(), implType));
        if (!activity.getImplementation().equals((Object)implType) && activity.getImplementation().equals((Object)ActivityImplementationType.MANUAL_LITERAL)) {
            command.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)CWM_PKG.getActivityType_Performer(), null));
        }
        return command;
    }

    private static void addUpdateDataMappingCommand(CompoundCommand command, ActivityType activity, ActivityImplementationType implType) {
        block3: {
            block2: {
                if (!ActivityImplementationType.ROUTE_LITERAL.equals((Object)activity.getImplementation()) || !ActivityImplementationType.MANUAL_LITERAL.equals((Object)implType)) break block2;
                for (DataMappingType dataMapping : activity.getDataMapping()) {
                    command.add((Command)new DeleteValueCmd((EObject)dataMapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint()));
                }
                break block3;
            }
            if (!ActivityImplementationType.MANUAL_LITERAL.equals((Object)activity.getImplementation()) || !ActivityImplementationType.ROUTE_LITERAL.equals((Object)implType)) break block3;
            for (DataMappingType dataMapping : activity.getDataMapping()) {
                command.add((Command)new SetValueCmd((EObject)dataMapping, (EStructuralFeature)CWM_PKG.getDataMappingType_ApplicationAccessPoint(), (Object)dataMapping.getId()));
            }
        }
    }

    public static void addSetApplicationCommands(CompoundCommand command, ActivityType activity, ApplicationType newApplication, ApplicationType originalApplication, boolean updateDependenciesOnly) {
        if (!updateDependenciesOnly && newApplication != originalApplication) {
            command.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_Application(), (Object)newApplication));
        }
        ActivityCommandFactory.addUpdateConnectionsCommand(command, (IIdentifiableModelElement)activity, (IIdentifiableModelElement)newApplication, (IIdentifiableModelElement)originalApplication, (EStructuralFeature)CWM_PKG.getActivitySymbolType_ExecutedByConnections(), (EStructuralFeature)CWM_PKG.getISymbolContainer_ApplicationSymbol(), (EStructuralFeature)CWM_PKG.getExecutedByConnectionType_ApplicationSymbol());
    }

    public static Command getSetSubprocessCommand(ActivityType activity, ProcessDefinitionType process) {
        CompoundCommand command = new CompoundCommand();
        command.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)CWM_PKG.getActivityType_ImplementationProcess(), (Object)process));
        return command;
    }
}

