/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.BoundEObjectPropertyId;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class DataCommandFactory
extends DefaultPropSheetCmdFactory {
    private final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    public static final DataCommandFactory INSTANCE = new DataCommandFactory();

    @Override
    public Command createSetValueCommand(UndoablePropSheetEntry entry, IPropertyDescriptor descriptor, IPropertySource target, Object value) {
        if (value == null) {
            return this.createResetValueCommand(descriptor, target);
        }
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createSetValueCommand(entry, descriptor, target, value));
        this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, value);
        return result.unwrap();
    }

    @Override
    public Command createResetValueCommand(IPropertyDescriptor descriptor, IPropertySource target) {
        CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
        result.add(super.createResetValueCommand(descriptor, target));
        this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, null);
        return result.unwrap();
    }

    private void addUpdateCommand(CompoundCommand result, BoundEObjectPropertyId id, IPropertySource target, Object value) {
        EStructuralFeature feature = id.getId();
        if (feature.equals(this.CWM_PKG.getDataType_Type())) {
            this.addResetCommands(result, (DataType)target.getEditableValue(), (DataTypeType)value);
        }
    }

    private void addResetCommands(CompoundCommand command, DataType data, DataTypeType type) {
        Object attributes = data.getAttribute();
        int i = 0;
        while (i < attributes.size()) {
            AttributeType attr = (AttributeType)attributes.get(i);
            command.add((Command)new DeleteValueCmd((EObject)data, attr, (EStructuralFeature)this.CWM_PKG.getIExtensibleElement_Attribute()));
            ++i;
        }
        IDataInitializer initializer = this.getInitializer(type);
        if (initializer != null && (attributes = initializer.initialize(data, (List)attributes)) != null) {
            int i2 = 0;
            while (i2 < attributes.size()) {
                AttributeType attribute = (AttributeType)attributes.get(i2);
                command.add((Command)new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), (Object)attribute));
                ++i2;
            }
        }
    }

    private IDataInitializer getInitializer(DataTypeType type) {
        SpiExtensionRegistry registry;
        Map extensions;
        IConfigurationElement config;
        if (type != null && (config = (IConfigurationElement)(extensions = (registry = SpiExtensionRegistry.instance()).getExtensions("dataTypes")).get(type.getId())) != null) {
            try {
                return (IDataInitializer)config.createExecutableExtension("initializerClass");
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    public static Command getSetTypeCommand(DataTypeType type, DataType data) {
        return INSTANCE.getSetCommand(null, (EObject)data, (EStructuralFeature)DataCommandFactory.INSTANCE.CWM_PKG.getDataType_Type(), type);
    }
}

