/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.editors.parts.PropertySourceFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.BoundEObjectPropertyId;
import org.eclipse.stardust.modeling.core.editors.parts.properties.IPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ResetValueCommand;
import org.eclipse.stardust.modeling.core.editors.parts.properties.SetValueCommand;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class DefaultPropSheetCmdFactory
implements IPropSheetCmdFactory {
    public static final DefaultPropSheetCmdFactory INSTANCE = new DefaultPropSheetCmdFactory();

    @Override
    public Command createSetValueCommand(UndoablePropSheetEntry entry, IPropertyDescriptor descriptor, IPropertySource target, Object value) {
        SetValueCommand setCommand = new SetValueCommand(descriptor.getDisplayName());
        setCommand.setTarget(target);
        setCommand.setPropertyId(descriptor.getId());
        setCommand.setPropertyValue(value);
        return setCommand;
    }

    @Override
    public Command createResetValueCommand(IPropertyDescriptor descriptor, IPropertySource target) {
        ResetValueCommand restoreCmd = new ResetValueCommand();
        restoreCmd.setTarget(target);
        restoreCmd.setPropertyId(descriptor.getId());
        return restoreCmd;
    }

    public Command getSetCommand(EditPart part, EObject object, EStructuralFeature feature, Object value) {
        IPropertySource target = PropertySourceFactory.getPropertySource(part, object);
        IPropertyDescriptor[] descriptors = target.getPropertyDescriptors();
        int j = 0;
        while (j < descriptors.length) {
            IPropertyDescriptor descriptor = descriptors[j];
            if (feature.equals(descriptor.getId()) || descriptor.getId() instanceof BoundEObjectPropertyId && feature.equals(((BoundEObjectPropertyId)descriptor.getId()).getId())) {
                IPropSheetCmdFactory cmdFactory = null;
                if (descriptor instanceof IAdaptable) {
                    cmdFactory = (IPropSheetCmdFactory)((IAdaptable)descriptor).getAdapter(IPropSheetCmdFactory.class);
                }
                if (cmdFactory == null) {
                    cmdFactory = INSTANCE;
                }
                return cmdFactory.createSetValueCommand(null, descriptor, target, value);
            }
            ++j;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public static void addUpdateConnectionsCommand(CompoundCommand command, IIdentifiableModelElement identifiable, IIdentifiableModelElement newValue, IIdentifiableModelElement originalValue, EStructuralFeature connectionFeature, EStructuralFeature symbolFeature, EStructuralFeature endingFeature) {
        for (INodeSymbol referenceSymbol : identifiable.getSymbols()) {
            Object obj = referenceSymbol.eGet(connectionFeature);
            if (obj instanceof IConnectionSymbol) {
                DefaultPropSheetCmdFactory.addUpdateConnectionsCommand(command, newValue, originalValue, symbolFeature, endingFeature, (IConnectionSymbol)obj, referenceSymbol);
                continue;
            }
            if (!(obj instanceof List)) continue;
            for (IConnectionSymbol conn : (List)obj) {
                DefaultPropSheetCmdFactory.addUpdateConnectionsCommand(command, newValue, originalValue, symbolFeature, endingFeature, conn, referenceSymbol);
            }
        }
    }

    private static void addUpdateConnectionsCommand(CompoundCommand command, IIdentifiableModelElement newValue, IIdentifiableModelElement originalValue, EStructuralFeature symbolFeature, EStructuralFeature endingFeature, IConnectionSymbol connection, INodeSymbol referenceSymbol) {
        if (connection != null) {
            if (newValue == null) {
                command.add((Command)new DeleteConnectionSymbolCmd(connection));
            } else if (newValue != originalValue) {
                INodeSymbol endingSymbol = DiagramUtil.getClosestSymbol((INodeSymbol)referenceSymbol, (EStructuralFeature)symbolFeature, (IModelElement)newValue);
                if (endingSymbol == null) {
                    command.add((Command)new DeleteConnectionSymbolCmd(connection));
                } else {
                    command.add((Command)new SetValueCmd((EObject)connection, endingFeature, (Object)endingSymbol));
                }
            }
        }
    }
}

