/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;

public class DiagramCommandFactory
extends DefaultPropSheetCmdFactory {
    public static final DiagramCommandFactory INSTANCE = new DiagramCommandFactory();

    public void addDeleteConnectionCommands(CompoundCommand command, IModelElement first, EStructuralFeature connectionType) {
        this.addDeleteConnectionCommands(command, first, null, connectionType);
    }

    public void addDeleteConnectionCommands(CompoundCommand command, IModelElement first, IModelElement second, EStructuralFeature connectionType) {
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)first);
        EList diagrams = process.getDiagram();
        int i = 0;
        while (i < diagrams.size()) {
            DiagramType diagram = (DiagramType)diagrams.get(i);
            this.addDeleteConnectionCommands(command, diagram, first, second, connectionType);
            ++i;
        }
    }

    private void addDeleteConnectionCommands(CompoundCommand command, DiagramType diagram, IModelElement first, IModelElement second, EStructuralFeature connectionType) {
        ArrayList connections = new ArrayList();
        connections.addAll((List)diagram.eGet(connectionType));
        for (PoolSymbol pool : diagram.getPoolSymbols()) {
            connections.addAll((List)pool.eGet(connectionType));
            for (LaneSymbol lane : pool.getLanes()) {
                connections.addAll((List)lane.eGet(connectionType));
            }
        }
        int i = 0;
        while (i < connections.size()) {
            IConnectionSymbol symbol = (IConnectionSymbol)connections.get(i);
            INodeSymbol source = symbol.getSourceNode();
            INodeSymbol target = symbol.getTargetNode();
            if (source instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)source).getModelElement() == first && (second == null || target instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)target).getModelElement() == second) || target instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)target).getModelElement() == first && (second == null || source instanceof IModelElementNodeSymbol && ((IModelElementNodeSymbol)source).getModelElement() == second)) {
                command.add((Command)new DeleteConnectionSymbolCmd(symbol));
            }
            ++i;
        }
    }
}

