/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.modeling.core.editors.parts.properties.BoundEObjectPropertyId;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class EObjectPropertySource
implements IPropertySource {
    private final IPropertyDescriptor[] propDescriptors;
    private final EObject object;

    public EObjectPropertySource(EObject obj, IPropertyDescriptor[] descriptors) {
        this.propDescriptors = descriptors;
        this.object = obj;
    }

    public Object getEditableValue() {
        return this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propDescriptors;
    }

    public Object getPropertyValue(Object id) {
        EStructuralFeature feature = EObjectPropertySource.extractFeature(id);
        EObject target = EObjectPropertySource.extractTarget(id, this.object);
        Object result = target.eGet(feature);
        return result != null ? result : "";
    }

    public boolean isPropertySet(Object id) {
        EStructuralFeature feature = EObjectPropertySource.extractFeature(id);
        EObject target = EObjectPropertySource.extractTarget(id, this.object);
        return target.eIsSet(feature);
    }

    public void resetPropertyValue(Object id) {
        EStructuralFeature feature = EObjectPropertySource.extractFeature(id);
        EObject target = EObjectPropertySource.extractTarget(id, this.object);
        target.eUnset(feature);
    }

    public void setPropertyValue(Object id, Object value) {
        EStructuralFeature feature = EObjectPropertySource.extractFeature(id);
        EObject target = EObjectPropertySource.extractTarget(id, this.object);
        target.eSet(feature, value);
    }

    private static EObject extractTarget(Object propertyId, EObject defaultTarget) {
        EObject target = propertyId instanceof BoundEObjectPropertyId ? ((BoundEObjectPropertyId)propertyId).getObject() : defaultTarget;
        return target;
    }

    private static EStructuralFeature extractFeature(Object propertyId) {
        EStructuralFeature eFtr = null;
        if (propertyId instanceof BoundEObjectPropertyId) {
            eFtr = ((BoundEObjectPropertyId)propertyId).getId();
        } else if (propertyId instanceof EStructuralFeature) {
            eFtr = (EStructuralFeature)propertyId;
        }
        return eFtr;
    }
}

