/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.modeling.core.ui.BooleanPropertyDescriptor;
import org.eclipse.stardust.modeling.core.ui.EEnumPropertyDescriptor;
import org.eclipse.stardust.modeling.core.ui.StringListPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ModelElementPropertySource
implements IPropertySource {
    private final EObject object;

    public ModelElementPropertySource(EObject obj) {
        this.object = obj;
    }

    public Object getEditableValue() {
        return this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        EClass cls = this.object.eClass();
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (EAttribute attr : cls.getEAllAttributes()) {
            EDataType type = attr.getEAttributeType();
            if (attr.isID()) {
                descriptors.add(new PropertyDescriptor((Object)Integer.toString(attr.getFeatureID()), attr.getName()));
                continue;
            }
            if (type.getInstanceClass() == String.class) {
                if (attr.isMany()) {
                    descriptors.add((Object)new StringListPropertyDescriptor(Integer.toString(attr.getFeatureID()), attr.getName()));
                    continue;
                }
                descriptors.add(new TextPropertyDescriptor((Object)Integer.toString(attr.getFeatureID()), attr.getName()));
                continue;
            }
            if (type.getInstanceClass() == Boolean.TYPE) {
                descriptors.add((Object)new BooleanPropertyDescriptor(Integer.toString(attr.getFeatureID()), attr.getName()));
                continue;
            }
            if (!attr.isChangeable() || !(type instanceof EEnum)) continue;
            descriptors.add((Object)new EEnumPropertyDescriptor(Integer.toString(attr.getFeatureID()), attr.getName(), (EEnum)type));
        }
        Iterator i = cls.getEAllReferences().iterator();
        while (i.hasNext()) {
        }
        return descriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        EStructuralFeature feature = this.object.eClass().getEStructuralFeature(Integer.parseInt((String)id));
        Object result = this.object.eGet(feature);
        return result != null ? result : "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        EStructuralFeature feature = this.object.eClass().getEStructuralFeature(Integer.parseInt((String)id));
        this.object.eSet(feature, value);
    }
}

