/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.OutlineTreeEditor;
import org.eclipse.swt.widgets.TreeItem;

public class IdentifiableModelElementTreeEditPart
extends AbstractEObjectTreeEditPart {
    public IdentifiableModelElementTreeEditPart(WorkflowModelEditor editor, IIdentifiableModelElement model, String iconPath) {
        super(editor, (EObject)model, iconPath);
    }

    public IdentifiableModelElementTreeEditPart(WorkflowModelEditor editor, IIdentifiableModelElement model, String iconPath, EStructuralFeature[] childrenFeatures) {
        super(editor, (EObject)model, iconPath, childrenFeatures);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!(this.getModel() instanceof DataType) || !((DataType)this.getModel()).isPredefined()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                protected Command getDirectEditCommand(DirectEditRequest request) {
                    return null;
                }

                protected void showCurrentEditValue(DirectEditRequest request) {
                }
            });
        }
    }

    public void performRequest(Request req) {
        if (req.getType() == "direct edit") {
            WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getEditor().getOutlinePage();
            TreeItem treeItem = (TreeItem)this.getWidget();
            OutlineTreeEditor editor = outline.getOutlineTreeEditor();
            editor.setItem(treeItem, this.getModel());
            return;
        }
        super.performRequest(req);
    }

    @Override
    public String getLabel() {
        IIdentifiableModelElement element = (IIdentifiableModelElement)this.getModel();
        String name = element.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = element.getId();
        }
        if (StringUtils.isEmpty((String)name) && element instanceof EObjectImpl && element.eIsProxy()) {
            name = ((EObjectImpl)element).eProxyURI().toString();
        }
        return StringUtils.isEmpty((String)name) ? Diagram_Messages.MSG_EDITOR_unidentifiedModelElement : name;
    }

    @Override
    public Object getAdapter(Class key) {
        if (IIdentifiableModelElement.class.equals((Object)key) || IIdentifiableElement.class.equals((Object)key) || IModelElement.class.equals((Object)key)) {
            return this.getModel();
        }
        return super.getAdapter(key);
    }

    protected void refreshVisuals() {
        this.setIconPath(this.getEditor().getIconFactory().getIconFor((EObject)((IIdentifiableModelElement)this.getModel())));
        super.refreshVisuals();
    }
}

