/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.tools.AutoexposeTool;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;

public class AutoexposeMarqueeSelectionTool
extends AutoexposeTool {
    public static final Object PROPERTY_MARQUEE_BEHAVIOR = "marqueeBehavior";
    public static final int BEHAVIOR_NODES_CONTAINED = new Integer(1);
    public static final int BEHAVIOR_CONNECTIONS_TOUCHED = new Integer(2);
    public static final int BEHAVIOR_NODES_AND_CONNECTIONS = new Integer(3);
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private Figure marqueeRectangleFigure;
    private Set allChildren = new HashSet();
    private Collection selectedEditParts;
    private Request targetRequest;
    private int marqueeBehavior = BEHAVIOR_NODES_CONTAINED;
    private int mode;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");
    private Point startLocation;
    private Rectangle marqueeRectAbsolute = new Rectangle();

    public AutoexposeMarqueeSelectionTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_MARQUEE_BEHAVIOR.equals(key)) {
            if (value instanceof Integer) {
                this.setMarqueeBehavior((Integer)value);
            }
            return;
        }
        super.applyProperty(key, value);
    }

    private void calculateConnections(Collection newSelections, Collection deselections) {
        HashSet<EditPart> currentNodes = new HashSet<EditPart>();
        if (this.getSelectionMode() != 0) {
            for (EditPart selected : this.getCurrentViewer().getSelectedEditParts()) {
                if (selected instanceof ConnectionEditPart || deselections.contains(selected)) continue;
                currentNodes.add(selected);
            }
        }
        AbstractCollection connections = new ArrayList();
        for (GraphicalEditPart node : newSelections) {
            for (ConnectionEditPart sourceConn : node.getSourceConnections()) {
                if (sourceConn.getSelected() != 0 || !newSelections.contains(sourceConn.getTarget()) && !currentNodes.contains(sourceConn.getTarget())) continue;
                connections.add(sourceConn);
            }
            for (ConnectionEditPart targetConn : node.getTargetConnections()) {
                if (targetConn.getSelected() != 0 || !newSelections.contains(targetConn.getSource()) && !currentNodes.contains(targetConn.getSource())) continue;
                connections.add(targetConn);
            }
        }
        newSelections.addAll(connections);
        connections = new HashSet();
        for (GraphicalEditPart node : deselections) {
            for (ConnectionEditPart sourceConn : node.getSourceConnections()) {
                if (sourceConn.getSelected() == 0) continue;
                connections.add(sourceConn);
            }
            for (ConnectionEditPart targetConn : node.getTargetConnections()) {
                if (targetConn.getSelected() == 0) continue;
                connections.add(targetConn);
            }
        }
        deselections.addAll(connections);
    }

    private void calculateNewSelection(Collection newSelections, Collection deselections) {
        Rectangle marqueeRect = this.getMarqueeSelectionRectangle();
        for (GraphicalEditPart child : this.getAllChildren()) {
            IFigure figure = child.getFigure();
            if (child instanceof DiagramEditPart || !child.isSelectable() || child.getTargetEditPart(MARQUEE_REQUEST) != child) continue;
            INodeSymbol childSymbol = (INodeSymbol)child.getModel();
            EditPart hostEP = null;
            if (child.getParent() instanceof AbstractSwimlaneEditPart) {
                hostEP = child.getParent();
            }
            Rectangle r = figure.getBounds().getCopy();
            IFigure parent = figure.getParent();
            if (parent != null && hostEP != null) {
                DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)childSymbol);
                Point newLocation = PoolLaneUtils.getAbsoluteLocation(hostEP, r.getLocation(), diagram);
                r = new Rectangle(newLocation.x, newLocation.y, r.width, r.height);
            }
            ZoomManager zoomManager = ((ScalableFreeformRootEditPart)this.getCurrentViewer().getRootEditPart()).getZoomManager();
            r.scale(zoomManager.getZoom());
            boolean included = false;
            if (child instanceof ConnectionEditPart && marqueeRect.intersects(r)) {
                Rectangle relMarqueeRect = Rectangle.SINGLETON;
                figure.translateToRelative((Translatable)relMarqueeRect.setBounds(marqueeRect));
                included = ((PolylineConnection)figure).getPoints().intersects(relMarqueeRect);
            } else {
                included = this.marqueeRectAbsolute.contains(r);
            }
            if (!included) continue;
            if (child.getSelected() == 0 || this.getSelectionMode() != 1) {
                newSelections.add(child);
                continue;
            }
            deselections.add(child);
        }
        if (this.marqueeBehavior == BEHAVIOR_NODES_AND_CONNECTIONS) {
            this.calculateConnections(newSelections, deselections);
        }
    }

    private Request createTargetRequest() {
        return MARQUEE_REQUEST;
    }

    @Override
    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        this.setAutoexposeHelper(null);
        super.deactivate();
        this.allChildren.clear();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(this.getTargetRequest());
        }
    }

    private Set getAllChildren() {
        if (this.allChildren.isEmpty()) {
            this.getAllChildren((EditPart)this.getCurrentViewer().getRootEditPart(), this.allChildren);
        }
        return this.allChildren;
    }

    private void getAllChildren(EditPart editPart, Set allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            if (this.marqueeBehavior == BEHAVIOR_NODES_CONTAINED || this.marqueeBehavior == BEHAVIOR_NODES_AND_CONNECTIONS) {
                allChildren.add(child);
            }
            if (this.marqueeBehavior == BEHAVIOR_CONNECTIONS_TOUCHED) {
                allChildren.addAll(child.getSourceConnections());
                allChildren.addAll(child.getTargetConnections());
            }
            this.getAllChildren((EditPart)child, allChildren);
            ++i;
        }
    }

    protected String getCommandName() {
        return "selection";
    }

    protected String getDebugName() {
        return "Autoexpose Marquee Tool: " + this.marqueeBehavior;
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private int getSelectionMode() {
        return this.mode;
    }

    private Request getTargetRequest() {
        if (this.targetRequest == null) {
            this.targetRequest = this.createTargetRequest();
        }
        return this.targetRequest;
    }

    protected boolean handleButtonDown(int button) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            if (this.getCurrentInput().isModKeyDown(SWT.MOD1)) {
                this.setSelectionMode(1);
            } else if (this.getCurrentInput().isShiftKeyDown()) {
                this.setSelectionMode(2);
            } else {
                this.setSelectionMode(0);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = new ArrayList();
            this.calculateNewSelection(this.selectedEditParts, new ArrayList());
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (super.handleKeyDown(e)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(e);
        }
        return false;
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return viewer instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer viewer = this.getCurrentViewer();
        LinkedHashSet newSelections = new LinkedHashSet();
        HashSet deselections = new HashSet();
        this.calculateNewSelection(newSelections, deselections);
        if (this.getSelectionMode() != 0) {
            newSelections.addAll(viewer.getSelectedEditParts());
            newSelections.removeAll(deselections);
        }
        viewer.setSelection((ISelection)new StructuredSelection(newSelections.toArray()));
    }

    public void setMarqueeBehavior(int type) {
        if (type != BEHAVIOR_CONNECTIONS_TOUCHED && type != BEHAVIOR_NODES_CONTAINED && type != BEHAVIOR_NODES_AND_CONNECTIONS) {
            throw new IllegalArgumentException("Invalid marquee behaviour specified.");
        }
        this.marqueeBehavior = type;
    }

    private void setSelectionMode(int mode) {
        this.mode = mode;
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(viewer);
        if (viewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        super.mouseDown(me, viewer);
        this.startLocation = this.getStartLocation().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)this.startLocation);
    }

    private void showMarqueeFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        Point mouseLocation = this.getLocation();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)mouseLocation);
        int width = mouseLocation.x - this.startLocation.x;
        int height = mouseLocation.y - this.startLocation.y;
        int x = width < 0 ? mouseLocation.x : this.startLocation.x;
        int y = height < 0 ? mouseLocation.y : this.startLocation.y;
        rect.setLocation(new Point(x, y));
        rect.setSize(Math.abs(width), Math.abs(height));
        this.getMarqueeFeedbackFigure().setBounds(rect);
        this.marqueeRectAbsolute = rect;
    }

    private void showTargetFeedback() {
        for (EditPart editPart : this.selectedEditParts) {
            editPart.showTargetFeedback(this.getTargetRequest());
        }
    }

    class MarqueeRectangleFigure
    extends Figure {
        private static final int DELAY = 110;
        private int offset = 0;
        private boolean schedulePaint = true;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(){

                    @Override
                    public void run() {
                        MarqueeRectangleFigure marqueeRectangleFigure = MarqueeRectangleFigure.this;
                        marqueeRectangleFigure.offset = marqueeRectangleFigure.offset + 1;
                        if (MarqueeRectangleFigure.this.offset > 5) {
                            MarqueeRectangleFigure.this.offset = 0;
                        }
                        MarqueeRectangleFigure.this.schedulePaint = true;
                        MarqueeRectangleFigure.this.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }
    }
}

