/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.ui.palette.editparts.IPaletteStackEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.stardust.modeling.core.editors.tools.DynamicCreationToolEntry;
import org.eclipse.stardust.modeling.core.editors.tools.DynamicToolEntry;
import org.eclipse.stardust.modeling.core.editors.tools.PaletteFlyout;
import org.eclipse.stardust.modeling.core.editors.tools.SetActiveFlyoutToolAction;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class PaletteFlyoutEditPart
extends PaletteEditPart
implements IPaletteStackEditPart {
    private final DynamicToolEntry myEntry;
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private ChangeListener clickableListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            if (PaletteFlyoutEditPart.this.activeFigure != null) {
                if (event.getPropertyName().equals("mouseover")) {
                    PaletteFlyoutEditPart.this.getMyEntryFigure().getModel().setMouseOver(PaletteFlyoutEditPart.this.activeFigure.getModel().isMouseOver());
                } else if (event.getPropertyName().equals("selected")) {
                    PaletteFlyoutEditPart.this.getMyEntryFigure().getModel().setSelected(PaletteFlyoutEditPart.this.activeFigure.getModel().isSelected());
                    PaletteFlyoutEditPart.this.getMyEntryFigure().getModel().setMouseOver(PaletteFlyoutEditPart.this.activeFigure.getModel().isMouseOver());
                    PaletteFlyoutEditPart.this.getMyEntryFigure().getModel().setPressed(PaletteFlyoutEditPart.this.activeFigure.getModel().isPressed());
                } else if (event.getPropertyName().equals("pressed")) {
                    PaletteFlyoutEditPart.this.getMyEntryFigure().getModel().setPressed(PaletteFlyoutEditPart.this.activeFigure.getModel().isPressed());
                }
            }
        }
    };
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
            if (PaletteFlyoutEditPart.this.getToolContainer().getChildren().contains(tool) && !PaletteFlyoutEditPart.this.getToolContainer().getActiveEntry().equals(tool)) {
                PaletteFlyoutEditPart.this.getToolContainer().setActiveEntry((PaletteEntry)tool);
            }
        }
    };
    private Clickable activeFigure;
    private Figure contentsFigure;
    private Menu menu;

    public PaletteFlyoutEditPart(PaletteFlyout model) {
        super((PaletteEntry)model);
        this.myEntry = new DynamicCreationToolEntry(model.getLabel(), model.getDescription(), model.getSmallIcon(), model.getLargeIcon());
    }

    public void activate() {
        this.checkActiveEntrySync();
        ((PaletteViewer)this.getViewer()).addPaletteListener(this.paletteListener);
        super.activate();
    }

    private void activeEntryChanged(Object oldValue, Object newValue) {
        GraphicalEditPart part = null;
        Clickable clickable = null;
        if (newValue != null) {
            part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(newValue);
            this.activeFigure = clickable = (Clickable)part.getFigure();
            clickable.addChangeListener(this.clickableListener);
        }
        if (oldValue != null && (part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(oldValue)) != null) {
            clickable = (Clickable)part.getFigure();
            clickable.setVisible(false);
            clickable.removeChangeListener(this.clickableListener);
        }
        this.getMyEntryFigure().setVisible(true);
    }

    private void checkActiveEntrySync() {
        if (this.activeFigure == null) {
            this.activeEntryChanged(null, this.getToolContainer().getActiveEntry());
        }
    }

    public IFigure createFigure() {
        Figure figure = new Figure(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                if (PaletteFlyoutEditPart.this.getChildren().isEmpty()) {
                    return EMPTY_DIMENSION;
                }
                return super.getPreferredSize(wHint, hHint);
            }

            public void paintBorder(Graphics graphics) {
                int layoutMode = PaletteFlyoutEditPart.this.getPreferenceSource().getLayoutSetting();
                if (layoutMode == 0 || layoutMode == 3) {
                    // empty if block
                }
                Rectangle rect = this.getBounds().getCopy();
                graphics.translate(this.getLocation());
                graphics.setBackgroundColor(ColorConstants.listForeground);
                int[] points = new int[]{rect.width, rect.height - 5, rect.width, rect.height, rect.width - 5, rect.height};
                graphics.fillPolygon(points);
                graphics.translate(this.getLocation().getNegated());
            }
        };
        figure.setLayoutManager((LayoutManager)new BorderLayout());
        this.contentsFigure = new Figure();
        StackLayout stackLayout = new StackLayout();
        stackLayout.setObserveVisibility(true);
        this.contentsFigure.setLayoutManager((LayoutManager)stackLayout);
        figure.add((IFigure)this.contentsFigure, (Object)BorderLayout.CENTER);
        return figure;
    }

    public void deactivate() {
        ((PaletteViewer)this.getViewer()).removePaletteListener(this.paletteListener);
        super.deactivate();
    }

    public void eraseTargetFeedback(Request request) {
        for (PaletteEditPart part : this.getChildren()) {
            part.eraseTargetFeedback(request);
        }
        super.eraseTargetFeedback(request);
    }

    public IFigure getContentPane() {
        return this.contentsFigure;
    }

    private PaletteFlyout getToolContainer() {
        return (PaletteFlyout)((Object)this.getModel());
    }

    public void openMenu() {
        MenuManager menuManager = new MenuManager();
        PaletteViewer paletteViewer = (PaletteViewer)this.getViewer();
        PaletteEditPart part2 = null;
        PaletteEntry entry = null;
        for (PaletteEditPart part2 : this.getChildren()) {
            entry = (PaletteEntry)part2.getModel();
            if (this.myEntry == entry) continue;
            menuManager.add((IAction)new SetActiveFlyoutToolAction(paletteViewer, entry.getLabel(), entry.getSmallIcon(), (ToolEntry)entry));
        }
        this.menu = menuManager.createContextMenu(paletteViewer.getControl());
        Rectangle figureBounds = this.getFigure().getBounds().getCopy();
        this.getFigure().translateToAbsolute((Translatable)figureBounds);
        Point menuLocation = paletteViewer.getControl().toDisplay(figureBounds.getTopRight().x, figureBounds.getTopRight().y);
        if (this.activeFigure != null) {
            this.activeFigure.getModel().setMouseOver(false);
        }
        this.eraseTargetFeedback(new Request((Object)"selection"));
        this.menu.setLocation(menuLocation);
        this.menu.addMenuListener((MenuListener)new StackMenuListener(this.menu, this.getViewer().getControl().getDisplay()));
        this.menu.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Active Entry")) {
            this.activeEntryChanged(event.getOldValue(), event.getNewValue());
        } else {
            super.propertyChange(event);
        }
    }

    public List getModelChildren() {
        ArrayList<DynamicToolEntry> result = new ArrayList<DynamicToolEntry>(super.getModelChildren());
        result.add(0, this.myEntry);
        return result;
    }

    protected void refreshChildren() {
        super.refreshChildren();
        for (PaletteEditPart editPart : this.getChildren()) {
            editPart.getFigure().setVisible(this.myEntry == editPart.getModel());
        }
    }

    public void showTargetFeedback(Request request) {
        if (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
            return;
        }
        for (PaletteEditPart part : this.getChildren()) {
            part.showTargetFeedback(request);
        }
        super.showTargetFeedback(request);
    }

    private Clickable getMyEntryFigure() {
        GraphicalEditPart part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get((Object)this.myEntry);
        return (Clickable)part.getFigure();
    }

    public PaletteEditPart getActiveEntry() {
        return this;
    }

    class StackMenuListener
    extends MenuAdapter {
        private Menu menu;
        private Display d;

        StackMenuListener(Menu menu, Display d) {
            this.menu = menu;
            this.d = d;
        }

        public void menuHidden(MenuEvent e) {
            if (PaletteFlyoutEditPart.this.activeFigure != null && !PaletteFlyoutEditPart.this.activeFigure.isSelected()) {
                PaletteFlyoutEditPart.this.clickableListener.handleStateChanged(new ChangeEvent((Object)PaletteFlyoutEditPart.this.activeFigure, "selected"));
            }
            this.d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (StackMenuListener.this.menu != null) {
                        if (!StackMenuListener.this.menu.isDisposed()) {
                            StackMenuListener.this.menu.dispose();
                        }
                        StackMenuListener.this.menu = null;
                    }
                }
            });
        }
    }
}

