/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;

public class ViewportScrollHelper {
    private GraphicalEditPart part;
    private ScrollingGraphicalViewer viewer;

    public ViewportScrollHelper(GraphicalEditPart part, ScrollingGraphicalViewer viewer) {
        this.part = part;
        this.viewer = viewer;
    }

    public void updateViewport(Point location) {
        Viewport viewport = this.findViewport();
        Point viewPortLoc = viewport.getLocation();
        Rectangle rect = viewport.getClientArea();
        Rectangle smallRect = new Rectangle(viewPortLoc.x + 30, viewPortLoc.y + 30, rect.width - 60, rect.height - 60);
        viewPortLoc.x = rect.x;
        viewPortLoc.y = rect.y;
        if (!smallRect.contains(location)) {
            int scrollX = viewPortLoc.x;
            int scrollY = viewPortLoc.y;
            int region = smallRect.getPosition(location);
            int scrollOffset = 10;
            if (region == 1) {
                scrollY = viewPortLoc.y - scrollOffset;
            } else if (region == 4) {
                scrollY = viewPortLoc.y + scrollOffset;
            }
            if (region == 8) {
                scrollX = viewPortLoc.x - scrollOffset;
            } else if (region == 16) {
                scrollX = viewPortLoc.x + scrollOffset;
            }
            ((FigureCanvas)this.viewer.getControl()).scrollSmoothTo(scrollX, scrollY);
        }
    }

    protected Viewport findViewport() {
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? this.part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != this.part.getFigure() && figure != null);
        return port;
    }
}

