/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.IconWithOverlays;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class CarnotPreferenceNode
extends PreferenceNode {
    private IWorkbenchPropertyPage page;
    public static final int LABEL_ORDER = -1;
    public static final int INSERTION_ORDER = -2;
    public static final int SPI_ELEMENT = 1000;
    private ConfigurationElement template;
    private IAdaptable element;
    private String executableAttributeName = "propertyPageClass";
    private Image image;
    private String text;
    private IQuickValidationStatus pageStatus;
    private int overlayStyle = IconWithOverlays.OVR_NONE;
    private Image overlaidImage;
    private int sortOrder;
    public String category;
    private String id;

    public CarnotPreferenceNode(ConfigurationElement template, IAdaptable element) {
        this(template, element, -1);
    }

    public CarnotPreferenceNode(ConfigurationElement template, IAdaptable element, int sortOrder) {
        super(CarnotPreferenceNode.getId(template), CarnotPreferenceNode.getName(template), null, null);
        this.setLabelImage(DiagramPlugin.getImage(template.getAttribute("icon")));
        this.category = template.getAttribute("category");
        this.element = element;
        this.template = template;
        this.sortOrder = sortOrder;
    }

    public CarnotPreferenceNode(ConfigurationElement template, IAdaptable element, String executableAttributeName, int sortOrder) {
        this(template, element, sortOrder);
        this.executableAttributeName = executableAttributeName;
    }

    private static String getName(ConfigurationElement template) {
        String name = template.getAttribute("name");
        return name == null ? "" : name;
    }

    private static String getId(ConfigurationElement template) {
        String id = template.getAttribute("id");
        return id == null ? "<undefinedId>" + Integer.toString(template.hashCode()) : ModelElementPropertyDialog.convertId(id);
    }

    public String getId() {
        return this.id == null ? super.getId() : this.id;
    }

    public String toString() {
        return this.getId();
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void createPage() {
        try {
            this.page = (IWorkbenchPropertyPage)this.template.createExecutableExtension(this.executableAttributeName);
            this.internalSetPage(this.page);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IAdaptable getAdaptable() {
        return this.element;
    }

    public void internalSetPage(IWorkbenchPropertyPage page) {
        page.setElement(this.getAdaptable());
        page.setTitle(this.getLabelText());
        this.setPage((IPreferencePage)page);
    }

    public String getLabelText() {
        return this.text == null ? super.getLabelText() : this.text;
    }

    public void setLabelText(String text) {
        this.text = text;
    }

    public Image getLabelImage() {
        Image img = this.overlaidImage != null ? this.overlaidImage : this.image;
        return img != null ? img : super.getLabelImage();
    }

    public void setLabelImage(Image image) {
        this.image = image;
        this.updatePageStatus(this.pageStatus);
    }

    public void updatePageStatus(IQuickValidationStatus status) {
        this.pageStatus = status;
        if (status != null && status.hasErrors()) {
            this.setOverlayIcon(IconWithOverlays.OVR_ERRORS);
        } else if (status != null && status.hasWarnings()) {
            this.setOverlayIcon(IconWithOverlays.OVR_WARNINGS);
        } else {
            this.setOverlayIcon(IconWithOverlays.OVR_NONE);
        }
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void disposeResources() {
        this.setOverlayIcon(IconWithOverlays.OVR_NONE);
        super.disposeResources();
    }

    private void setOverlayIcon(int style) {
        if (style != this.overlayStyle) {
            if (this.overlaidImage != null) {
                this.overlaidImage.dispose();
                this.overlaidImage = null;
            }
            this.overlayStyle = IconWithOverlays.OVR_NONE;
            if (IconWithOverlays.OVR_NONE != style) {
                Image img;
                Image image = img = this.image != null ? this.image : super.getLabelImage();
                if (img != null) {
                    this.overlaidImage = new IconWithOverlays(img, style).createImage();
                    this.overlayStyle = style;
                } else {
                    this.overlayStyle = IconWithOverlays.OVR_NONE;
                }
            }
        }
    }

    public void setId(String id) {
        this.id = id;
    }
}

