/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.graphics.Image;

public class ConfigurationElementLabelProvider
implements TableLabelProvider {
    private static TableLabelProvider instance = new ConfigurationElementLabelProvider();

    @Override
    public String getText(int index, Object element) {
        ConfigurationElement config = (ConfigurationElement)element;
        String name = null;
        String[] names = config.getAttributeNames();
        if (index < names.length) {
            name = names[index];
        }
        return this.getText(name, element);
    }

    @Override
    public String getText(String name, Object element) {
        ConfigurationElement config = (ConfigurationElement)element;
        String value = name == null ? null : config.getAttribute(name);
        return value == null ? "" : value.toString();
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    @Override
    public boolean accept(Object element) {
        return element instanceof ConfigurationElement;
    }

    @Override
    public Image getImage(Object element) {
        ConfigurationElement config = (ConfigurationElement)element;
        String icon = config.getAttribute("icon");
        return icon == null ? null : DiagramPlugin.getImage(icon);
    }

    public static TableLabelProvider instance() {
        return instance;
    }
}

