/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.IconWithOverlays;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.swt.graphics.Image;

public class IdentifiableLabelProvider
extends EObjectLabelProvider {
    private ModelType model;
    private boolean showGroupInfo = false;

    public IdentifiableLabelProvider(WorkflowModelEditor editor) {
        super(editor);
    }

    @Override
    public String getText(Object element) {
        IIdentifiableModelElement pdt;
        ModelType model;
        if (element instanceof IIdentifiableModelElement && this.showGroupInfo && (model = ModelUtils.findContainingModel((EObject)(pdt = (IIdentifiableModelElement)element))) != this.model) {
            String modelName;
            String string = modelName = model == null ? "null" : model.getName();
            if (modelName == null && (modelName = model.getId()) == null) {
                modelName = "<Model>";
            }
            return String.valueOf(modelName) + " / " + pdt.getName();
        }
        return super.getText(element);
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    public boolean isShowGroupInfo() {
        return this.showGroupInfo;
    }

    public void setShowGroupInfo(boolean showGroupInfo) {
        this.showGroupInfo = showGroupInfo;
    }

    @Override
    public Image getImage(Object element) {
        Image image = super.getImage(element);
        IIdentifiableModelElement pdt = (IIdentifiableModelElement)element;
        ModelType model = ModelUtils.findContainingModel((EObject)pdt);
        if (model != this.model) {
            ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)image);
            IconWithOverlays icon = new IconWithOverlays(descriptor, IconWithOverlays.OVR_REF);
            return icon.createImage();
        }
        return image;
    }
}

