/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.modeling.common.platform.utils.ItemConsumer;
import org.eclipse.stardust.modeling.common.platform.utils.ItemProducer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.DefaultTableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableManager;
import org.eclipse.stardust.modeling.core.editors.ui.TextTableCombo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeFinderListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.progress.UIJob;

public class JavaTypeCombo
extends TextTableCombo {
    private LabelProvider postLabelProvider = new JavaElementLabelProvider(2048);
    private LabelProvider preLabelProvider = new JavaElementLabelProvider(1024);
    private TypeFinder finder = null;
    private String interfaceFilter;
    private String classFilter;

    public JavaTypeCombo(Composite parent, TypeFinder finder, int style) {
        super(parent, style);
        this.getTableManager().addLabelProvider(new DefaultTableLabelProvider(this.postLabelProvider));
        this.setTypeFinder(finder);
    }

    private boolean matchFilters(IType type) {
        return !(this.interfaceFilter != null && !this.finder.implementsInterface(type, this.interfaceFilter) || this.classFilter != null && !this.finder.extendsClass(type, this.classFilter));
    }

    @Override
    public String getTextAtSelection() {
        TableManager manager = this.getTableManager();
        Object selection = manager.getSelectedItem();
        return selection == null ? "" : this.preLabelProvider.getText(selection);
    }

    public void setInterfaceFilter(String filter) {
        this.interfaceFilter = filter;
    }

    public void setClassFilter(String filter) {
        this.classFilter = filter;
    }

    public void setTypeFinder(TypeFinder finder) {
        this.finder = finder;
        this.setDataProducer(finder == null ? null : new ItemProducer(){

            public void produce(String hint, final ItemConsumer consumer) {
                JavaTypeCombo.this.finder.findTypes(hint, new TypeFinderListener(){

                    public void typeFound(final IType type) {
                        if (JavaTypeCombo.this.matchFilters(type)) {
                            new UIJob(Diagram_Messages.JOB_TypeSearch){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    consumer.addData((Object)type);
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                    }

                    public void startSearch() {
                    }

                    public void endSearch() {
                    }
                });
            }
        });
    }
}

