/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import com.gface.date.DatePickerCombo;
import com.gface.date.DateSelectedEvent;
import com.gface.date.DateSelectionListener;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.stardust.modeling.core.editors.ui.DateUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public class SwtDatePickerAdapter
extends SwtWidgetAdapter {
    private DateSelectionListener listener;
    private Button resetBtn;

    public SwtDatePickerAdapter(DatePickerCombo datePickerCombo) {
        super((Widget)datePickerCombo);
    }

    public SwtDatePickerAdapter(DatePickerCombo datePickerCombo, Button resetBtn) {
        super((Widget)datePickerCombo);
        this.resetBtn = resetBtn;
    }

    public void updateControl(Object value) {
        if (value != null) {
            try {
                Date date = DateUtils.getNonInteractiveDateFormat().parse((String)value);
                ((DatePickerCombo)this.getWidget()).setDate(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void bind(IBindingMediator manager) {
        super.bind(manager);
        final DatePickerCombo datePickerCombo = (DatePickerCombo)this.getWidget();
        this.listener = new DateSelectionListener(){

            public void dateSelected(DateSelectedEvent e) {
                Date date = ((DatePickerCombo)SwtDatePickerAdapter.this.getWidget()).getDate();
                String value = date == null ? "" : DateUtils.getNonInteractiveDateFormat().format(date);
                SwtDatePickerAdapter.this.updateModel(value);
            }
        };
        datePickerCombo.addDateSelectionListener(this.listener);
        if (this.resetBtn != null) {
            this.resetBtn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    datePickerCombo.setDate(null);
                    SwtDatePickerAdapter.this.updateModel(null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public void unbind() {
        if (this.listener != null) {
            if (!this.getWidget().isDisposed()) {
                ((DatePickerCombo)this.getWidget()).removeDateSelectionListener(this.listener);
            }
            this.listener = null;
        }
        super.unbind();
    }
}

