/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.ui.DefaultTableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.SnapshotNode;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TableManager
implements ControlListener {
    private String[] attributeNames;
    private int[] columnSizes;
    private String defaultIcon;
    private Control control;
    private Map editors;
    BindingManager binding = new BindingManager();
    private ArrayList providers = new ArrayList();

    public TableManager(Table table) {
        this.setControl((Control)table);
    }

    public TableManager(Tree tree) {
        this.setControl((Control)tree);
    }

    public boolean isDisposed() {
        return this.control == null || this.control.isDisposed();
    }

    private void setControl(Control control) {
        this.control = control;
        control.addControlListener((ControlListener)this);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableManager.this.binding.dispose();
            }
        });
    }

    public void addLabelProvider(TableLabelProvider labelProvider) {
        this.providers.add(labelProvider);
    }

    public int getRowCount() {
        if (this.control instanceof Table) {
            return ((Table)this.control).getItemCount();
        }
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getItemCount();
        }
        return 1;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.resize();
    }

    public void setColumnSizes(int[] columnSizes) {
        this.columnSizes = columnSizes;
        this.resize();
    }

    private void resize() {
        if (!this.control.isDisposed() && this.getColumnCount() > 0 && this.columnSizes != null) {
            int cumulated = 0;
            int percentage = 0;
            int size = this.control.getSize().x - this.control.getBorderWidth() * 2;
            if (this.control instanceof Scrollable) {
                Rectangle clientArea = ((Scrollable)this.control).getClientArea();
                size = clientArea.width;
            }
            int i = 0;
            while (i < this.columnSizes.length) {
                if (i == this.getColumnCount()) break;
                int cs = (percentage += this.columnSizes[i]) == 100 ? size - cumulated : size * this.columnSizes[i] / 100;
                this.setColumnWidth(i, cs);
                cumulated += cs;
                ++i;
            }
        }
    }

    private int getColumnCount() {
        if (this.control instanceof Table) {
            return ((Table)this.control).getColumnCount();
        }
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getColumnCount();
        }
        return 1;
    }

    private void setColumnWidth(int columnIndex, int size) {
        if (this.control instanceof Table) {
            TableColumn column = ((Table)this.control).getColumn(columnIndex);
            column.setWidth(size);
        } else if (this.control instanceof Tree) {
            TreeColumn column = ((Tree)this.control).getColumn(columnIndex);
            column.setWidth(size);
        }
    }

    public Image[] getColumnImage(Object element) {
        Image[] imageArray;
        TableLabelProvider provider = this.getProvider(element);
        Image image = provider.getImage(element);
        if (image == null && this.defaultIcon != null) {
            image = DiagramPlugin.getImage(this.defaultIcon);
        }
        if (image == null) {
            imageArray = new Image[]{};
        } else {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        }
        return imageArray;
    }

    public String[] getColumnText(Object element) {
        String[] text = new String[this.getColumnCount()];
        TableLabelProvider provider = this.getProvider(element);
        int i = 0;
        while (i < text.length) {
            text[i] = this.attributeNames != null && i < this.attributeNames.length && provider.isNamed() ? provider.getText(this.attributeNames[i], element) : provider.getText(i, element);
            ++i;
        }
        return text;
    }

    private TableLabelProvider getProvider(Object element) {
        int i = 0;
        while (i < this.providers.size()) {
            TableLabelProvider provider = (TableLabelProvider)this.providers.get(i);
            if (provider.accept(element)) {
                return provider;
            }
            ++i;
        }
        return DefaultTableLabelProvider.instance();
    }

    public void setColumnNames(String[] columnNames) {
        if (!this.control.isDisposed()) {
            int i = 0;
            while (i < columnNames.length) {
                TableColumn column;
                if (this.control instanceof Table) {
                    column = i == this.getColumnCount() ? new TableColumn((Table)this.control, 0) : ((Table)this.control).getColumn(i);
                    column.setText(columnNames[i]);
                } else if (this.control instanceof Tree) {
                    column = i == this.getColumnCount() ? new TreeColumn((Tree)this.control, 0) : ((Tree)this.control).getColumn(i);
                    column.setText(columnNames[i]);
                }
                ++i;
            }
        }
    }

    public void setAttributeNames(String[] attributeNames) {
        this.attributeNames = attributeNames;
    }

    public void removeAll() {
        this.binding.dispose();
        if (this.control instanceof Table) {
            ((Table)this.control).removeAll();
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).removeAll();
        }
    }

    public void removeAll(Object root) {
        Item item = this.findItem(root);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            int i = 0;
            while (i < treeItem.getItemCount()) {
                this.binding.unbind(treeItem.getItem(i).getData());
                ++i;
            }
            treeItem.removeAll();
        }
    }

    public Object getElementAt(int[] index) {
        Item item = this.getItem(index);
        return item == null ? null : item.getData();
    }

    public void addElement(Object element) {
        this.addElement(null, element);
    }

    public Item addElement(Object parent, Object element) {
        TableItem newItem = null;
        if (!this.control.isDisposed()) {
            if (this.control instanceof Table) {
                newItem = this.createTableItem(element);
            } else if (this.control instanceof Tree) {
                TreeItem parentItem = (TreeItem)(parent == null ? null : this.findItem(parent));
                newItem = this.createTreeItem(parentItem, element);
            }
        }
        return newItem;
    }

    private TableItem createTableItem(Object element) {
        return this.createTableItem(this.getRowCount(), element);
    }

    private TableItem createTableItem(int index, Object element) {
        TableItem item = new TableItem((Table)this.control, 0, index);
        item.setData(element);
        if (element instanceof EObject) {
            this.binding.bind((EObject)element, this.getBinder((EObject)element, (Item)item));
        } else {
            item.setText(this.getColumnText(element));
            item.setImage(this.getColumnImage(element));
        }
        return item;
    }

    private IWidgetAdapter getBinder(final EObject element, Item item) {
        return new SwtWidgetAdapter((Widget)item){

            public void updateControl(Object value) {
                Widget item = this.getWidget();
                if (item instanceof TableItem) {
                    ((TableItem)item).setText(TableManager.this.getColumnText(element));
                    ((TableItem)item).setImage(TableManager.this.getColumnImage(element));
                } else if (item instanceof TreeItem) {
                    ((TreeItem)item).setText(TableManager.this.getColumnText(element));
                    ((TreeItem)item).setImage(TableManager.this.getColumnImage(element));
                }
            }
        };
    }

    private TreeItem createTreeItem(TreeItem parentItem, Object element) {
        TreeItem item = parentItem == null ? new TreeItem((Tree)this.control, 0) : new TreeItem(parentItem, 0);
        item.setData(element);
        if (element instanceof EObject) {
            this.binding.bind((EObject)element, this.getBinder((EObject)element, (Item)item));
        } else {
            item.setText(this.getColumnText(element));
            item.setImage(this.getColumnImage(element));
        }
        if (parentItem != null) {
            parentItem.setExpanded(true);
        }
        return item;
    }

    public void setGrayed(Object element, boolean grayed) {
        Item item = this.findItem(element);
        if (item instanceof TableItem) {
            ((TableItem)item).setGrayed(grayed);
            ((TableItem)item).setForeground(grayed ? ColorConstants.gray : ColorConstants.listForeground);
        } else if (item instanceof TreeItem) {
            ((TreeItem)item).setGrayed(grayed);
            ((TreeItem)item).setForeground(grayed ? ColorConstants.gray : ColorConstants.listForeground);
        }
    }

    public boolean getGrayed(Object element) {
        Item item = this.findItem(element);
        if (item instanceof TableItem) {
            return ((TableItem)item).getGrayed();
        }
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getGrayed();
        }
        return false;
    }

    public void setChecked(Object element, boolean checked) {
        Item item = this.findItem(element);
        if (item instanceof TableItem) {
            ((TableItem)item).setChecked(checked);
        } else if (item instanceof TreeItem) {
            ((TreeItem)item).setChecked(checked);
        }
    }

    public boolean getChecked(int index) {
        return this.isItemChecked(this.getItem(new int[]{index}));
    }

    public boolean getChecked(Object element) {
        return this.isItemChecked(this.findItem(element));
    }

    private boolean isItemChecked(Item item) {
        if (item instanceof TableItem) {
            return ((TableItem)item).getChecked();
        }
        if (item instanceof TreeItem) {
            ((TreeItem)item).getChecked();
        }
        return false;
    }

    private Item getItem(int[] index) {
        if (this.control instanceof Table) {
            return ((Table)this.control).getItem(index[0]);
        }
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getItem(index[0]);
        }
        return null;
    }

    private Item findItem(Object element) {
        int[] i = new int[1];
        int rowCount = this.getRowCount();
        i[0] = 0;
        while (i[0] < rowCount) {
            Item item = this.findItem(this.getItem(i), element);
            if (item != null) {
                return item;
            }
            i[0] = i[0] + 1;
        }
        return null;
    }

    private Item findItem(Item item, Object element) {
        if (item != null && element.equals(item.getData())) {
            return item;
        }
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            int itemCount = treeItem.getItemCount();
            int i = 0;
            while (i < itemCount) {
                item = this.findItem((Item)treeItem.getItem(i), element);
                if (item != null) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    public void setDefaultIcon(String defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public void setTopIndex(int[] index) {
        if (this.control instanceof Table) {
            ((Table)this.control).setTopIndex(index[0]);
        } else if (this.control instanceof Tree) {
            TreeItem item = (TreeItem)this.getItem(index);
            ((Tree)this.control).setTopItem(item);
        }
    }

    public void selectByText(String text) {
        if (!(this.control instanceof Table)) {
            boolean cfr_ignored_0 = this.control instanceof Tree;
        }
    }

    public void setSelection(int[] index) {
        if (this.control instanceof Table) {
            ((Table)this.control).setSelection(index.length > 0 ? index[0] : 0);
        } else if (this.control instanceof Tree) {
            ArrayList items = this.getTreeItems(index);
            ((Tree)this.control).setSelection(items.toArray(new TreeItem[items.size()]));
        }
    }

    private ArrayList getTreeItems(int[] index) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem top = ((Tree)this.control).getItem(index[0]);
        if (top != null) {
            items.add(top);
            int i = 1;
            while (i < index.length) {
                TreeItem item = top.getItem(index[i]);
                if (item != null) {
                    top = item;
                    items.add(top);
                }
                ++i;
            }
        }
        return items;
    }

    public int[] getSelectionIndex() {
        TreeItem[] items;
        int[] selection = null;
        if (this.control instanceof Table) {
            selection = new int[]{((Table)this.control).getSelectionIndex()};
        } else if (this.control instanceof Tree && (items = ((Tree)this.control).getSelection()).length > 0) {
            selection = new int[items.length];
            selection[0] = ((Tree)this.control).indexOf(items[0]);
            int i = 1;
            while (i < items.length) {
                selection[i] = items[i - 1].indexOf(items[i]);
                ++i;
            }
        }
        if (selection == null) {
            selection = new int[]{-1};
        }
        return selection;
    }

    public void showSelection() {
        if (this.control instanceof Table) {
            ((Table)this.control).showSelection();
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).showSelection();
        }
    }

    public void deselect(int index) {
        if (this.control instanceof Table) {
            ((Table)this.control).deselect(index);
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).deselectAll();
        }
    }

    public void deselectAll() {
        if (this.control instanceof Table) {
            ((Table)this.control).deselectAll();
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).deselectAll();
        }
    }

    public Object getSelectedItem() {
        TableItem[] selection = null;
        if (this.control instanceof Table) {
            selection = ((Table)this.control).getSelection();
        } else if (this.control instanceof Tree) {
            selection = ((Tree)this.control).getSelection();
        }
        return selection.length > 0 ? selection[selection.length - 1].getData() : null;
    }

    public TreeItem getSelectedTreeItem() {
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getSelection()[0];
        }
        return null;
    }

    public void setHeaderVisible(boolean visible) {
        if (this.control instanceof Table) {
            ((Table)this.control).setHeaderVisible(visible);
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).setHeaderVisible(visible);
        }
    }

    public Point computeSize(int wHint, int itemCount, boolean changed) {
        int itemHeight = -1;
        if (itemCount != -1) {
            if (this.control instanceof Table) {
                itemHeight = ((Table)this.control).getItemHeight() * itemCount;
            } else if (this.control instanceof Tree) {
                itemHeight = ((Tree)this.control).getItemHeight() * itemCount;
            }
        }
        return this.control.computeSize(-1, itemHeight, changed);
    }

    public void expandAll() {
        if (this.control instanceof Tree) {
            TreeItem[] items = ((Tree)this.control).getItems();
            int i = 0;
            while (i < items.length) {
                items[i].setExpanded(true);
                ++i;
            }
        }
    }

    public void setInPlaceEditor(Object element, Control cellEditor, int column) {
        Item item = this.findItem(element);
        if (item != null && this.control instanceof Tree) {
            TreeEditor editor = (TreeEditor)this.getEditor(element);
            Control oldEditor = editor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
            cellEditor.setBackground(this.control.getBackground());
            cellEditor.setForeground(this.control.getForeground());
            editor.setEditor(cellEditor, (TreeItem)item, column);
        }
    }

    private ControlEditor getEditor(Object element) {
        ControlEditor editor;
        if (this.editors == null) {
            this.editors = new HashMap();
        }
        if ((editor = (ControlEditor)this.editors.get(element)) == null) {
            if (this.control instanceof Tree) {
                editor = new TreeEditor((Tree)this.control);
            }
            editor.grabHorizontal = true;
            this.editors.put(element, editor);
        }
        return editor;
    }

    public Control getInPlaceEditor(Object element) {
        ControlEditor editor = this.editors == null ? null : this.editors.get(element);
        return editor == null ? null : editor.getEditor();
    }

    public void updateItem(Object o) {
        Item item = this.findItem(o);
        if (item instanceof TreeItem) {
            ((TreeItem)item).setText(this.getColumnText(o));
            ((TreeItem)item).setImage(this.getColumnImage(o));
        } else if (item instanceof TableItem) {
            ((TableItem)item).setText(this.getColumnText(o));
            ((TableItem)item).setImage(this.getColumnImage(o));
        }
    }

    public List getChildren(Object parent) {
        if (this.control instanceof Tree) {
            TreeItem[] items = null;
            if (parent == null) {
                items = ((Tree)this.control).getItems();
            } else {
                TreeItem item = (TreeItem)this.findItem(parent);
                if (item != null) {
                    items = item.getItems();
                }
            }
            if (items != null) {
                ArrayList<Object> result = new ArrayList<Object>(items.length);
                int i = 0;
                while (i < items.length) {
                    result.add(items[i].getData());
                    ++i;
                }
                return result;
            }
        } else if (this.control instanceof Table && parent == null) {
            TableItem[] items = ((Table)this.control).getItems();
            ArrayList<Object> result = new ArrayList<Object>(items.length);
            int i = 0;
            while (i < items.length) {
                result.add(items[i].getData());
                ++i;
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public void select(Object object) {
        if (this.control instanceof Table) {
            ((Table)this.control).setSelection(new TableItem[]{(TableItem)this.findItem(object)});
        } else if (this.control instanceof Tree) {
            ((Tree)this.control).setSelection(new TreeItem[]{(TreeItem)this.findItem(object)});
        }
    }

    public void setFocus() {
        this.control.setFocus();
    }

    public void setRedraw(boolean redraw) {
        this.control.setRedraw(redraw);
    }

    public boolean isExpanded(Object o) {
        Item item = this.findItem(o);
        return item instanceof TreeItem ? ((TreeItem)item).getExpanded() : false;
    }

    public void setExpanded(Object o, boolean expanded) {
        Item item = this.findItem(o);
        if (item instanceof TreeItem) {
            ((TreeItem)item).setExpanded(expanded);
        }
    }

    public Object getExpandedSnapshot() {
        return this.getExpandedSnapshot(null);
    }

    public Object getExpandedSnapshot(List subset) {
        HashMap states = new HashMap();
        int[] i = new int[1];
        int rowCount = this.getRowCount();
        i[0] = 0;
        while (i[0] < rowCount) {
            Item item = this.getItem(i);
            this.getExpandedSnapshot(states, item, subset);
            i[0] = i[0] + 1;
        }
        return states;
    }

    private void getExpandedSnapshot(Map states, Item item, List subset) {
        Object o = item.getData();
        if (item instanceof TableItem) {
            if (subset == null || subset.contains(o)) {
                states.put(o, Boolean.FALSE);
            }
        } else if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            if (subset == null || subset.contains(o)) {
                states.put(o, treeItem.getExpanded() ? Boolean.TRUE : Boolean.FALSE);
            }
            int itemCount = treeItem.getItemCount();
            int i = 0;
            while (i < itemCount) {
                this.getExpandedSnapshot(states, (Item)treeItem.getItem(i), subset);
                ++i;
            }
        }
    }

    public void restoreFromExpandedSnapshot(Object snapshot) {
        if (snapshot != null) {
            Map states = (Map)snapshot;
            for (Object o : states.keySet()) {
                this.setExpanded(o, (Boolean)states.get(o));
            }
        }
    }

    public void remove(Object object) {
        Item item = this.findItem(object);
        if (item != null) {
            if (this.control instanceof Table) {
                ((Table)this.control).remove(((Table)this.control).indexOf((TableItem)item));
            } else if (this.control instanceof Tree) {
                TreeItem treeItem = ((TreeItem)item).getParentItem();
            }
        }
    }

    public void insert(Object parent, Object object, int index) {
    }

    public boolean canMoveUp(Object object, boolean canChangeParent) {
        Item item = this.findItem(object);
        if (item != null) {
            if (this.control instanceof Table) {
                return ((Table)this.control).indexOf((TableItem)item) > 0;
            }
            if (this.control instanceof Tree) {
                TreeItem treeItem = (TreeItem)item;
                if (treeItem.getParentItem() == null) {
                    return ((Tree)this.control).indexOf(treeItem) > 0;
                }
                TreeItem parent = treeItem.getParentItem();
                if (parent.indexOf(treeItem) > 0) {
                    return true;
                }
                if (canChangeParent) {
                    if (parent.getParentItem() == null) {
                        return ((Tree)this.control).indexOf(parent) > 0;
                    }
                    return parent.getParentItem().indexOf(parent) > 0;
                }
            }
        }
        return false;
    }

    public boolean canMoveDown(Object object, boolean canChangeParent) {
        Item item = this.findItem(object);
        if (item != null) {
            if (this.control instanceof Table) {
                return ((Table)this.control).indexOf((TableItem)item) < ((Table)this.control).getItemCount() - 1;
            }
            if (this.control instanceof Tree) {
                TreeItem treeItem = (TreeItem)item;
                if (treeItem.getParentItem() == null) {
                    return ((Tree)this.control).indexOf(treeItem) < ((Tree)this.control).getItemCount() - 1;
                }
                TreeItem parent = treeItem.getParentItem();
                if (parent.indexOf(treeItem) < parent.getItemCount() - 1) {
                    return true;
                }
                if (canChangeParent) {
                    if (parent.getParentItem() == null) {
                        return ((Tree)this.control).indexOf(parent) < ((Tree)this.control).getItemCount() - 1;
                    }
                    return parent.getParentItem().indexOf(parent) < parent.getParentItem().getItemCount() - 1;
                }
            }
        }
        return false;
    }

    public void moveUp(Object object, boolean canChangeParent) {
        Item item = this.findItem(object);
        if (item != null) {
            this.control.setRedraw(false);
            if (this.control instanceof Table) {
                int index = ((Table)this.control).indexOf((TableItem)item);
                if (index > 0) {
                    TableItem theOther = ((Table)this.control).getItem(index - 1);
                    this.switchItems(item, (Item)theOther);
                }
            } else if (this.control instanceof Tree) {
                if (((TreeItem)item).getParentItem() == null) {
                    int index = ((Tree)this.control).indexOf((TreeItem)item);
                    if (index > 0) {
                        TreeItem theOther = ((Tree)this.control).getItem(index - 1);
                        this.switchItems(item, (Item)theOther);
                    }
                } else {
                    TreeItem parent = ((TreeItem)item).getParentItem();
                    int index = parent.indexOf((TreeItem)item);
                    if (index > 0) {
                        TreeItem theOther = parent.getItem(index - 1);
                        this.switchItems(item, (Item)theOther);
                    } else if (canChangeParent) {
                        SnapshotNode snParent = this.takeSnapshot(parent);
                        SnapshotNode snItem = (SnapshotNode)snParent.children.remove(0);
                        this.restoreFromSnapshot(parent, snParent, true);
                        parent = parent.getParentItem() == null ? ((Tree)this.control).getItem(((Tree)this.control).indexOf(parent) - 1) : parent.getParentItem().getItem(parent.getParentItem().indexOf(parent) - 1);
                        TreeItem newItem = new TreeItem(parent, 0);
                        this.restoreFromSnapshot(newItem, snItem);
                    }
                }
            }
            this.control.setRedraw(true);
        }
    }

    public void moveDown(Object object, boolean canChangeParent) {
        Item item = this.findItem(object);
        if (item != null) {
            this.control.setRedraw(false);
            if (this.control instanceof Table) {
                int index = ((Table)this.control).indexOf((TableItem)item);
                if (index < ((Table)this.control).getItemCount() - 1) {
                    TableItem theOther = ((Table)this.control).getItem(index + 1);
                    this.switchItems(item, (Item)theOther);
                }
            } else if (this.control instanceof Tree) {
                if (((TreeItem)item).getParentItem() == null) {
                    int index = ((Tree)this.control).indexOf((TreeItem)item);
                    if (index < ((Tree)this.control).getItemCount() - 1) {
                        TreeItem theOther = ((Tree)this.control).getItem(index + 1);
                        this.switchItems(item, (Item)theOther);
                    }
                } else {
                    TreeItem parent = ((TreeItem)item).getParentItem();
                    int index = parent.indexOf((TreeItem)item);
                    if (index < parent.getItemCount() - 1) {
                        TreeItem theOther = parent.getItem(index + 1);
                        this.switchItems(item, (Item)theOther);
                    } else if (canChangeParent) {
                        SnapshotNode snParent = this.takeSnapshot(parent);
                        SnapshotNode snItem = (SnapshotNode)snParent.children.remove(snParent.children.size() - 1);
                        this.restoreFromSnapshot(parent, snParent, true);
                        parent = parent.getParentItem() == null ? ((Tree)this.control).getItem(((Tree)this.control).indexOf(parent) + 1) : parent.getParentItem().getItem(parent.getParentItem().indexOf(parent) + 1);
                        TreeItem newItem = new TreeItem(parent, 0, 0);
                        this.restoreFromSnapshot(newItem, snItem);
                    }
                }
            }
            this.control.setRedraw(true);
        }
    }

    private void switchItems(Item item, Item other) {
        if (this.control instanceof Table) {
            Object o1 = item.getData();
            Object o2 = other.getData();
            this.setTableData((TableItem)item, o2);
            this.setTableData((TableItem)other, o1);
        } else if (this.control instanceof Tree) {
            SnapshotNode n1 = this.takeSnapshot((TreeItem)item);
            SnapshotNode n2 = this.takeSnapshot((TreeItem)other);
            this.restoreFromSnapshot((TreeItem)item, n2);
            this.restoreFromSnapshot((TreeItem)other, n1);
        }
    }

    private void setTableData(TableItem root, Object o) {
        Object data = root.getData();
        if (data != o) {
            if (data instanceof EObject) {
                this.binding.unbind(data);
            }
            root.setData(o);
            if (o instanceof EObject) {
                this.binding.bind((EObject)o, this.getBinder((EObject)o, (Item)root));
            } else {
                root.setText(this.getColumnText(o));
                root.setImage(this.getColumnImage(o));
            }
        }
    }

    private SnapshotNode takeSnapshot(TreeItem root) {
        SnapshotNode node = new SnapshotNode();
        node.expanded = root.getExpanded();
        node.data = root.getData();
        int size = root.getItemCount();
        node.children = new ArrayList(size);
        int i = 0;
        while (i < size) {
            node.children.add(this.takeSnapshot(root.getItem(i)));
            ++i;
        }
        return node;
    }

    private void restoreFromSnapshot(TreeItem root, SnapshotNode node) {
        this.restoreFromSnapshot(root, node, false);
    }

    private void restoreFromSnapshot(TreeItem root, SnapshotNode node, boolean force) {
        Object data = root.getData();
        if (force || data != node.data) {
            if (data instanceof EObject) {
                this.binding.unbind(data);
            }
            root.setData(node.data);
            if (node.data instanceof EObject) {
                this.binding.bind((EObject)node.data, this.getBinder((EObject)node.data, (Item)root));
            } else {
                root.setText(this.getColumnText(node.data));
                root.setImage(this.getColumnImage(node.data));
            }
            int size = root.getItemCount();
            if (size > node.children.size()) {
                root.removeAll();
                size = 0;
            }
            int i = 0;
            while (i < node.children.size()) {
                TreeItem child = i < size ? root.getItem(i) : new TreeItem(root, 0);
                this.restoreFromSnapshot(child, (SnapshotNode)node.children.get(i));
                ++i;
            }
            root.setExpanded(node.expanded);
        }
    }
}

