/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.stardust.modeling.common.platform.utils.ItemConsumer;
import org.eclipse.stardust.modeling.common.platform.utils.ItemProducer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TableManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class TextTableCombo
extends Composite {
    private int minItemCount;
    private int maxItemCount;
    private Text text;
    private Control table;
    private Shell popup;
    private Button arrow;
    private boolean hasFocus;
    private Listener listener;
    private Listener filter;
    private TableManager manager;
    private ItemProducer producer;
    private ItemConsumer consumer;
    private String prefix;

    public TextTableCombo(Composite parent, int style) {
        style = TextTableCombo.checkStyle(style);
        super(parent, style);
        this.minItemCount = 5;
        this.maxItemCount = 10;
        this.prefix = "";
        int textStyle = 4;
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text((Composite)this, textStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (TextTableCombo.this.popup == event.widget) {
                    TextTableCombo.this.popupEvent(event);
                    return;
                }
                if (TextTableCombo.this.text == event.widget) {
                    TextTableCombo.this.textEvent(event);
                    return;
                }
                if (TextTableCombo.this.table == event.widget) {
                    TextTableCombo.this.listEvent(event);
                    return;
                }
                if (TextTableCombo.this.getShell() == event.widget) {
                    TextTableCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == TextTableCombo.this.getShell()) {
                    TextTableCombo.this.handleFocus(16);
                }
            }
        };
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TextTableCombo.this.popup != null && !TextTableCombo.this.popup.isDisposed()) {
                    TextTableCombo.this.table.removeListener(12, TextTableCombo.this.listener);
                    TextTableCombo.this.popup.dispose();
                }
                Shell shell = TextTableCombo.this.getShell();
                shell.removeListener(27, TextTableCombo.this.listener);
                Display display = TextTableCombo.this.getDisplay();
                display.removeFilter(15, TextTableCombo.this.filter);
                TextTableCombo.this.popup = null;
                TextTableCombo.this.text = null;
                TextTableCombo.this.table = null;
                TextTableCombo.this.arrow = null;
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                TextTableCombo.this.dropDown(false);
            }

            public void controlResized(ControlEvent e) {
                TextTableCombo.this.internalLayout(false);
            }
        });
        int[] textEvents = new int[]{1, 2, 15};
        int i = 0;
        while (i < textEvents.length) {
            this.text.addListener(textEvents[i], this.listener);
            ++i;
        }
        this.arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTableCombo.this.dropDown(!TextTableCombo.this.isDropped());
            }
        });
        this.createPopup(new int[]{-1});
        this.initAccessible();
    }

    private static int checkStyle(int style) {
        int mask = 0x6800808;
        return style & mask;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.text.addModifyListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.manager.getSelectedItem();
        this.manager.deselectAll();
    }

    void shellEvent(Event event) {
        switch (event.type) {
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.table.computeSize(wHint, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textSize.x + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x));
        return new Point(width, height);
    }

    void createPopup(int[] selectionIndex) {
        this.popup = new Shell(this.getShell(), 16392);
        int style = this.getStyle();
        int tableStyle = 66052;
        if ((style & 0x800000) != 0) {
            tableStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            tableStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            tableStyle |= 0x2000000;
        }
        this.table = new Table((Composite)this.popup, tableStyle);
        this.manager = new TableManager((Table)this.table);
        this.manager.setColumnNames(new String[]{Diagram_Messages.TABLE_Column_Name});
        this.manager.setColumnSizes(new int[]{100});
        int[] popupEvents = new int[]{21, 9, 27};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 12};
        int i2 = 0;
        while (i2 < listEvents.length) {
            this.table.addListener(listEvents[i2], this.listener);
            ++i2;
        }
        if (this.producer != null) {
            if (this.consumer != null) {
                this.consumer.produceComplete();
            }
            this.consumer = this.newConsumer(true);
            this.producer.produce(this.text.getText(), this.consumer);
        }
        if (selectionIndex[0] != -1) {
            this.manager.setSelection(selectionIndex);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.manager.deselect(index);
    }

    public void deselectAll() {
        this.checkWidget();
        this.manager.deselectAll();
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            this.isDisposed();
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            int[] selectionIndex = this.manager.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.table = null;
            this.createPopup(selectionIndex);
        }
        Point size = this.getSize();
        int itemCount = Math.min(Math.max(this.manager.getRowCount(), this.minItemCount), this.maxItemCount);
        Point listSize = this.manager.computeSize(-1, itemCount, false);
        this.table.setBounds(1, 1, size.x - 2, listSize.y);
        int[] index = this.manager.getSelectionIndex();
        if (index[0] != -1) {
            this.manager.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public Object getItem(int[] index) {
        this.checkWidget();
        return this.manager.getElementAt(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.manager.getRowCount();
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int[] getSelectionIndex() {
        this.checkWidget();
        return this.manager.getSelectionIndex();
    }

    public int getStyle() {
        int style = super.getStyle();
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getMaxItemCount() {
        this.checkWidget();
        return this.maxItemCount;
    }

    public int getMinItemCount() {
        this.checkWidget();
        return this.minItemCount;
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        Shell shell = this.getShell();
        Display display = this.getDisplay();
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.table || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                this.dropDown(false);
                shell.removeListener(27, this.listener);
                display.removeFilter(15, this.filter);
            }
        }
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = TextTableCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = TextTableCombo.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = TextTableCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = TextTableCombo.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = TextTableCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = TextTableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = TextTableCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = TextTableCombo.this.text.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = TextTableCombo.this.toControl(e.x, e.y);
                if (TextTableCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = TextTableCombo.this.getBounds();
                Point pt = TextTableCombo.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = TextTableCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = TextTableCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = TextTableCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        this.text.setBounds(0, 0, width - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                int[] selectionIndex = this.manager.getSelectionIndex();
                this.popup = null;
                this.table = null;
                this.createPopup(selectionIndex);
                break;
            }
            case 4: {
                this.internalSetText(this.getTextAtSelection());
                this.dropDown(false);
                this.text.selectAll();
                this.text.setFocus();
                break;
            }
            case 13: {
                int[] index = this.manager.getSelectionIndex();
                if (index[0] == -1) {
                    return;
                }
                this.internalSetText(this.getTextAt(index));
                this.text.selectAll();
                this.manager.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                if (this.manager.getRowCount() <= 0 || this.manager.getSelectionIndex()[0] == -1) break;
                this.internalSetText(this.getTextAtSelection());
                this.text.selectAll();
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                }
                if (event.keyCode != 0x1000001 || this.manager.getSelectionIndex()[0] != 0) break;
                this.text.setFocus();
            }
        }
    }

    private void internalSetText(String textToSet) {
        if (!this.text.getText().equals(textToSet)) {
            this.text.setText(textToSet);
        }
    }

    public String getTextAtSelection() {
        return String.valueOf(this.prefix) + this.manager.getColumnText(this.manager.getSelectedItem())[0];
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.table.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void removeAll() {
        this.checkWidget();
        this.internalSetText("");
        this.manager.removeAll();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.removeModifyListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int[] index) {
        this.checkWidget();
        if (index[0] == -1) {
            this.manager.deselectAll();
            this.internalSetText("");
            return;
        }
        if (index[0] >= 0 && index != this.getSelectionIndex()) {
            this.internalSetText(this.getTextAt(index));
            this.text.selectAll();
            this.manager.setSelection(index);
            this.manager.showSelection();
        }
    }

    private String getTextAt(int[] index) {
        return String.valueOf(this.prefix) + this.manager.getColumnText(this.manager.getElementAt(index))[0];
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
        this.table.setFont(font);
        this.internalLayout(true);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setMaxItemCount(int count) {
        this.checkWidget();
        if (count < this.minItemCount) {
            return;
        }
        this.maxItemCount = count;
    }

    public void setMinItemCount(int count) {
        this.checkWidget();
        if (count < 0 || count > this.maxItemCount) {
            return;
        }
        this.minItemCount = count;
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 24: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (event.keyCode == 13) {
                    this.text.selectAll();
                    this.dropDown(false);
                    return;
                }
                if (event.keyCode == 0x1000001) {
                    return;
                }
                this.hasFocus = false;
                this.manager.removeAll();
                this.dropDown(true);
                String hint = this.text.getText();
                if (this.consumer != null) {
                    this.consumer.produceComplete();
                }
                if (this.producer != null) {
                    this.consumer = this.newConsumer(false);
                    this.producer.produce(hint, this.consumer);
                }
                this.text.setFocus();
                this.handleFocus(15);
                if (event.keyCode != 0x1000002) break;
                this.table.setFocus();
                if (this.manager.getRowCount() > 0 && this.text.getText() != "") {
                    this.manager.setSelection(new int[0]);
                    this.internalSetText(this.getTextAtSelection());
                }
                return;
            }
        }
    }

    public TableManager getTableManager() {
        return this.manager;
    }

    public void setText(String text) {
        if (this.consumer != null) {
            this.consumer.produceComplete();
        }
        this.internalSetText(text);
        this.manager.removeAll();
        if (this.producer != null) {
            this.producer.produce(text, this.newConsumer(true));
        }
    }

    public ItemProducer getDataProducer() {
        return this.producer;
    }

    public void setDataProducer(ItemProducer producer) {
        if (this.consumer != null) {
            this.consumer.produceComplete();
        }
        this.producer = producer;
        this.manager.removeAll();
        if (producer != null) {
            this.consumer = this.newConsumer(false);
            producer.produce(this.text.getText(), this.consumer);
        }
    }

    private ItemConsumer newConsumer(final boolean select) {
        return new ItemConsumer(){
            boolean complete = false;

            public void addData(Object object) {
                if (TextTableCombo.this.text == null || TextTableCombo.this.text.isDisposed()) {
                    this.produceComplete();
                } else if (!this.complete) {
                    TextTableCombo.this.manager.addElement(object);
                }
            }

            public void produceComplete() {
                this.complete = true;
                if (select && TextTableCombo.this.text != null && !TextTableCombo.this.text.isDisposed()) {
                    TextTableCombo.this.manager.selectByText(TextTableCombo.this.text.getText());
                }
            }

            public void clear() {
                TextTableCombo.this.manager.removeAll();
            }
        };
    }

    public void setUpdatePrefix(String prefix) {
        this.prefix = prefix;
    }

    public Text getControl() {
        return this.text;
    }
}

