/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.DereferencePathBrowserComposite;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TypeSelectionComposite {
    private Text typeText;
    private TypeInfo type;
    private int style = 256;
    private DereferencePathBrowserComposite[] browser;
    private Button browseButton;
    private TypeInfo filter;
    private TypeFinder finder;
    private ModelType model;

    public TypeSelectionComposite(Composite parent, String title) {
        this.init(parent, title, 1);
    }

    public TypeSelectionComposite(Composite parent, String title, int span) {
        this.init(parent, title, span);
    }

    private void init(Composite parent, final String title, int span) {
        final Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        GridData gd = FormBuilder.createDefaultSingleLineWidgetGridData((int)span);
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        composite.setLayoutData((Object)gd);
        this.typeText = FormBuilder.createText((Composite)composite);
        this.typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newType = TypeSelectionComposite.this.typeText.getText();
                if (TypeSelectionComposite.this.model != null) {
                    newType = VariableContextHelper.getInstance().getContext(TypeSelectionComposite.this.model).replaceAllVariablesByDefaultValue(newType);
                }
                if (TypeSelectionComposite.this.type == null || !CompareHelper.areEqual((Object)TypeSelectionComposite.this.type.getFullName(), (Object)newType)) {
                    if (TypeSelectionComposite.this.finder != null) {
                        TypeSelectionComposite.this.type = TypeSelectionComposite.this.finder.findType(newType);
                    } else if (TypeSelectionComposite.this.browser != null && TypeSelectionComposite.this.browser.length > 0) {
                        TypeSelectionComposite.this.type = TypeSelectionComposite.this.browser[0].getTypeFinder().findType(newType);
                    }
                    TypeSelectionComposite.this.updateType();
                }
            }
        });
        this.browseButton = FormBuilder.createButton((Composite)composite, (String)Diagram_Messages.Btn_Browse, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationWindow context = new ApplicationWindow(composite.getShell());
                IJavaSearchScope scope = null;
                if (TypeSelectionComposite.this.filter != null) {
                    try {
                        scope = SearchEngine.createHierarchyScope((IType)TypeSelectionComposite.this.filter.getType());
                    }
                    catch (JavaModelException ex) {
                        ex.printStackTrace();
                    }
                }
                if (scope == null) {
                    IJavaProject project = TypeSelectionComposite.this.finder == null ? null : TypeSelectionComposite.this.finder.getJavaProject();
                    scope = project != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}) : SearchEngine.createWorkspaceScope();
                }
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)composite.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)TypeSelectionComposite.this.style, (boolean)false);
                    dialog.setTitle(title);
                    if (dialog.open() == 0) {
                        TypeSelectionComposite.this.type = new TypeInfo(TypeSelectionComposite.this.finder, (IType)dialog.getResult()[0], null);
                        TypeSelectionComposite.this.typeText.setText(TypeSelectionComposite.this.type.getFullName());
                        TypeSelectionComposite.this.updateType();
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setStyle(int style) {
        this.style = style;
    }

    protected void updateType() {
        if (this.browser != null) {
            int i = 0;
            while (i < this.browser.length) {
                this.browser[i].setType(this.type);
                ++i;
            }
        }
    }

    public String getTypeText() {
        return this.typeText.getText();
    }

    public void setTypeText(String typeText) {
        this.typeText.setText(typeText);
    }

    public Text getText() {
        return this.typeText;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setDereferencePathBrowser(DereferencePathBrowserComposite[] browser) {
        this.browser = browser;
    }

    public void setTypeFinder(TypeFinder finder) {
        this.finder = finder;
    }

    public void setEnabled(boolean enabled) {
        this.browseButton.setEnabled(enabled);
        this.typeText.setEditable(enabled);
    }

    public void setType(TypeInfo type) {
        this.type = type;
        this.typeText.setText(type == null ? "" : type.getFullName());
    }

    public void setFilter(Class<?> clazz) {
        this.filter = this.finder.findType(clazz.getName());
    }

    public void setModel(ModelType model) {
        this.model = model;
    }
}

