/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.marker;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpgradeDataAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.marker.IResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.MarkerResolution;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchPart;

public class DataResolutionGenerator
implements IResolutionGenerator {
    private IAction upgradeAction;

    @Override
    public boolean hasResolutions(WorkflowModelEditor editor, Issue issue) {
        if (this.notJavaBoundEnumerationIssue(issue)) {
            return true;
        }
        if (this.isPrimitiveDefaultValueIssue(issue)) {
            return true;
        }
        EObject element = issue.getModelElement();
        if (element instanceof DataType) {
            this.upgradeAction = this.getAction(editor, element, "org.eclipse.stardust.model.xpdl.upgradeData");
            if (this.upgradeAction != null && this.upgradeAction.isEnabled()) {
                return true;
            }
        }
        return false;
    }

    private boolean notJavaBoundEnumerationIssue(Issue issue) {
        EObject ref;
        EObject element = issue.getModelElement();
        if (element instanceof DataType && "primitive".equals(((DataType)element).getType().getId()) && Type.Enumeration.getId().equals(AttributeUtil.getAttributeValue((IExtensibleElement)((DataType)element), (String)"carnot:engine:type")) && (ref = AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType")) != null && ref instanceof TypeDeclarationType) {
            return TypeDeclarationUtils.isEnumeration((TypeDeclarationType)((TypeDeclarationType)ref), (boolean)false);
        }
        return false;
    }

    private boolean isPrimitiveDefaultValueIssue(Issue issue) {
        EObject element = issue.getModelElement();
        return element instanceof DataType && !element.eIsProxy() && "carnot:engine:defaultValue".equals(issue.getFeature()) && ((DataType)element).getType() != null && "primitive".equals(((DataType)element).getType().getId()) && Type.Enumeration.getId().equals(AttributeUtil.getAttributeValue((IExtensibleElement)((DataType)element), (String)"carnot:engine:type"));
    }

    @Override
    public void addResolutions(List<IMarkerResolution> list, WorkflowModelEditor editor, final Issue issue) {
        if (this.isPrimitiveDefaultValueIssue(issue)) {
            DataType data = (DataType)issue.getModelElement();
            TypeDeclarationType decl = StructuredTypeUtils.getTypeDeclaration((DataType)data);
            Object[] facets = StructuredTypeUtils.getFacets((TypeDeclarationType)decl);
            int i = 0;
            while (i < facets.length) {
                final String value = facets[i].toString();
                SelectionAction action = new SelectionAction((IWorkbenchPart)editor){

                    public void run() {
                        SetValueCmd cmd;
                        DataType data = (DataType)issue.getModelElement();
                        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:defaultValue");
                        if (attribute == null) {
                            attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
                            attribute.setName("carnot:engine:defaultValue");
                            attribute.setValue(value);
                            cmd = new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), (Object)attribute);
                        } else {
                            cmd = new SetValueCmd((EObject)attribute, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value(), (Object)value);
                        }
                        if (cmd != null) {
                            this.execute(cmd);
                        }
                    }

                    protected boolean calculateEnabled() {
                        return value != null;
                    }
                };
                action.setText("Set the default value to '" + value + "'.");
                list.add((IMarkerResolution)new MarkerResolution((IAction)action, DiagramPlugin.getImage(editor.getIconFactory().getIconFor(issue.getModelElement()))));
                ++i;
            }
        } else if (this.notJavaBoundEnumerationIssue(issue)) {
            SelectionAction action = new SelectionAction((IWorkbenchPart)editor){

                public void run() {
                    DataType data = (DataType)issue.getModelElement();
                    ModelType model = ModelUtils.findContainingModel((EObject)data);
                    Command cmd = null;
                    AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:defaultValue");
                    if (attribute != null) {
                        cmd = new DeleteValueCmd(attribute.eContainer(), attribute, attribute.eContainingFeature());
                    }
                    if (cmd != null) {
                        this.execute(cmd);
                    }
                    if ((attribute = AttributeUtil.getAttribute((IExtensibleElement)data, (String)"carnot:engine:type")) != null) {
                        cmd = new DeleteValueCmd(attribute.eContainer(), attribute, attribute.eContainingFeature());
                    }
                    if (cmd != null) {
                        this.execute(cmd);
                    }
                    if ((cmd = new SetValueCmd((EObject)data, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataType_Type(), (Object)GenericUtils.getDataTypeType(model, "struct"))) != null) {
                        this.execute(cmd);
                    }
                }

                protected boolean calculateEnabled() {
                    return true;
                }
            };
            action.setText(Diagram_Messages.LB_ACTION_ChangeDataType);
            list.add((IMarkerResolution)new MarkerResolution((IAction)action, DiagramPlugin.getImage(editor.getIconFactory().getIconFor(issue.getModelElement()))));
        } else {
            list.add((IMarkerResolution)new MarkerResolution(this.upgradeAction));
        }
    }

    private IAction getAction(final WorkflowModelEditor editor, final EObject element, String actionId) {
        if (actionId == "org.eclipse.stardust.model.xpdl.upgradeData") {
            return new UpgradeDataAction(editor){

                protected ISelection getSelection() {
                    EditPart editPart = editor.findEditPart(element);
                    return editPart == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)editPart);
                }
            };
        }
        return null;
    }
}

