/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.core.OverdueThresholdVerifier;
import org.eclipse.stardust.modeling.core.PeriodVerifier;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractControllingPropertyPage
extends AbstractModelElementPropertyPage {
    protected static final String PWH = "carnot:pwh:";
    static final String PERIOD = "period";
    protected static final String OVERDUE_THRESHOLD = "overdueThreshold";
    private Text[] fields;
    private HashMap verifiers = new HashMap();
    private LabeledViewer combo;

    public abstract ControllingAttribute[] getControllingAttributes();

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ControllingAttribute[] attributes = this.getControllingAttributes();
        int i = 0;
        while (i < attributes.length) {
            ControllingAttribute attribute = attributes[i];
            if (Type.Boolean.getId().equals(attributes[i].type)) {
                boolean value = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)(PWH + attribute.id));
                this.combo.getViewer().setSelection((ISelection)new StructuredSelection(attribute.keys.get(value)));
            } else {
                String value = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)(PWH + attribute.id));
                Verifier verifier = this.getVerifier(this.fields[i], attributes[i].type);
                if (verifier != null) {
                    value = verifier.getExternalValue(value);
                }
                this.fields[i].setText(value == null ? "" : value);
            }
            ++i;
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ControllingAttribute[] attributes = this.getControllingAttributes();
        int i = 0;
        while (i < attributes.length) {
            ControllingAttribute attribute = attributes[i];
            if (Type.Boolean.getId().equals(attributes[i].type)) {
                String label = (String)((StructuredSelection)this.combo.getViewer().getSelection()).getFirstElement();
                Boolean value = (Boolean)attribute.values.get(label);
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)(PWH + attribute.id), (Boolean)value);
            } else {
                String value = this.fields[i].getText().trim();
                Verifier verifier = this.getVerifier(this.fields[i], attributes[i].type);
                if (verifier != null) {
                    value = verifier.getInternalValue(value);
                }
                AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)(PWH + attribute.id), (String)value);
            }
            ++i;
        }
    }

    private Verifier getVerifier(Text field, String type) {
        if (type == null) {
            return null;
        }
        Verifier verifier = (Verifier)this.verifiers.get(field);
        if (verifier == null) {
            verifier = PERIOD.equals(type) ? new PeriodVerifier(field) : (OVERDUE_THRESHOLD.equals(type) ? new OverdueThresholdVerifier(field) : VerifierFactory.getVerifier((Type)Type.getKey(Type.class, (String)type)));
            this.verifiers.put(field, verifier);
        }
        return verifier;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        ControllingAttribute[] attributes = this.getControllingAttributes();
        this.fields = new Text[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            if (Type.Boolean.getId().equals(attributes[i].type)) {
                this.combo = FormBuilder.createComboViewer((Composite)composite, (String)(String.valueOf(attributes[i].label) + ":"), new ArrayList(attributes[i].keys.values()));
            } else {
                FormBuilder.createLabel((Composite)composite, (String)(String.valueOf(attributes[i].label) + ":"));
                this.fields[i] = FormBuilder.createText((Composite)composite);
                Verifier verifier = this.getVerifier(this.fields[i], attributes[i].type);
                if (verifier != null) {
                    this.fields[i].addVerifyListener((VerifyListener)verifier);
                }
            }
            ++i;
        }
        return composite;
    }

    static class ControllingAttribute {
        String label;
        String id;
        String type;
        String measureUnit;
        Map values;
        Map keys;

        ControllingAttribute(String label, String id, String type, String measureUnit) {
            this.label = label;
            this.id = id;
            this.type = type;
            this.measureUnit = measureUnit;
        }

        ControllingAttribute(String label, String id, String type, String measureUnit, Map keys, Map values) {
            this(label, id, type, measureUnit);
            this.keys = keys;
            this.values = values;
        }
    }
}

