/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IEventHandlerOwner;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public abstract class AbstractEventHandlingStructureSynchronizer
extends AdapterImpl {
    protected static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    public static final char NODE_PATH_SEPARATOR = '.';
    private final IEventHandlerOwner target;

    public AbstractEventHandlingStructureSynchronizer(IEventHandlerOwner target) {
        this.target = target;
    }

    protected abstract void synchronizeConditionTypes();

    protected abstract void synchronizeEventHandlers(String var1);

    protected abstract void synchronizeEventActions(EventHandlerType var1);

    public IEventHandlerOwner getEventHandlerOwner() {
        return this.target;
    }

    public void init() {
        if (this.target != null) {
            this.registerAdapter((Notifier)this.target);
            Iterator i = this.target.getEventHandler().iterator();
            while (i.hasNext()) {
                this.registerAdapter((Notifier)((EventHandlerType)i.next()));
            }
        }
        this.updateOutline(this.target);
    }

    public void dispose() {
        if (this.target != null) {
            Iterator i = this.target.getEventHandler().iterator();
            while (i.hasNext()) {
                this.unregisterAdapter((Notifier)((EventHandlerType)i.next()));
            }
            this.unregisterAdapter((Notifier)this.target);
        }
    }

    public void updateOutline(Object hint) {
        if (hint instanceof AbstractEventAction) {
            hint = ModelUtils.findContainingEventHandlerType((EObject)((AbstractEventAction)hint));
        }
        if (hint instanceof EventHandlerType) {
            this.synchronizeEventActions((EventHandlerType)hint);
        } else if (hint instanceof EventConditionTypeType) {
            this.synchronizeEventHandlers(((EventConditionTypeType)hint).getId());
        } else {
            this.synchronizeConditionTypes();
        }
    }

    public void notifyChanged(Notification msg) {
        if (msg.getNotifier() instanceof IEventHandlerOwner && msg.getFeatureID(IEventHandlerOwner.class) == 0) {
            if (3 == msg.getEventType()) {
                this.registerAdapter((Notifier)msg.getNewValue());
                this.updateOutline(((EventHandlerType)msg.getNewValue()).getMetaType());
            } else if (5 == msg.getEventType()) {
                this.updateOutline(null);
            } else if (7 == msg.getEventType()) {
                this.updateOutline(((EventHandlerType)msg.getNewValue()).getMetaType());
            } else if (4 == msg.getEventType()) {
                this.unregisterAdapter((Notifier)msg.getOldValue());
                this.updateOutline(((EventHandlerType)msg.getOldValue()).getMetaType());
            } else if (6 == msg.getEventType()) {
                this.updateOutline(null);
            }
        } else if (msg.getNotifier() instanceof EventHandlerType && (7 == msg.getFeatureID(EventHandlerType.class) || 6 == msg.getFeatureID(EventHandlerType.class) || 8 == msg.getFeatureID(EventHandlerType.class))) {
            switch (msg.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.updateOutline(((EventHandlerType)msg.getNotifier()).getMetaType());
                }
            }
        }
        super.notifyChanged(msg);
    }

    protected void registerAdapter(Notifier target) {
        if (target != null && !target.eAdapters().contains((Object)this)) {
            target.eAdapters().add((Object)this);
        }
    }

    protected void unregisterAdapter(Notifier target) {
        if (target != null) {
            target.eAdapters().remove((Object)this);
        }
    }
}

