/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;

public class DataFilter
extends ViewerFilter {
    private ViewerFilter categoryFilter;
    private ModelType referencedModel;
    private Object filterType;

    public ViewerFilter getCategoryFilter() {
        return this.categoryFilter;
    }

    public void setCategoryFilter(ViewerFilter categoryFilter) {
        this.categoryFilter = categoryFilter;
    }

    public ModelType getReferencedModel() {
        return this.referencedModel;
    }

    public void setReferencedModel(ModelType referencedModel) {
        this.referencedModel = referencedModel;
    }

    public Object getFilterType() {
        return this.filterType;
    }

    public void setFilterType(Object filterType) {
        this.filterType = filterType;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ModelType model;
        String filterTypeID;
        String typeName;
        if (this.categoryFilter == null || this.filterType == null) {
            return false;
        }
        DataType dataType = (DataType)element;
        if (dataType.getType() == null) {
            return false;
        }
        String typeId = dataType.getType().getId();
        if (("primitive".equals(typeId) || "struct".equals(typeId)) && !this.categoryFilter.toString().startsWith("Document")) {
            TypeDeclarationType decl;
            typeName = AttributeUtil.getAttributeValue((List)dataType.getAttribute(), (String)"carnot:engine:type");
            if (typeId.equals("struct")) {
                ModelType model2 = ModelUtils.findContainingModel((EObject)dataType);
                if (this.referencedModel != null && !model2.equals(this.referencedModel)) {
                    AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:connection:uri");
                    if (dataType.getExternalReference() != null) {
                        if (this.referencedModel.getId().equals(dataType.getExternalReference().getLocation())) {
                            return true;
                        }
                    } else if (attribute != null) {
                        String uri = attribute.getValue();
                        URI aRealUri = URI.createURI((String)uri);
                        Connection connection = (Connection)model2.getConnectionManager().findConnection(uri);
                        if (connection.getAttribute("importByReference") != null && !"false".equals(connection.getAttribute("importByReference"))) {
                            EObject o = model2.getConnectionManager().find(String.valueOf(aRealUri.scheme().toString()) + "://" + aRealUri.authority() + "/");
                            ModelType refModel = (ModelType)Reflect.getFieldValue((Object)o, (String)"eObject");
                            if (this.referencedModel.getId().equals(refModel.getId())) {
                                return true;
                            }
                        }
                    } else {
                        return false;
                    }
                }
            }
            if (typeName == null) {
                typeName = AttributeUtil.getAttributeValue((List)dataType.getAttribute(), (String)"carnot:engine:dataType");
            }
            if (this.filterType != null && this.filterType instanceof Type && ((Type)this.filterType).equals((Object)Type.Enumeration)) {
                if ("primitive".equals(typeId)) {
                    if (this.filterType != null && this.filterType instanceof Type) {
                        return ((Type)this.filterType).getId().equalsIgnoreCase(typeName);
                    }
                } else if ("struct".equals(typeId) && (decl = StructuredTypeUtils.getTypeDeclaration((DataType)dataType)) != null) {
                    return TypeDeclarationUtils.isEnumeration((TypeDeclarationType)decl, (boolean)false);
                }
            }
            if (this.filterType != null && this.filterType instanceof Type) {
                return ((Type)this.filterType).getId().equalsIgnoreCase(typeName);
            }
            if (this.filterType != null && this.filterType instanceof TypeDeclarationType && "struct".equals(typeId) && (decl = StructuredTypeUtils.getTypeDeclaration((DataType)dataType)) != null) {
                return !TypeDeclarationUtils.isEnumeration((TypeDeclarationType)decl, (boolean)false) && decl.getId().equals(((TypeDeclarationType)this.filterType).getId());
            }
        }
        if (typeId.equals("dmsDocument") && this.categoryFilter.toString().equals("Document")) {
            typeName = AttributeUtil.getAttributeValue((List)dataType.getAttribute(), (String)"carnot:engine:dms:resourceMetadataSchema");
            if (this.filterType != null && this.filterType instanceof TypeDeclarationType) {
                filterTypeID = ((TypeDeclarationType)this.filterType).getId();
                model = ModelUtils.findContainingModel((EObject)dataType);
                if (!filterTypeID.equalsIgnoreCase(StructuredTypeUtils.getResourceTypeDeclaration().getId()) && !model.equals(this.referencedModel)) {
                    if (AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:connection:uri") == null) {
                        return false;
                    }
                    if (dataType.getExternalReference() == null) {
                        return false;
                    }
                    if (!dataType.getExternalReference().getLocation().equals(this.referencedModel.getId())) {
                        return false;
                    }
                }
                if (typeName == null && filterTypeID.equals("ResourceProperty")) {
                    return true;
                }
                if (typeName != null && filterTypeID.equals(typeName)) {
                    return true;
                }
            }
            return false;
        }
        if (typeId.equals("dmsDocumentList") && this.categoryFilter.toString().equals("Document List")) {
            typeName = AttributeUtil.getAttributeValue((List)dataType.getAttribute(), (String)"carnot:engine:dms:resourceMetadataSchema");
            if (this.filterType != null && this.filterType instanceof TypeDeclarationType) {
                filterTypeID = ((TypeDeclarationType)this.filterType).getId();
                model = ModelUtils.findContainingModel((EObject)dataType);
                if (!filterTypeID.equalsIgnoreCase(StructuredTypeUtils.getResourceTypeDeclaration().getId()) && !model.equals(this.referencedModel)) {
                    if (AttributeUtil.getAttributeValue((IExtensibleElement)dataType, (String)"carnot:connection:uri") == null) {
                        return false;
                    }
                    if (dataType.getExternalReference() == null) {
                        return false;
                    }
                    if (!dataType.getExternalReference().getLocation().equals(this.referencedModel.getId())) {
                        return false;
                    }
                }
                if (typeName == null && filterTypeID.equals("ResourceProperty")) {
                    return true;
                }
                if (typeName != null && filterTypeID.equals(typeName)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

