/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.properties.ModelElementNotificationAdapter;

public class DataMappingsTreeContentProvider
extends ModelElementNotificationAdapter
implements ITreeContentProvider {
    private static final int[] elementFeatureIds = new int[]{6, 1, 7, 4};
    private TreeViewer viewer;
    private DataType data;
    private boolean isIn;
    private ModelElementNotificationAdapter attributeNotifier;

    public DataMappingsTreeContentProvider(final DataType data, final boolean isIn) {
        super((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_DataMapping(), elementFeatureIds, new IFilter(){

            public boolean select(Object object) {
                DataMappingType type = (DataMappingType)object;
                return isIn == AccessPointUtil.isIn((DirectionType)type.getDirection()) && (data == null || data.equals(type.getData()));
            }
        }, true);
        this.data = data;
        this.isIn = isIn;
    }

    @Override
    public void elementAdded(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementChanged(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementMoved(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementRemoved(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void init(EObject target) {
        super.init(target);
        if (target instanceof ActivityType) {
            this.attributeNotifier = new ModelElementNotificationAdapter((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), new int[]{6}, new IFilter(){

                public boolean select(Object toTest) {
                    AttributeType attribute = (AttributeType)toTest;
                    return "carnot:engine:subprocess:copyAllData".equals(attribute.getName());
                }
            }, true){

                @Override
                public void elementRemoved(EObject element) {
                    DataMappingsTreeContentProvider.this.viewer.refresh();
                }

                @Override
                public void elementMoved(EObject element) {
                }

                @Override
                public void elementChanged(EObject element) {
                    DataMappingsTreeContentProvider.this.viewer.refresh();
                }

                @Override
                public void elementAdded(EObject element) {
                    DataMappingsTreeContentProvider.this.viewer.refresh();
                }
            };
            this.attributeNotifier.init(target);
        }
    }

    @Override
    public void dispose() {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.dispose();
        }
        super.dispose();
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (msg.getNotifier() == this.getTarget() && 19 == msg.getFeatureID(this.getTarget().getClass())) {
            this.viewer.refresh();
        } else {
            super.notifyChanged(msg);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ApplicationContextTypeType) {
            ApplicationContextTypeType context = (ApplicationContextTypeType)parentElement;
            List allMappings = this.getChildren((EObject)((ActivityType)this.viewer.getInput()));
            int i = allMappings.size() - 1;
            while (i >= 0) {
                DataMappingType dm = (DataMappingType)allMappings.get(i);
                if (!context.getId().equals(dm.getContext())) {
                    allMappings.remove(i);
                }
                --i;
            }
            return allMappings.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return element instanceof DataMappingType ? this.getApplicationContext((DataMappingType)element) : null;
    }

    private ApplicationContextTypeType getApplicationContext(DataMappingType dataMapping) {
        ApplicationType application;
        String context = dataMapping.getContext();
        ModelType model = ModelUtils.findContainingModel((EObject)dataMapping);
        ActivityType activity = ModelUtils.findContainingActivity((EObject)dataMapping);
        if (ActivityUtil.isInteractive((ActivityType)activity) && ActivityUtil.isApplicationActivity((ActivityType)activity) && !ActivityUtil.isImplicitContext((String)context) && (application = activity.getApplication()) != null) {
            model = ModelUtils.findContainingModel((EObject)application);
        }
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)context);
    }

    public boolean hasChildren(Object element) {
        return element instanceof ApplicationContextTypeType;
    }

    public Object[] getElements(Object inputElement) {
        ActivityType activity = (ActivityType)inputElement;
        List contexts = ActivityUtil.getContextTypes((ActivityType)activity, (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        EList dataMappings = activity.getDataMapping();
        for (DataMappingType type : dataMappings) {
            ApplicationContextTypeType ctx = this.getApplicationContext(type);
            if (this.isIn != AccessPointUtil.isIn((DirectionType)type.getDirection()) || contexts.contains(ctx) || this.data != null && !this.data.equals(type.getData())) continue;
            contexts.add(ctx);
        }
        return contexts.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        this.init((EObject)((IModelElement)newInput));
        this.viewer = (TreeViewer)viewer;
    }
}

