/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataPathPropertyPage
extends AbstractModelElementPropertyPage {
    private LabeledText idText;
    private LabeledText nameText;
    private ComboViewer directionCombo;
    private Button noDescriptorButton;
    private Button simpleDescriptorButton;
    private Button keyDescriptorButton;
    private ComboViewer dataText;
    private LabelWithStatus dataLabel;
    private LabelWithStatus dataPathLabel;
    private AccessPathBrowserComposite dataPathBrowser;
    private Button[] buttons;
    private boolean isEditable = true;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GenericUtils.getAutoIdValue()) {
                String computedId = NameIdUtils.createIdFromName(null, (EObject)DataPathPropertyPage.this.getModelElement());
                DataPathPropertyPage.this.idText.getText().setText(computedId);
            }
        }
    };

    @Override
    protected void performDefaults() {
        super.performDefaults();
        ISelection sel = this.directionCombo.getSelection();
        if (sel.isEmpty()) {
            this.directionCombo.setSelection((ISelection)new StructuredSelection((Object)DirectionType.IN_LITERAL));
        }
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager binding = this.getWidgetBindingManager();
        final DataPathType dataPath = (DataPathType)element;
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        this.nameText.getText().removeModifyListener(this.listener);
        binding.bind(this.idText, (EObject)dataPath, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id());
        binding.bind(this.nameText, (EObject)dataPath, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
        binding.getModelBindingManager().bind((EObject)dataPath, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_Direction(), (StructuredViewer)this.directionCombo);
        this.updateDescriptorState();
        binding.getValidationBindingManager().bind((EObject)dataPath, (Object)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_Data(), this.dataLabel);
        binding.getValidationBindingManager().bind((EObject)dataPath, (Object)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), this.dataPathLabel);
        binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(model, model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.dataText, this.dataPathBrowser, dataPath.getDirection()));
        this.dataPathBrowser.setDirectionProvider(new AccessPathBrowserComposite.IDirectionProvider(){

            @Override
            public DirectionType getDirection() {
                return ModelUtils.getDualDirection((DirectionType)dataPath.getDirection());
            }
        });
        binding.getModelBindingManager().bind((EObject)dataPath, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_Data(), (StructuredViewer)this.dataText);
        binding.getModelBindingManager().bind((EObject)dataPath, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataPathType_DataPath(), this.dataPathBrowser.getMethodText());
        this.nameText.getText().addModifyListener(this.listener);
        this.isEditable = !"PROCESS_ATTACHMENTS".equals(dataPath.getId());
        this.setEditable(this.isEditable);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    private void setEditable(boolean enabled_) {
        boolean enabled = enabled_ && this.enablePage;
        this.idText.getText().setEnabled(enabled);
        this.nameText.getText().setEnabled(enabled);
        this.directionCombo.getCombo().setEnabled(enabled);
        this.updateDescriptorState();
        this.dataText.getCombo().setEnabled(enabled);
        if (!StringUtils.isEmpty((String)this.dataText.getCombo().getText())) {
            DataType data = ((DataPathType)this.getModelElement()).getData();
            IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)data.getType());
            this.dataPathBrowser.getBrowseButton().setEnabled(editor != null && editor.supportsBrowsing() && enabled);
        }
        if (this.buttons != null && this.buttons.length >= 1) {
            this.buttons[1].setEnabled(enabled);
        }
    }

    private void updateDescriptorState() {
        StructuredSelection selection = (StructuredSelection)this.directionCombo.getSelection();
        boolean isInPath = DirectionType.IN_LITERAL.equals(selection.getFirstElement());
        DataPathType dataPath = (DataPathType)this.getModelElement();
        if (!isInPath && dataPath.isDescriptor()) {
            dataPath.setDescriptor(false);
            if (dataPath.isKey()) {
                dataPath.unsetKey();
                this.keyDescriptorButton.setSelection(false);
            } else {
                this.simpleDescriptorButton.setSelection(false);
            }
        }
        if (dataPath.isKey()) {
            this.keyDescriptorButton.setSelection(true);
            this.simpleDescriptorButton.setSelection(false);
            this.noDescriptorButton.setSelection(false);
        } else if (dataPath.isDescriptor()) {
            this.keyDescriptorButton.setSelection(false);
            this.simpleDescriptorButton.setSelection(true);
            this.noDescriptorButton.setSelection(false);
        } else {
            this.keyDescriptorButton.setSelection(false);
            this.simpleDescriptorButton.setSelection(false);
            this.noDescriptorButton.setSelection(true);
        }
        boolean enabled = !selection.isEmpty() && isInPath && this.enablePage;
        this.noDescriptorButton.setEnabled(enabled);
        this.simpleDescriptorButton.setEnabled(enabled);
        this.keyDescriptorButton.setEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        IButtonManager manager;
        if (visible && (manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class)) != null) {
            manager.updateButtons(this.getModelElement(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.nameText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.idText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.idText.getText().setEditable(false);
        }
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Direction);
        this.directionCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.directionCombo.add((Object)DirectionType.IN_LITERAL);
        this.directionCombo.add((Object)DirectionType.OUT_LITERAL);
        this.directionCombo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataPathPropertyPage.this.updateDescriptorState();
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)"");
        Composite group = FormBuilder.createComposite((Composite)composite, (int)3);
        group.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        this.noDescriptorButton = FormBuilder.createRadioButton((Composite)group, (String)Diagram_Messages.LB_NoDescriptor);
        this.simpleDescriptorButton = FormBuilder.createRadioButton((Composite)group, (String)Diagram_Messages.LB_Descriptor);
        this.keyDescriptorButton = FormBuilder.createRadioButton((Composite)group, (String)Diagram_Messages.LB_KeyDescriptor);
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.updateKeyButton();
            }

            public void widgetSelected(SelectionEvent e) {
                this.updateKeyButton();
            }

            private void updateKeyButton() {
                if (DataPathPropertyPage.this.keyDescriptorButton.getSelection()) {
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).setDescriptor(true);
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).setKey(true);
                } else if (DataPathPropertyPage.this.simpleDescriptorButton.getSelection()) {
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).setDescriptor(true);
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).unsetKey();
                } else {
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).setDescriptor(false);
                    ((DataPathType)DataPathPropertyPage.this.getModelElement()).unsetKey();
                }
            }
        };
        this.noDescriptorButton.addSelectionListener((SelectionListener)l);
        this.simpleDescriptorButton.addSelectionListener((SelectionListener)l);
        this.keyDescriptorButton.addSelectionListener((SelectionListener)l);
        this.dataLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_Data);
        this.dataText = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.dataText.setSorter(new ViewerSorter());
        this.dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_DataPath);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), composite, Diagram_Messages.LB_DataPath);
        return composite;
    }
}

