/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IEventHandlerOwner;

public abstract class EventHandlingNotificationAdapter
extends AdapterImpl {
    private IEventHandlerOwner target;

    public abstract void actionChanged(AbstractEventAction var1, String var2);

    public abstract void actionAdded(AbstractEventAction var1);

    public abstract void actionMoved(AbstractEventAction var1);

    public abstract void actionRemoved(AbstractEventAction var1);

    public abstract void handlerChanged(EventHandlerType var1, String var2);

    public abstract void handlerAdded(EventHandlerType var1);

    public abstract void handlerMoved(EventHandlerType var1);

    public abstract void handlerRemoved(EventHandlerType var1);

    public void init(IEventHandlerOwner target) {
        this.target = target;
        if (target != null) {
            this.registerAdapter((Notifier)target);
            for (EventHandlerType handler : target.getEventHandler()) {
                this.registerAdapter((Notifier)handler);
                this.registerAdapter((List)handler.getBindAction());
                this.registerAdapter((List)handler.getEventAction());
                this.registerAdapter((List)handler.getUnbindAction());
            }
        }
    }

    private void registerAdapter(List elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.registerAdapter((Notifier)i.next());
        }
    }

    public void dispose() {
        if (this.target != null) {
            for (EventHandlerType handler : this.target.getEventHandler()) {
                this.unregisterAdapter((List)handler.getUnbindAction());
                this.unregisterAdapter((List)handler.getEventAction());
                this.unregisterAdapter((List)handler.getBindAction());
                this.unregisterAdapter((Notifier)handler);
            }
            this.unregisterAdapter((Notifier)this.target);
        }
    }

    private void unregisterAdapter(List elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.unregisterAdapter((Notifier)i.next());
        }
    }

    public void notifyChanged(Notification msg) {
        if (msg.getNotifier() instanceof IEventHandlerOwner) {
            if (msg.getFeatureID(IEventHandlerOwner.class) == 0) {
                if (3 == msg.getEventType()) {
                    this.registerAdapter((Notifier)msg.getNewValue());
                    this.handlerAdded((EventHandlerType)msg.getNewValue());
                } else if (4 == msg.getEventType()) {
                    this.unregisterAdapter((Notifier)msg.getOldValue());
                    this.handlerRemoved((EventHandlerType)msg.getOldValue());
                } else if (7 == msg.getEventType()) {
                    this.handlerMoved((EventHandlerType)msg.getNewValue());
                }
            }
        } else if (msg.getNotifier() instanceof EventHandlerType) {
            if (7 == msg.getFeatureID(EventHandlerType.class) || 6 == msg.getFeatureID(EventHandlerType.class) || 8 == msg.getFeatureID(EventHandlerType.class)) {
                if (3 == msg.getEventType()) {
                    AbstractEventAction action = (AbstractEventAction)msg.getNewValue();
                    this.actionAdded(action);
                    this.registerAdapter((Notifier)action);
                } else if (4 == msg.getEventType()) {
                    AbstractEventAction action = (AbstractEventAction)msg.getOldValue();
                    this.actionRemoved(action);
                    this.unregisterAdapter((Notifier)action);
                } else if (7 == msg.getEventType()) {
                    this.actionMoved((AbstractEventAction)msg.getNewValue());
                }
            } else if (1 == msg.getFeatureID(EventHandlerType.class) || 2 == msg.getFeatureID(EventHandlerType.class) || 9 == msg.getFeatureID(EventHandlerType.class) || 11 == msg.getFeatureID(EventHandlerType.class) || 10 == msg.getFeatureID(EventHandlerType.class)) {
                this.handlerChanged((EventHandlerType)msg.getNotifier(), "id");
            }
        } else if (msg.getNotifier() instanceof AbstractEventAction && (5 == msg.getFeatureID(AbstractEventAction.class) || 1 == msg.getFeatureID(AbstractEventAction.class) || 2 == msg.getFeatureID(AbstractEventAction.class))) {
            this.actionChanged((AbstractEventAction)msg.getNotifier(), "id");
        }
    }

    protected void registerAdapter(Notifier target) {
        if (target != null && !target.eAdapters().contains((Object)this)) {
            target.eAdapters().add((Object)this);
        }
    }

    protected void unregisterAdapter(Notifier target) {
        if (target != null) {
            target.eAdapters().remove((Object)this);
        }
    }
}

