/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ModelElementsTableContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class GatewayPropertyPage
extends AbstractModelElementPropertyPage {
    private static final int[] elementFeatureIds = new int[]{1, 6, 7, 9};
    private static final String[] labelProperties = new String[]{"id"};
    private TableViewer viewer;
    private Button upButton;
    private Button downButton;

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        GatewaySymbol gateway = this.getGateway();
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)gateway);
        this.viewer.setInput((Object)process);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    private GatewaySymbol getGateway() {
        Object model;
        IAdaptable element = this.getElement();
        if (element instanceof EditPart && (model = ((EditPart)element).getModel()) instanceof GatewaySymbol) {
            return (GatewaySymbol)model;
        }
        return null;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.upButton = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GatewayPropertyPage.this.performUp();
            }
        });
        this.downButton = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GatewayPropertyPage.this.performDown();
            }
        });
    }

    private boolean canMoveDown(Object item) {
        int selection = this.viewer.getTable().getSelectionIndex();
        return selection >= 0 && selection < this.viewer.getTable().getItemCount() - 1;
    }

    private boolean canMoveUp(Object item) {
        int selection = this.viewer.getTable().getSelectionIndex();
        return selection > 0;
    }

    private void performDown() {
        int selection = this.viewer.getTable().getSelectionIndex();
        int otherSelection = selection + 1;
        this.moveItem(selection, otherSelection);
    }

    private void performUp() {
        int selection = this.viewer.getTable().getSelectionIndex();
        int otherSelection = selection - 1;
        this.moveItem(selection, otherSelection);
    }

    private void moveItem(int selection, int otherSelection) {
        GatewaySymbol gateway = this.getGateway();
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)gateway);
        EList allTransitions = process.getTransition();
        TransitionType transition = (TransitionType)this.viewer.getElementAt(selection);
        TransitionType other = (TransitionType)this.viewer.getElementAt(otherSelection);
        int oldPos = allTransitions.indexOf((Object)transition);
        int newPos = allTransitions.indexOf((Object)other);
        allTransitions.move(newPos, oldPos);
        this.updateButtons(transition);
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Table table = new Table(composite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GatewayPropertyPage.this.updateButtons(GatewayPropertyPage.this.getSelectedItem());
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = GatewayPropertyPage.this.getSelectedItem();
                if (selection instanceof TransitionType) {
                    GatewayPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TableViewer(table);
        TableUtil.createColumns(table, new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Condition, Diagram_Messages.COL_NAME_Fork, Diagram_Messages.COL_NAME_Activity});
        TableUtil.setInitialColumnSizes(table, new int[]{30, 30, 15, 25});
        EObjectLabelProvider labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(String name, Object element) {
                TransitionType transition = (TransitionType)element;
                if (name.equals("condition")) {
                    String expression;
                    XmlTextNode type = transition.getExpression();
                    String string = expression = type == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
                    if ((expression == null || expression.trim().length() == 0) && transition.getCondition() != null) {
                        expression = transition.getCondition().trim();
                    }
                    return expression;
                }
                if (name.equals("fork") && transition.isForkOnTraversal()) {
                    return "true";
                }
                if (name.equals("activity")) {
                    return transition.getTo().getName();
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)labelProvider, new String[]{"id", "condition", "fork", "activity"});
        GatewaySymbol gateway = this.getGateway();
        FlowControlType kind = gateway.getFlowKind();
        final boolean isIn = kind != null && kind.getValue() == 1;
        this.setTitle(isIn ? Diagram_Messages.LBL_Incoming_Transitions : Diagram_Messages.LBL_Outgoing_Transitions);
        ActivitySymbolType activitySymbol = gateway.getActivitySymbol();
        final ActivityType activity = activitySymbol == null ? null : activitySymbol.getActivity();
        this.viewer.setContentProvider((IContentProvider)new ModelElementsTableContentProvider((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Transition(), elementFeatureIds, labelProperties, new IFilter(){

            public boolean select(Object toTest) {
                TransitionType trans = (TransitionType)toTest;
                return activity != null && (isIn && trans.getTo() == activity || !isIn && trans.getFrom() == activity);
            }
        }));
        return composite;
    }

    private void updateButtons(Object item) {
        GatewaySymbol gateway = this.getGateway();
        FlowControlType kind = gateway.getFlowKind();
        if (kind != null && kind.getValue() == 2) {
            this.upButton.setEnabled(item != null && this.canMoveUp(item));
            this.downButton.setEnabled(item != null && this.canMoveDown(item));
        }
    }
}

