/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.properties.ModelElementNotificationAdapter;
import org.eclipse.stardust.modeling.core.properties.OutlineProvider;

public class ModelElementsOutlineSynchronizer
extends ModelElementNotificationAdapter {
    private OutlineProvider provider;
    private boolean isInit = false;

    public ModelElementsOutlineSynchronizer(OutlineProvider provider) {
        super(provider.getElementListFeature(), new int[0], provider.getFilter(), false);
        this.provider = provider;
    }

    @Override
    public void init(EObject target) {
        if (!this.isInit) {
            this.dispose();
            super.init(target);
            this.provider.removeChildrenNodes(this.provider.getParentNodeId());
            if (target != null) {
                List elements = this.getChildren(target);
                int i = 0;
                while (i < elements.size()) {
                    this.addNode((EObject)elements.get(i), i);
                    ++i;
                }
            }
            this.isInit = true;
        } else {
            super.init(target);
        }
        this.provider.updateVisuals();
    }

    @Override
    public void elementChanged(EObject element) {
    }

    @Override
    public void elementAdded(EObject element) {
        this.addNode(element, this.getNewIndex());
        this.provider.updateVisuals();
    }

    private void addNode(final EObject element, int index) {
        IModelElement modelElement = null;
        if (element instanceof IModelElement) {
            modelElement = (IModelElement)element;
        } else {
            ClassLoader classLoader = IModelElement.class.getClassLoader();
            Class<?>[] interfaces = element.getClass().getInterfaces();
            Class[] classes = new Class[interfaces.length + 1];
            System.arraycopy(interfaces, 0, classes, 0, interfaces.length);
            classes[interfaces.length] = IModelElement.class;
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                    if (IModelElement.class.equals(mtd.getDeclaringClass())) {
                        return null;
                    }
                    return mtd.invoke((Object)element, args);
                }
            };
            modelElement = (IModelElement)Proxy.newProxyInstance(classLoader, classes, invocationHandler);
        }
        this.provider.addNodesFor(this.provider.getParentNodeId(), modelElement, new ModelElementAdaptable(new Class[]{IModelElement.class}, new Object[]{modelElement}, this.provider.getAdaptable()), index);
    }

    public List<IPreferenceNode> getNodes() {
        ArrayList<IPreferenceNode> nodesList = new ArrayList<IPreferenceNode>();
        PreferenceManager pm = this.provider.getPreferenceManager();
        CarnotPreferenceNode parent = (CarnotPreferenceNode)pm.find(this.provider.getParentNodeId());
        if (parent == null) {
            return nodesList;
        }
        IPreferenceNode[] nodes = parent.getSubNodes();
        int i = 0;
        while (i < nodes.length) {
            nodesList.add(nodes[i]);
            ++i;
        }
        return nodesList;
    }

    private int getNewIndex() {
        int index = -1;
        PreferenceManager pm = this.provider.getPreferenceManager();
        CarnotPreferenceNode parent = (CarnotPreferenceNode)pm.find(this.provider.getParentNodeId());
        IPreferenceNode[] nodes = parent.getSubNodes();
        int i = 0;
        while (i < nodes.length) {
            index = Math.max(index, ((CarnotPreferenceNode)nodes[i]).getSortOrder());
            ++i;
        }
        return index + 1;
    }

    @Override
    public void elementMoved(final EObject element) {
        if (element instanceof IModelElement) {
            IModelElement cfr_ignored_0 = (IModelElement)element;
        } else {
            ClassLoader classLoader = IModelElement.class.getClassLoader();
            Class<?>[] interfaces = element.getClass().getInterfaces();
            Class[] classes = new Class[interfaces.length + 1];
            System.arraycopy(interfaces, 0, classes, 0, interfaces.length);
            classes[interfaces.length] = IModelElement.class;
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                    if (IModelElement.class.equals(mtd.getDeclaringClass())) {
                        return null;
                    }
                    return mtd.invoke((Object)element, args);
                }
            };
            IModelElement cfr_ignored_1 = (IModelElement)Proxy.newProxyInstance(classLoader, classes, invocationHandler);
        }
        PreferenceManager pm = this.provider.getPreferenceManager();
        String prefix = this.provider.getParentNodeId();
        List elements = this.getChildren(element.eContainer());
        CarnotPreferenceNode parentNode = (CarnotPreferenceNode)pm.find(prefix);
        int i = 0;
        while (i < elements.size()) {
            EObject me = (EObject)elements.get(i);
            IPreferenceNode[] subnodes = parentNode.getSubNodes();
            int j = 0;
            while (j < subnodes.length) {
                CarnotPreferenceNode node;
                if (subnodes[j] instanceof CarnotPreferenceNode && me.equals((node = (CarnotPreferenceNode)subnodes[j]).getAdaptable().getAdapter(IModelElement.class))) {
                    node.setSortOrder(i);
                }
                ++j;
            }
            ++i;
        }
        this.provider.updateVisuals();
    }

    @Override
    public void elementRemoved(final EObject element) {
        IModelElement modelElement = null;
        if (element instanceof IModelElement) {
            modelElement = (IModelElement)element;
        } else {
            ClassLoader classLoader = IModelElement.class.getClassLoader();
            Class<?>[] interfaces = element.getClass().getInterfaces();
            Class[] classes = new Class[interfaces.length + 1];
            System.arraycopy(interfaces, 0, classes, 0, interfaces.length);
            classes[interfaces.length] = IModelElement.class;
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
                    if (IModelElement.class.equals(mtd.getDeclaringClass())) {
                        return null;
                    }
                    return mtd.invoke((Object)element, args);
                }
            };
            modelElement = (IModelElement)Proxy.newProxyInstance(classLoader, classes, invocationHandler);
        }
        String id = this.provider.getId(modelElement);
        this.provider.removeNode(String.valueOf(this.provider.getParentNodeId()) + "." + id);
        this.provider.updateVisuals();
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setInit(boolean isInit) {
        this.isInit = isInit;
    }
}

