/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.modeling.core.properties.ModelElementNotificationAdapter;

public class ModelElementsTableContentProvider
extends ModelElementNotificationAdapter
implements IStructuredContentProvider {
    private TableViewer viewer;
    private String[] labelProperties;
    private ModelElementNotificationAdapter attributeNotifier;

    public ModelElementsTableContentProvider(EStructuralFeature elementListFeature, int[] elementFeatureIds, String[] labelProperties) {
        super(elementListFeature, elementFeatureIds, true);
        this.labelProperties = labelProperties;
    }

    public ModelElementsTableContentProvider(EStructuralFeature elementListFeature, int[] elementFeatureIds, String[] labelProperties, IFilter filter) {
        super(elementListFeature, elementFeatureIds, filter, true);
        this.labelProperties = labelProperties;
    }

    public Object[] getElements(Object inputElement) {
        EObject owner = (EObject)inputElement;
        return this.getChildren(owner).toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        this.init((EObject)newInput);
        this.viewer = (TableViewer)viewer;
        this.registerAttributeNotifier(newInput);
    }

    @Override
    public void dispose() {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.dispose();
        }
        super.dispose();
    }

    @Override
    public void elementChanged(EObject element) {
        this.viewer.update((Object)element, this.labelProperties);
    }

    @Override
    public void elementAdded(EObject element) {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.init(element);
        }
        this.viewer.refresh();
    }

    @Override
    public void elementMoved(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementRemoved(EObject element) {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.dispose(element);
        }
        this.viewer.refresh();
    }

    public void setLabelChangingAttributes(final String[] attributes) {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.dispose();
        }
        this.attributeNotifier = new ModelElementNotificationAdapter((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), new int[]{6}, new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof AttributeType) {
                    AttributeType attribute = (AttributeType)toTest;
                    int i = 0;
                    while (i < attributes.length) {
                        if (attributes[i].equals(attribute.getName())) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        }, true){

            @Override
            public void elementRemoved(EObject element) {
                ModelElementsTableContentProvider.this.elementChanged(element.eContainer());
            }

            @Override
            public void elementMoved(EObject element) {
            }

            @Override
            public void elementChanged(EObject element) {
                ModelElementsTableContentProvider.this.elementChanged(element.eContainer());
            }

            @Override
            public void elementAdded(EObject element) {
                ModelElementsTableContentProvider.this.elementChanged(element.eContainer());
            }
        };
        this.registerAttributeNotifier();
    }

    private void registerAttributeNotifier() {
        Iterator i = this.targets();
        while (i.hasNext()) {
            this.registerAttributeNotifier(i.next());
        }
    }

    private void registerAttributeNotifier(Object target) {
        if (this.attributeNotifier != null && target != null) {
            List children = this.getChildren((EObject)target);
            int i = 0;
            while (i < children.size()) {
                this.attributeNotifier.init((EObject)children.get(i));
                ++i;
            }
        }
    }
}

