/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DataPathPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.properties.ModelElementsTableContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ProcessDefinitionDataPathsPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String DATA_PATHS_ID = "_cwm_data_paths_";
    private static final int[] elementFeatureIds = new int[]{1, 2, 5, 6};
    private static final String[] labelProperties = new String[]{"id"};
    private Button[] buttons;
    private Object selection;
    private EObjectLabelProvider labelProvider;
    private TableViewer viewer;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.viewer.setInput((Object)element);
        this.outlineSynchronizer.init((EObject)element);
        this.updateButtons(null, this.buttons);
        this.expandTree();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void dispose() {
        this.outlineSynchronizer.dispose();
        super.dispose();
    }

    private ProcessDefinitionType getProcess() {
        return (ProcessDefinitionType)this.getModelElement();
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Table table = new Table(composite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionDataPathsPropertyPage.this.updateButtons(ProcessDefinitionDataPathsPropertyPage.this.getSelectedItem(), ProcessDefinitionDataPathsPropertyPage.this.buttons);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = ProcessDefinitionDataPathsPropertyPage.this.getSelectedItem();
                if (selection instanceof DataPathType) {
                    ProcessDefinitionDataPathsPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TableViewer(table);
        TableUtil.createColumns(table, new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_Description});
        TableUtil.setInitialColumnSizes(table, new int[]{35, 35, 30});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(String name, Object element) {
                DataPathType dataPath;
                DataType data;
                if ("data".equals(name) && (data = (dataPath = (DataPathType)element).getData()) != null) {
                    String text = super.getText(Diagram_Messages.TXT_NAME, (Object)data);
                    return StringUtils.isEmpty((String)dataPath.getDataPath()) ? text : String.valueOf(text) + "." + dataPath.getDataPath();
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)this.labelProvider, new String[]{"id", "name", "data"});
        this.viewer.setContentProvider((IContentProvider)new ModelElementsTableContentProvider((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_DataPath(), elementFeatureIds, labelProperties));
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(new DefaultOutlineProvider((AbstractModelElementPropertyPage)this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_DataPath(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name(), DATA_PATHS_ID, DataPathPropertyPage.class.getName()));
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        return composite;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        buttons[0].setEnabled(true);
        buttons[1].setEnabled(selection instanceof DataPathType && !"PROCESS_ATTACHMENTS".equals(((DataPathType)selection).getId()));
        buttons[2].setEnabled(selection instanceof DataPathType && this.canMoveUp((DataPathType)selection));
        buttons[3].setEnabled(selection instanceof DataPathType && this.canMoveDown((DataPathType)selection));
    }

    private boolean canMoveUp(DataPathType selection) {
        ProcessDefinitionType pd = (ProcessDefinitionType)selection.eContainer();
        return pd.getDataPath().indexOf((Object)selection) > 0;
    }

    private boolean canMoveDown(DataPathType selection) {
        ProcessDefinitionType pd = (ProcessDefinitionType)selection.eContainer();
        int index = pd.getDataPath().indexOf((Object)selection);
        return index >= 0 && index < pd.getDataPath().size() - 1;
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionDataPathsPropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionDataPathsPropertyPage.this.performDelete(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionDataPathsPropertyPage.this.performUp(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessDefinitionDataPathsPropertyPage.this.performDown(buttons);
            }
        })};
        return buttons;
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    private void performUp(Button[] buttons) {
        DataPathType dataPath = (DataPathType)this.getSelection();
        EList paths = this.getProcess().getDataPath();
        int index = paths.indexOf((Object)dataPath);
        if (index > 0) {
            paths.move(index - 1, index);
            this.updateButtons(dataPath, buttons);
        }
    }

    private void performDown(Button[] buttons) {
        DataPathType dataPath = (DataPathType)this.getSelection();
        EList paths = this.getProcess().getDataPath();
        int index = paths.indexOf((Object)dataPath);
        if (index >= 0 && index < paths.size() - 1) {
            paths.move(index + 1, index);
            this.updateButtons(dataPath, buttons);
        }
    }

    private void performDelete(Button[] buttons) {
        DataPathType dataPath = (DataPathType)this.getSelection();
        ProcessDefinitionType process = this.getProcess();
        process.getDataPath().remove((Object)dataPath);
        this.updateButtons(null, buttons);
        this.selectPage(DATA_PATHS_ID);
    }

    private void performAdd(Button[] buttons) {
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        DataPathType dataPath = factory.createDataPathType();
        ProcessDefinitionType process = this.getProcess();
        IdFactory idFactory = new IdFactory(Diagram_Messages.ID_DataPath, Diagram_Messages.BASENAME_DataPath);
        idFactory.computeNames((List)process.getDataPath());
        dataPath.setId(idFactory.getId());
        dataPath.setName(idFactory.getName());
        dataPath.setData(null);
        dataPath.setDescriptor(false);
        dataPath.setDirection(DirectionType.IN_LITERAL);
        dataPath.setDataPath("");
        process.getDataPath().add((Object)dataPath);
        this.selectPageForObject(dataPath);
    }
}

