/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.QualityControlType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.properties.QualityAssuranceCodePropertyPage;
import org.eclipse.stardust.modeling.core.properties.QualityAssuranceCodesTreeContentProvider;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class QualityAssuranceCodesPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String CODES_ID = "_cwm_quality_control_codes_";
    private TreeViewer viewer;
    private TableLabelProvider labelProvider;
    private Button[] buttons;
    private Object selection;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;
    private ModelType model;

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    @Override
    public void dispose() {
        if (this.outlineSynchronizer != null) {
            this.outlineSynchronizer.dispose();
        }
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        boolean isValid = selection instanceof Code;
        buttons[0].setEnabled(true);
        buttons[1].setEnabled(isValid);
        buttons[2].setEnabled(this.canMoveUp((Code)selection));
        buttons[3].setEnabled(this.canMoveDown((Code)selection));
    }

    private boolean canMoveUp(Code selection) {
        ModelType model = this.getModel();
        EList codes = model.getQualityControl().getCode();
        return codes.indexOf((Object)selection) > 0;
    }

    private boolean canMoveDown(Code selection) {
        ModelType model = this.getModel();
        EList codes = model.getQualityControl().getCode();
        int index = codes.indexOf((Object)selection);
        return index >= 0 && index < codes.size() - 1;
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QualityAssuranceCodesPropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QualityAssuranceCodesPropertyPage.this.performDelete(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QualityAssuranceCodesPropertyPage.this.performUp(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QualityAssuranceCodesPropertyPage.this.performDown(buttons);
            }
        })};
        return buttons;
    }

    @Override
    public Object getSelection() {
        Object object = this.selection == null ? this.getSelectedItem() : this.selection;
        return object;
    }

    private Object getSelectedItem() {
        Proxy proxy;
        InvocationHandler ih;
        Object value;
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        if (selection instanceof Proxy && (value = Reflect.getFieldValue((Object)(ih = Proxy.getInvocationHandler(proxy = (Proxy)selection)), (String)"val$element")) != null) {
            selection = value;
        }
        return selection;
    }

    private void performDelete(Button[] buttons) {
        Code code = (Code)this.getSelection();
        if (code != null) {
            ModelType model = this.getModel();
            model.getQualityControl().getCode().remove((Object)code);
            this.updateButtons(null, buttons);
            this.selectPage(CODES_ID);
        }
    }

    private void performAdd(Button[] buttons) {
        Code code = CarnotWorkflowModelFactory.eINSTANCE.createCode();
        IdFactory factory = new IdFactory("code", "code", CarnotWorkflowModelPackage.eINSTANCE.getCode(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getCode_Code(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getCode_Code());
        factory.computeNames((List)this.getModel().getQualityControl().getCode());
        ModelType model = this.getModel();
        QualityControlType qualityControl = model.getQualityControl();
        if (qualityControl == null) {
            model.setQualityControl(CarnotWorkflowModelFactory.eINSTANCE.createQualityControlType());
        }
        qualityControl = model.getQualityControl();
        EList codes = qualityControl.getCode();
        code.setCode(factory.getId());
        code.setName(factory.getName());
        codes.add((Object)code);
        this.selectPageForObject(code);
    }

    private void performUp(Button[] buttons) {
        Code code = (Code)this.getSelection();
        ModelType model = this.getModel();
        EList codes = model.getQualityControl().getCode();
        int index = codes.indexOf((Object)code);
        if (index > 0) {
            codes.move(index - 1, index);
            this.updateButtons(code, buttons);
        }
    }

    private void performDown(Button[] buttons) {
        Code code = (Code)this.getSelection();
        ModelType model = this.getModel();
        EList codes = model.getQualityControl().getCode();
        int index = codes.indexOf((Object)code);
        if (index >= 0 && index < codes.size() - 1) {
            codes.move(index + 1, index);
            this.updateButtons(code, buttons);
        }
    }

    private ModelType getModel() {
        Object modelElement;
        IAdaptable element;
        if (this.model == null && (element = this.getElement()) instanceof EditPart && (modelElement = ((EditPart)element).getModel()) instanceof ModelType) {
            this.model = (ModelType)modelElement;
        }
        return this.model;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement node) {
        ModelType model = this.getModel();
        QualityControlType qualityControl = model.getQualityControl();
        if (qualityControl == null) {
            model.setQualityControl(CarnotWorkflowModelFactory.eINSTANCE.createQualityControlType());
        }
        qualityControl = model.getQualityControl();
        this.viewer.setInput((Object)qualityControl);
        this.viewer.expandAll();
        this.outlineSynchronizer.init((EObject)qualityControl);
        this.updateButtons(null, this.buttons);
        this.expandTree();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QualityAssuranceCodesPropertyPage.this.updateButtons(QualityAssuranceCodesPropertyPage.this.getSelectedItem(), QualityAssuranceCodesPropertyPage.this.buttons);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = QualityAssuranceCodesPropertyPage.this.getSelectedItem();
                if (selection instanceof Code) {
                    QualityAssuranceCodesPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, new String[]{Diagram_Messages.QUALITY_CONTROL_CODE, Diagram_Messages.LB_Name});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public Image getImage(Object element) {
                return null;
            }

            @Override
            public String getText(String name, Object element) {
                String value = null;
                if (element instanceof Code) {
                    Code code = (Code)element;
                    if (name.equals("name")) {
                        value = code.getName();
                        if (StringUtils.isEmpty((String)value)) {
                            value = code.getCode();
                        }
                    } else if (name.equals("code")) {
                        value = code.getCode();
                    }
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, this.labelProvider, new String[]{"code", "name"});
        this.viewer.setContentProvider((IContentProvider)new QualityAssuranceCodesTreeContentProvider());
        DefaultOutlineProvider op = new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getQualityControlType_Code(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getCode_Code(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getCode_Name(), CODES_ID, QualityAssuranceCodePropertyPage.class.getName()){

            @Override
            public ConfigurationElement createPageConfiguration(IModelElement element) {
                Code code = (Code)element;
                return ConfigurationElement.createPageConfiguration(code.getCode(), code.getName(), this.getEditor().getIconFactory().getIconFor((EObject)code), QualityAssuranceCodePropertyPage.class.getName());
            }

            @Override
            public IAdaptable getAdaptable() {
                IAdaptable original = this.page.getElement();
                return new ModelElementAdaptable(new Class[]{IButtonManager.class, IModelElementNodeSymbol.class}, new Object[]{this.page}, original);
            }

            @Override
            public void addNodeTo(String parentNodeId, CarnotPreferenceNode node) {
                this.page.addNodeTo(parentNodeId, node, new EObjectLabelProvider(this.getEditor()){

                    @Override
                    public String getText(String name, Object element) {
                        Code code = (Code)element;
                        return code.getName();
                    }

                    @Override
                    public Image getImage(Object element) {
                        return DiagramPlugin.getImage("/icons/full/obj16/context.gif");
                    }
                });
            }
        };
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(op);
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        return composite;
    }

    public Point computeSize() {
        TableUtil.setInitialColumnSizesDirect((Control)this.viewer.getTree(), new int[]{35, 65});
        return super.computeSize();
    }
}

