/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class ReferencedModelSorter
extends ViewerSorter {
    private boolean grouped = false;
    private ModelType model;

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!this.isGrouped()) {
            return super.compare(viewer, e1, e2);
        }
        ModelType model1 = ModelUtils.findContainingModel((EObject)((EObject)e1));
        ModelType model2 = ModelUtils.findContainingModel((EObject)((EObject)e2));
        if (model1 == null && model2 == null && e1 instanceof AccessPointType && e2 instanceof AccessPointType) {
            AccessPointType ap1 = (AccessPointType)e1;
            AccessPointType ap2 = (AccessPointType)e2;
            model1 = this.parseReferencedModel(ap1);
            model2 = this.parseReferencedModel(ap2);
        }
        if (model1 != model2) {
            if (model1 == this.model) {
                return -1;
            }
            if (model2 == this.model) {
                return 1;
            }
        }
        return super.compare(viewer, e1, e2);
    }

    public void setModel(ModelType model) {
        this.model = model;
    }

    private ModelType parseReferencedModel(AccessPointType apt) {
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)apt, (String)"carnot:engine:dataType");
        if (attribute == null) {
            return this.model;
        }
        String path = attribute.getValue();
        if (path.startsWith("typeDeclaration:")) {
            int idx1 = path.indexOf("{");
            int idx2 = path.indexOf("}");
            String modelID = path.substring(idx1 + 1, idx2);
            List refModelsURI = ModelUtils.getURIsForExternalPackages((ModelType)this.model);
            Iterator i = refModelsURI.iterator();
            while (i.hasNext()) {
                ModelType refModel = ModelUtils.getReferencedModelByURI((ModelType)this.model, (String)((String)i.next()));
                if (!refModel.getId().equalsIgnoreCase(modelID)) continue;
                return refModel;
            }
        }
        return this.model;
    }
}

