/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.search.CleanupModelSearchQuery;
import org.eclipse.stardust.modeling.core.search.CleanupModelSearchResult;
import org.eclipse.stardust.modeling.core.search.actions.DeleteSelectedAction;
import org.eclipse.stardust.modeling.core.search.tree.EditorSelectionChangedListener;
import org.eclipse.stardust.modeling.core.search.tree.ResultViewModelTreeEditPart;
import org.eclipse.stardust.modeling.core.search.tree.ResultViewTreeEditPartFactory;
import org.eclipse.stardust.modeling.core.search.tree.ResultViewTreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class CleanupResultPage
extends Page
implements ISearchResultPage,
ISearchResultListener,
ISelectionProvider,
NotificationAdaptee {
    private String id;
    private String label = "";
    private Object uiState;
    private Composite composite;
    private Tree tree;
    private ResultViewTreeViewer viewer;
    private ActionRegistry actionRegistry;
    private Collection selectionChangedListeners = new ArrayList();
    private EditorSelectionChangedListener selectionChangedListener;
    private ISelection pageSelection;
    private CleanupModelSearchResult searchResult;
    private ISearchResultViewPart part;
    private ModelType model;
    private SelectionAction action;
    private NotificationAdapter notificationAdapter;
    private Set checkedItems;

    public Object getUIState() {
        return this.uiState;
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.uiState = uiState;
        this.searchResult = (CleanupModelSearchResult)search;
        if (this.searchResult != null) {
            this.searchResult.addListener(this);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.part = part;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IPageSite getSite() {
        return super.getSite();
    }

    public void init(IPageSite site) {
        super.init(site);
    }

    public void createControl(Composite parent) {
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.composite.setLayout((Layout)new FillLayout());
        this.tree = FormBuilder.createTree((Composite)this.composite, (int)32);
        this.viewer = new ResultViewTreeViewer();
        this.viewer.setControl((Control)this.tree);
        this.selectionChangedListener = new EditorSelectionChangedListener(this);
        this.initViewer(editor);
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getControl().setVisible(false);
        this.tree.setLayout((Layout)new FillLayout());
        this.tree.setLayoutData(null);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TreeItem item = (TreeItem)e.item;
                    CleanupResultPage.this.setState(item, true);
                }
            }
        });
    }

    private void initViewer(WorkflowModelEditor editor) {
        this.action = new DeleteSelectedAction((IWorkbenchPart)editor);
        this.getSite().getActionBars().getToolBarManager().removeAll();
        this.getSite().getActionBars().getToolBarManager().add((IAction)this.action);
        ResultViewTreeEditPartFactory factory = new ResultViewTreeEditPartFactory(editor);
        this.viewer.setEditDomain(editor.getEditDomain());
        this.viewer.setEditPartFactory(factory);
        this.selectionChangedListener.setEditor(editor);
    }

    public void dispose() {
        if (this.model != null) {
            this.model.eAdapters().remove((Object)this.notificationAdapter);
        }
        super.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void searchResultChanged(SearchResultEvent e) {
        final Map matchedElements = this.searchResult.getMatchedElements();
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                CleanupResultPage.this.initViewer(editor);
                CleanupResultPage.this.viewer.setMatchedElements(matchedElements);
                CleanupResultPage.this.notificationAdapter = new NotificationAdapter(CleanupResultPage.this);
                if (CleanupResultPage.this.model != null) {
                    CleanupResultPage.this.model.eAdapters().remove((Object)CleanupResultPage.this.notificationAdapter);
                }
                CleanupResultPage.this.model = (ModelType)editor.getModel();
                CleanupResultPage.this.model.eAdapters().add((Object)CleanupResultPage.this.notificationAdapter);
                CleanupResultPage.this.viewer.setContents(CleanupResultPage.this.model, Diagram_Messages.LB_UnusedModelElements, true);
                if (CleanupResultPage.this.tree != null && CleanupResultPage.this.tree.getItemCount() > 0) {
                    CleanupResultPage.this.tree.getItem(0).setExpanded(true);
                }
                Integer numberMatchedElements = new Integer(CleanupResultPage.this.viewer.getResultViewFilter().getNumberMatchedElements());
                CleanupResultPage.this.label = MessageFormat.format(Diagram_Messages.LB_Result, ((CleanupModelSearchQuery)CleanupResultPage.this.searchResult.getQuery()).getLabel(), numberMatchedElements, numberMatchedElements == 1 ? Diagram_Messages.LB_Item : Diagram_Messages.LB_Items);
                CleanupResultPage.this.part.updateLabel();
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.pageSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (selection == null) {
            return;
        }
        this.pageSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    private void setState(TreeItem item, boolean setChecked) {
        boolean checked = item.getChecked();
        if (this.checkedItems == null) {
            this.checkedItems = new HashSet();
        }
        this.setItem(item, checked, setChecked);
        ((DeleteSelectedAction)this.action).setSelectedElements(this.checkedItems);
        this.action.update();
        this.getSite().getActionBars().getToolBarManager().update(true);
    }

    private void setItem(TreeItem item, boolean checked, boolean setChecked) {
        Object data = item.getData();
        if (data instanceof ResultViewModelTreeEditPart) {
            ResultViewModelTreeEditPart editPartItem = (ResultViewModelTreeEditPart)data;
            TreeItem editPartTreeItem = (TreeItem)editPartItem.getWidget();
            if (setChecked) {
                editPartTreeItem.setChecked(checked);
            }
            TreeItem[] itemsArray = item.getItems();
            List<TreeItem> items = Arrays.asList(itemsArray);
            for (TreeItem childItem : items) {
                this.setItem(childItem, checked, setChecked);
            }
        } else if (data instanceof ChildCategoryNode) {
            ChildCategoryNode editPartItem = (ChildCategoryNode)data;
            TreeItem editPartTreeItem = (TreeItem)editPartItem.getWidget();
            if (setChecked) {
                editPartTreeItem.setChecked(checked);
            }
            TreeItem[] itemsArray = item.getItems();
            List<TreeItem> items = Arrays.asList(itemsArray);
            for (TreeItem childItem : items) {
                this.setItem(childItem, checked, setChecked);
            }
        } else if (data instanceof AbstractEObjectTreeEditPart || data instanceof IdentifiableModelElementTreeEditPart) {
            EObject model = (EObject)((AbstractEObjectTreeEditPart)data).getModel();
            AbstractEObjectTreeEditPart editPartItem = (AbstractEObjectTreeEditPart)data;
            TreeItem editPartTreeItem = (TreeItem)editPartItem.getWidget();
            if (setChecked) {
                editPartTreeItem.setChecked(checked);
            }
            boolean isChecked = item.getChecked();
            if (!(model instanceof TypeDeclarationsType)) {
                if (isChecked) {
                    this.checkedItems.add(model);
                } else {
                    this.checkedItems.remove(model);
                }
            }
            TreeItem[] itemsArray = item.getItems();
            List<TreeItem> items = Arrays.asList(itemsArray);
            for (TreeItem childItem : items) {
                this.setItem(childItem, checked, setChecked);
            }
        } else if (!(data instanceof DiagramEditPart)) {
            boolean cfr_ignored_0 = data instanceof AbstractModelElementNodeSymbolEditPart;
        }
    }

    @Override
    public Object getModel() {
        return null;
    }

    @Override
    public void handleNotification(Notification notification) {
        RootEditPart root = this.viewer.getRootEditPart();
        ResultViewModelTreeEditPart modelTreeEditPart = (ResultViewModelTreeEditPart)((AbstractEObjectTreeEditPart)root.getChildren().get(0)).getChildren().get(0);
        TreeItem editPartTreeItem = (TreeItem)modelTreeEditPart.getWidget();
        if (editPartTreeItem != null) {
            this.checkedItems = new HashSet();
            this.setItem(editPartTreeItem, false, false);
            ((DeleteSelectedAction)this.action).setSelectedElements(this.checkedItems);
            this.action.update();
            this.getSite().getActionBars().getToolBarManager().update(true);
        }
    }
}

