/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.search.WorkflowModelSearchResult;

public class WorkflowModelSearchQuery
implements ISearchQuery {
    private final String searchText;
    private final ModelType model;
    private final WorkflowModelSearchResult result;
    private Set matchedElements = new HashSet();

    public WorkflowModelSearchQuery(String searchText, ModelType model) {
        this.searchText = searchText.toLowerCase();
        this.model = model;
        this.result = new WorkflowModelSearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        String[] searchStrings = this.searchText.split(" ");
        if (searchStrings.length > 1) {
            int i = 0;
            while (i < searchStrings.length) {
                this.search(searchStrings[i]);
                ++i;
            }
        } else {
            String searchString = this.searchText;
            this.search(searchString);
        }
        this.result.setMatchedElements(this.matchedElements);
        return Status.OK_STATUS;
    }

    private void search(String searchString) {
        TreeIterator iter = this.model.eAllContents();
        while (iter.hasNext()) {
            String description;
            EObject element = (EObject)iter.next();
            if (!(element instanceof IIdentifiableModelElement) || element instanceof IMetaType) continue;
            IIdentifiableModelElement identifiableElement = (IIdentifiableModelElement)element;
            if (identifiableElement.getName() != null && identifiableElement.getName().toLowerCase().indexOf(searchString) >= 0) {
                this.matchedElements.add(identifiableElement);
            }
            if ((description = ModelUtils.getDescriptionText((DescriptionType)identifiableElement.getDescription())) == null || description.toLowerCase().indexOf(searchString) < 0) continue;
            this.matchedElements.add(identifiableElement);
            this.matchedElements.add(identifiableElement.getDescription());
        }
    }

    public String getLabel() {
        return Diagram_Messages.LB_SearchQuery;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public String getSearchText() {
        return this.searchText;
    }
}

