/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;

public class ConfigurationElement {
    public static final String CFG_PAGE = "page";
    private HashMap attributes = new HashMap();
    private String name;
    private IConfigurationElement delegate;
    private Class pageClass;

    public ConfigurationElement(IConfigurationElement delegate) {
        this.delegate = delegate;
    }

    public ConfigurationElement(String name) {
        this.name = name;
    }

    private void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public Object createExecutableExtension(String propertyName) throws CoreException {
        if (this.delegate != null) {
            return this.delegate.createExecutableExtension(propertyName);
        }
        try {
            if (this.pageClass == null) {
                String propertyClass = (String)this.attributes.get(propertyName);
                this.pageClass = Class.forName(propertyClass);
            }
            return this.pageClass.newInstance();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 4, e.getMessage(), (Throwable)e));
        }
    }

    public String getAttribute(String name) throws InvalidRegistryObjectException {
        if (this.delegate != null) {
            return "icon".equals(name) ? SpiExtensionRegistry.encodeExtensionIcon((IConfigurationElement)this.delegate) : this.delegate.getAttribute(name);
        }
        return (String)this.attributes.get(name);
    }

    public String getName() throws InvalidRegistryObjectException {
        if (this.delegate != null) {
            return this.delegate.getName();
        }
        return this.name;
    }

    public static ConfigurationElement createPageConfiguration(String id, String name, String icon, String propertyPageClass, String category) {
        ConfigurationElement page = ConfigurationElement.createPageConfiguration(id, name, icon, propertyPageClass);
        page.setAttribute("category", category);
        return page;
    }

    public static ConfigurationElement createPageConfiguration(String id, String name, String icon, String propertyPageClass) {
        ConfigurationElement page = new ConfigurationElement(CFG_PAGE);
        page.setAttribute("id", id);
        page.setAttribute("name", name);
        page.setAttribute("icon", icon);
        page.setAttribute("propertyPageClass", propertyPageClass);
        return page;
    }

    public static ConfigurationElement createPageConfiguration(String id, String name, String icon, Class<?> propertyPageClass) {
        ConfigurationElement page = new ConfigurationElement(CFG_PAGE);
        page.setAttribute("id", id);
        page.setAttribute("name", name);
        page.setAttribute("icon", icon);
        page.setAttribute("propertyPageClass", propertyPageClass.getName());
        page.pageClass = propertyPageClass;
        return page;
    }

    public ConfigurationElement[] getChildren(String elementName) {
        if (this.delegate != null) {
            IConfigurationElement[] children = this.delegate.getChildren(elementName);
            ConfigurationElement[] result = new ConfigurationElement[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new ConfigurationElement(children[i]);
                ++i;
            }
            return result;
        }
        return new ConfigurationElement[0];
    }

    public String[] getAttributeNames() {
        if (this.delegate != null) {
            return this.delegate.getAttributeNames();
        }
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }
}

