/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.engine.extensions.jms.app.DefaultMessageAcceptor;
import org.eclipse.stardust.engine.extensions.jms.app.JMSLocation;
import org.eclipse.stardust.engine.extensions.jms.app.MessageType;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IMessageAcceptor;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ResponsePropertyPage
extends AbstractModelElementPropertyPage {
    private static final String MESSAGE_ACCEPTOR = "carnot:engine:messageAcceptor";
    private static final String MESSAGE_TYPE = "carnot:engine:responseMessageType";
    private static final String[] types = new String[]{MessageType.MAP.getId(), MessageType.OBJECT.getId(), MessageType.TEXT.getId(), MessageType.STREAM.getId()};
    private static final String[] classNames;
    private ComboViewer messageTypeCombo;
    private ComboViewer acceptorCombo;
    private Button[] buttons;
    private ISelectionChangedListener acceptorListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ResponsePropertyPage.this.acceptorChanged(true);
        }
    };
    private ISelectionChangedListener messageListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ResponsePropertyPage.this.messageTypeChanged();
        }
    };

    static {
        String[] stringArray = new String[4];
        stringArray[1] = Object.class.getName();
        stringArray[2] = String.class.getName();
        classNames = stringArray;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.acceptorCombo.removeSelectionChangedListener(this.acceptorListener);
        this.messageTypeCombo.removeSelectionChangedListener(this.messageListener);
        ApplicationType application = (ApplicationType)element;
        Collection acceptors = this.getAcceptors();
        String acceptorClass = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)MESSAGE_ACCEPTOR);
        this.acceptorCombo.setInput((Object)acceptors);
        IMessageAcceptor acceptor = this.findAcceptor(acceptors, acceptorClass);
        this.acceptorCombo.setSelection((ISelection)(acceptor == null ? null : new StructuredSelection((Object)acceptor)));
        this.acceptorChanged(false);
        String messageType = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)MESSAGE_TYPE);
        this.messageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)(messageType == null ? types[0] : messageType)));
        this.acceptorCombo.addSelectionChangedListener(this.acceptorListener);
        this.messageTypeCombo.addSelectionChangedListener(this.messageListener);
    }

    private IMessageAcceptor findAcceptor(Collection acceptors, String acceptorClass) {
        for (IMessageAcceptor msgAcceptor : acceptors) {
            if (!msgAcceptor.getRuntimeClassName().equals(acceptorClass)) continue;
            return msgAcceptor;
        }
        return acceptorClass == null && acceptors.size() == 1 ? acceptors.iterator().next() : null;
    }

    private Collection getAcceptors() {
        TreeMap<String, IMessageAcceptor> acceptors = new TreeMap<String, IMessageAcceptor>();
        Map extensions = SpiExtensionRegistry.instance().getExtensions("acceptorProviders");
        for (IConfigurationElement config : extensions.values()) {
            try {
                IMessageAcceptor acceptor = (IMessageAcceptor)config.createExecutableExtension("acceptorClass");
                acceptors.put(acceptor.getName(), acceptor);
            }
            catch (CoreException coreException) {}
        }
        IMessageAcceptor defaultAcceptor = new IMessageAcceptor(){

            public String getName() {
                return Diagram_Messages.NAME_ACCEPTOR_Default;
            }

            public Collection getMessageTypes() {
                return Arrays.asList(types);
            }

            public String getRuntimeClassName() {
                return DefaultMessageAcceptor.class.getName();
            }

            public Collection getPredefinedAccessPoints(String messageType) {
                int i = 1;
                while (i < 3) {
                    if (types[i].equals(messageType)) {
                        return Collections.singletonList(ResponsePropertyPage.this.getAccessPoint(classNames[i]));
                    }
                    ++i;
                }
                return Collections.EMPTY_LIST;
            }
        };
        acceptors.put(defaultAcceptor.getName(), defaultAcceptor);
        return acceptors.values();
    }

    private Object getAccessPoint(String classname) {
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)"content", (String)Diagram_Messages.BASENAME_Content, (String)classname, (DirectionType)DirectionType.OUT_LITERAL, (boolean)true, null, (DataTypeType)ModelUtils.getDataType((IModelElement)this.getApplication(), (String)"serializable"));
        AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:jms.location", (String)JMSLocation.class.getName(), (String)JMSLocation.BODY.getId());
        return ap;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = (ApplicationType)element;
        IMessageAcceptor acceptor = this.getSelectedAcceptor();
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)MESSAGE_ACCEPTOR, (String)(acceptor == null ? null : acceptor.getRuntimeClassName()));
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)MESSAGE_TYPE, (String)MessageType.class.getName(), (String)this.getSelectedMessageType());
    }

    private IMessageAcceptor getSelectedAcceptor() {
        IStructuredSelection selection = (IStructuredSelection)this.acceptorCombo.getSelection();
        IMessageAcceptor acceptor = null;
        if (selection != null && !selection.isEmpty()) {
            acceptor = (IMessageAcceptor)selection.getFirstElement();
        }
        return acceptor;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_MessageAcceptor);
        this.acceptorCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.acceptorCombo.setSorter(new ViewerSorter());
        this.acceptorCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.acceptorCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMessageAcceptor)element).getName();
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_MessageType);
        this.messageTypeCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.messageTypeCombo.setSorter(new ViewerSorter());
        this.messageTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        return composite;
    }

    private void messageTypeChanged() {
        ApplicationType application = this.getApplication();
        EList aps = application.getAccessPoint();
        int i = aps.size() - 1;
        while (i >= 0) {
            AccessPointType ap = (AccessPointType)aps.get(i);
            if (ap.getDirection().equals((Object)DirectionType.OUT_LITERAL)) {
                aps.remove(ap);
            }
            --i;
        }
        IMessageAcceptor acceptor = this.getSelectedAcceptor();
        if (acceptor != null) {
            String messageType = this.getSelectedMessageType();
            aps.addAll(acceptor.getPredefinedAccessPoints(messageType));
        }
    }

    private String getSelectedMessageType() {
        IStructuredSelection selection = (IStructuredSelection)this.messageTypeCombo.getSelection();
        String messageType = null;
        if (selection != null && !selection.isEmpty()) {
            messageType = (String)selection.getFirstElement();
        }
        return messageType;
    }

    private ApplicationType getApplication() {
        return (ApplicationType)this.getElement().getAdapter(IModelElement.class);
    }

    private void acceptorChanged(boolean propagate) {
        this.messageTypeCombo.setInput(null);
        IMessageAcceptor provider = this.getSelectedAcceptor();
        if (provider != null) {
            Collection messageTypes = provider.getMessageTypes();
            this.messageTypeCombo.setInput((Object)messageTypes);
            if (!messageTypes.isEmpty()) {
                this.messageTypeCombo.setSelection((ISelection)new StructuredSelection(messageTypes.iterator().next()));
            }
        }
        if (propagate) {
            this.messageTypeChanged();
        }
    }

    public void setVisible(boolean visible) {
        IButtonManager manager;
        if (visible && (manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class)) != null) {
            manager.updateButtons("Response", this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }
}

