/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.plainJava;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationInitializer;

public class JavaApplicationInitializer
implements IApplicationInitializer {
    private String sourceName;
    private String targetName;

    public JavaApplicationInitializer(String sourceName, String targetName) {
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public List initialize(ApplicationType data, List attributes) {
        List result = null;
        int i = 0;
        while (i < attributes.size()) {
            String methodName;
            AttributeType attribute = (AttributeType)attributes.get(i);
            if (this.sourceName.equals(attribute.getName()) || this.targetName.equals(attribute.getName())) {
                String className = attribute.getValue();
                if (className != null && className.length() > 0) {
                    result = this.addAttribute(result, this.targetName, className);
                }
            } else if ("carnot:engine:methodName".equals(attribute.getName())) {
                methodName = attribute.getValue();
                if (methodName != null && methodName.length() > 0) {
                    result = this.addAttribute(result, "carnot:engine:methodName", methodName);
                }
            } else if ("carnot:engine:createMethodName".equals(attribute.getName()) && (methodName = attribute.getValue()) != null && methodName.length() > 0) {
                result = this.addAttribute(result, "carnot:engine:createMethodName", methodName);
            }
            ++i;
        }
        return result;
    }

    private List addAttribute(List result, String name, String value) {
        if (result == null) {
            result = new ArrayList<AttributeType>();
        }
        AttributeType attribute = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
        attribute.setName(name);
        attribute.setValue(value);
        result.add(attribute);
        return result;
    }
}

