/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.plainJava;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.utils.JavaAccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPointProvider;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class PlainJavaAccessPointProvider
implements IAccessPointProvider {
    public List<AccessPointType> createIntrinsicAccessPoint(IModelElement element) {
        List<AccessPointType> result = Collections.emptyList();
        if (element instanceof IExtensibleElement) {
            String className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className");
            className = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(className);
            String methodName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
            methodName = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(methodName);
            String constructorName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:constructorName");
            constructorName = VariableContextHelper.getInstance().getContext(element).replaceAllVariablesByDefaultValue(constructorName);
            result = PlainJavaAccessPointProvider.getIntrinsicAccessPoints((IExtensibleElement)element, className, methodName, constructorName, null, null, false);
        }
        return result;
    }

    public static List<AccessPointType> getIntrinsicAccessPoints(IExtensibleElement element, String className, String methodName, String constructorName, DirectionType direction, String hint, boolean paramsOnly) {
        return PlainJavaAccessPointProvider.getIntrinsicAccessPoints(element, className, methodName, false, constructorName, direction, hint, paramsOnly);
    }

    public static List<AccessPointType> getIntrinsicAccessPoints(IExtensibleElement element, String fullClassName, String methodName, boolean usedForObjectCreation, String constructorName, DirectionType direction, String hint, boolean paramsOnly) {
        List accessPoints = CollectionUtils.newList();
        if (element != null) {
            TypeFinder finder;
            TypeInfo type;
            IModelElement ref = element instanceof ITypedElement ? ((ITypedElement)element).getMetaType() : (IModelElement)element;
            DataTypeType dataType = ModelUtils.getDataType((IModelElement)ref, (String)"serializable");
            AttributeType browsable = AttributeUtil.getAttribute((IExtensibleElement)element, (String)"carnot:engine:browsable");
            if ((browsable == null || AttributeUtil.getBooleanValue((AttributeType)browsable) || AccessPointUtil.isOut((DirectionType)direction)) && fullClassName != null && (type = (finder = new TypeFinder((EObject)ref)).findType(fullClassName)) != null) {
                List methods = finder.getMethods(type);
                for (MethodInfo method : methods) {
                    if (methodName != null) {
                        String compactMethodName = StringUtils.replace((String)methodName, (String)", ", (String)",");
                        if (method.getEncoded().equals(compactMethodName)) {
                            method.setUsedForObjectCreation(usedForObjectCreation);
                            PlainJavaAccessPointProvider.addParameterAccessPoints(method, accessPoints, direction, dataType, paramsOnly);
                            if (paramsOnly) {
                                return accessPoints;
                            }
                        }
                    }
                    if (paramsOnly) continue;
                    PlainJavaAccessPointProvider.addMethodAccessPoint(method, accessPoints, direction, dataType);
                }
                if (hint == null && constructorName != null) {
                    String compactCtorName = StringUtils.replace((String)constructorName, (String)", ", (String)",");
                    List constructors = finder.getConstructors(type);
                    for (MethodInfo ctor : constructors) {
                        if (!ctor.getEncoded().equals(compactCtorName) || !ctor.isAccessible()) continue;
                        PlainJavaAccessPointProvider.addParameterAccessPoints(ctor, accessPoints, direction, dataType, paramsOnly);
                    }
                }
            }
        }
        return accessPoints;
    }

    public static void addParameterAccessPoints(MethodInfo method, List<AccessPointType> accessPoints, DirectionType direction, DataTypeType dataType, boolean paramsOnly) {
        String prefix;
        String string = prefix = method.isUsedForObjectCreation() ? "InitParam" : "Param";
        if (AccessPointUtil.isIn((DirectionType)direction)) {
            int i = 0;
            while (i < method.getParameterCount()) {
                String paramLabel = method.getParameterLabel(i);
                String paramName = method.getParameterName(i);
                String paramId = String.valueOf(paramName.toLowerCase().charAt(0)) + prefix + (i + 1);
                if (paramName.equals(paramLabel)) {
                    paramLabel = paramId;
                }
                AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)paramId, (String)(String.valueOf(paramLabel) + " : " + paramName), (String)method.getParameterType(i), (DirectionType)DirectionType.IN_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.PARAMETER.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
                accessPoints.add(accessPoint);
                ++i;
            }
        }
        if (!paramsOnly && method.hasReturn() && AccessPointUtil.isOut((DirectionType)direction)) {
            AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)"returnValue", (String)("returnValue : " + method.getReturnName()), (String)method.getReturnType(), (DirectionType)DirectionType.OUT_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.RETURN_VALUE.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
            accessPoints.add(accessPoint);
        }
    }

    public static void addMethodAccessPoint(MethodInfo method, List<AccessPointType> accessPoints, DirectionType direction, DataTypeType dataType) {
        if (method.getParameterCount() == 0) {
            if (method.hasReturn() && AccessPointUtil.isOut((DirectionType)direction) && method.isAccessible()) {
                AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)method.getEncoded(), (String)method.getLabel(), (String)method.getReturnType(), (DirectionType)DirectionType.OUT_LITERAL, (!method.isPrimitiveReturn() && !method.isArrayReturn() ? 1 : 0) != 0, (String[])new String[]{JavaAccessPointType.METHOD.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
                accessPoints.add(accessPoint);
            }
        } else if (method.getParameterCount() == 1 && AccessPointUtil.isIn((DirectionType)direction) && method.isAccessible()) {
            AccessPointType accessPoint = AccessPointUtil.createIntrinsicAccessPoint((String)method.getEncoded(), (String)method.getLabel(), (String)method.getParameterType(0), (DirectionType)DirectionType.IN_LITERAL, (boolean)false, (String[])new String[]{JavaAccessPointType.METHOD.getId(), JavaAccessPointType.class.getName()}, (DataTypeType)dataType);
            accessPoints.add(accessPoint);
        }
    }

    public static String[] splitAccessPath(String accessPath) {
        if (accessPath != null && accessPath.length() > 0) {
            int pCount = 0;
            int i = 0;
            while (i < accessPath.length()) {
                if (accessPath.charAt(i) == '.' && pCount == 0) {
                    return new String[]{accessPath.substring(0, i), accessPath.substring(i + 1)};
                }
                if (accessPath.charAt(i) == '(') {
                    ++pCount;
                }
                if (accessPath.charAt(i) == ')') {
                    --pCount;
                }
                ++i;
            }
        }
        String[] stringArray = new String[2];
        stringArray[0] = accessPath;
        return stringArray;
    }
}

