/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.conditionTypes.statechange;

import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IConditionPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.DefaultModelElementPropertyPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class StateChangePropertyPage
extends DefaultModelElementPropertyPage
implements IConditionPropertyPage {
    private static final String HALTED = "10";
    private static final String HIBERNATED = "7";
    private static final String ABORTED = "6";
    private static final String SUSPENDED = "5";
    private static final String INTERRUPTED = "4";
    private static final String COMPLETED = "2";
    private static final String APPLICATION = "1";
    private static final String CREATED = "0";
    private AttributeType sourceStateAttribute;
    private AttributeType targetStateAttribute;
    private Button naSourceStateButton;
    private Button applicationSourceStateButton;
    private Button suspendedSourceStateButton;
    private Button hibernatedSourceStateButton;
    private Button interruptedSourceStateButton;
    private Button createdSourceStateButton;
    private Button haltedSourceStateButton;
    private Button naTargetStateButton;
    private Button applicationTargetStateButton;
    private Button suspendedTargetStateButton;
    private Button hibernatedTargetStateButton;
    private Button interruptedTargetStateButton;
    private Button createdTargetStateButton;
    private Button completedTargetStateButton;
    private Button abortedTargetStateButton;
    private Button haltedTargetStateButton;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.init((EventHandlerType)element);
        this.setSourceStateValue();
        this.setTargetStateValue();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        EventHandlerType eventHandler = (EventHandlerType)element;
        if (this.naSourceStateButton != null) {
            this.setSourceStateAttribute(eventHandler);
            this.setTargetStateAttribute(eventHandler);
        }
    }

    private void init(EventHandlerType type) {
        this.sourceStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)type, (String)"carnot:engine:sourceState");
        this.targetStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)type, (String)"carnot:engine:targetState");
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1, (int)3);
        ((GridLayout)composite.getLayout()).horizontalSpacing = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        this.createSourceStateGroup(composite);
        this.createTargetStateGroup(composite);
        return composite;
    }

    private void createTargetStateGroup(Composite composite) {
        Group targetStateGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.GROUP_TargetState, (int)4);
        this.naTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)"N/A", (int)4);
        this.applicationTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_application);
        this.suspendedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_suspended);
        this.hibernatedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_hibernated);
        this.interruptedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_interrupted);
        this.createdTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_created);
        this.completedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_completed);
        this.abortedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_aborted);
        this.haltedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)Diagram_Messages.B_RADIO_halted);
    }

    private void createSourceStateGroup(Composite composite) {
        Group sourceStateGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.GROUP_SourceState, (int)4);
        this.naSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)"N/A", (int)4);
        this.applicationSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_application);
        this.suspendedSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_suspended);
        this.hibernatedSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_hibernated);
        this.interruptedSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_interrupted);
        this.createdSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_created);
        this.haltedSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)Diagram_Messages.B_RADIO_halted);
    }

    private void setTargetStateValue() {
        if (this.targetStateAttribute == null) {
            this.naTargetStateButton.setSelection(true);
        } else {
            switch (Integer.parseInt(this.targetStateAttribute.getValue())) {
                case 0: {
                    this.createdTargetStateButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.applicationTargetStateButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.completedTargetStateButton.setSelection(true);
                    break;
                }
                case 4: {
                    this.interruptedTargetStateButton.setSelection(true);
                    break;
                }
                case 5: {
                    this.suspendedTargetStateButton.setSelection(true);
                    break;
                }
                case 6: {
                    this.abortedTargetStateButton.setSelection(true);
                    break;
                }
                case 7: {
                    this.hibernatedTargetStateButton.setSelection(true);
                    break;
                }
                case 10: {
                    this.haltedTargetStateButton.setSelection(true);
                    break;
                }
                default: {
                    this.naTargetStateButton.setSelection(true);
                }
            }
        }
    }

    private void setSourceStateValue() {
        if (this.sourceStateAttribute == null) {
            this.naSourceStateButton.setSelection(true);
        } else {
            switch (Integer.parseInt(this.sourceStateAttribute.getValue())) {
                case 0: {
                    this.createdSourceStateButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.applicationSourceStateButton.setSelection(true);
                    break;
                }
                case 4: {
                    this.interruptedSourceStateButton.setSelection(true);
                    break;
                }
                case 5: {
                    this.suspendedSourceStateButton.setSelection(true);
                    break;
                }
                case 7: {
                    this.hibernatedSourceStateButton.setSelection(true);
                    break;
                }
                case 10: {
                    this.haltedSourceStateButton.setSelection(true);
                    break;
                }
                default: {
                    this.naSourceStateButton.setSelection(true);
                }
            }
        }
    }

    private void setTargetStateAttribute(EventHandlerType eventHandler) {
        if (this.targetStateAttribute == null && !this.naTargetStateButton.getSelection()) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:targetState", (String)"ag.carnot.workflow.runtime.ActivityInstanceState", (String)CREATED);
            this.targetStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:targetState");
        }
        if (this.createdTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(CREATED);
        } else if (this.applicationTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(APPLICATION);
        } else if (this.completedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(COMPLETED);
        } else if (this.interruptedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(INTERRUPTED);
        } else if (this.suspendedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(SUSPENDED);
        } else if (this.abortedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(ABORTED);
        } else if (this.hibernatedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(HIBERNATED);
        } else if (this.haltedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(HALTED);
        } else if (this.naTargetStateButton.getSelection() && this.targetStateAttribute != null) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:targetState", (String)"");
        }
    }

    private void setSourceStateAttribute(EventHandlerType eventHandler) {
        if (this.sourceStateAttribute == null && !this.naSourceStateButton.getSelection()) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:sourceState", (String)"ag.carnot.workflow.runtime.ActivityInstanceState", (String)CREATED);
            this.sourceStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:sourceState");
        }
        if (this.createdSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(CREATED);
        } else if (this.applicationSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(APPLICATION);
        } else if (this.interruptedSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(INTERRUPTED);
        } else if (this.suspendedSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(SUSPENDED);
        } else if (this.hibernatedSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(HIBERNATED);
        } else if (this.haltedSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(HALTED);
        } else if (this.naSourceStateButton.getSelection() && this.sourceStateAttribute != null) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:sourceState", (String)"");
        }
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
    }
}

