/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML;

import java.util.List;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML.PlainXMLAccessPointType;
import org.eclipse.stardust.modeling.core.spi.dataTypes.plainXML.PlainXMLUtils;

public class PlainXMLAccessPathEditor
implements IAccessPathEditor {
    public static final String SEPARATOR = "/";

    public List getAccessPoints(String hint, IExtensibleElement dataObject, DirectionType direction) {
        List accessPoints = CollectionUtils.newList();
        if (dataObject instanceof DataType) {
            IXPathMap xPathMap = PlainXMLUtils.getXPathMap((DataType)dataObject);
            if (xPathMap != null) {
                this.addAccessPoints(accessPoints, (IModelElement)dataObject, xPathMap.getRootXPath(), xPathMap, direction);
            }
        } else if (dataObject instanceof PlainXMLAccessPointType) {
            PlainXMLAccessPointType ap = (PlainXMLAccessPointType)dataObject;
            this.addAccessPoints(accessPoints, (IModelElement)ap.getType(), ap.getXPath(), ap.getXPathMap(), direction);
        }
        return accessPoints;
    }

    private void addAccessPoints(List accessPoints, IModelElement modelElement, TypedXPath xPath, IXPathMap xPathMap, DirectionType direction) {
        List childXPaths = xPath.getChildXPaths();
        int i = 0;
        while (i < childXPaths.size()) {
            TypedXPath childXPath = (TypedXPath)childXPaths.get(i);
            accessPoints.add(this.createElementAccessPoint(childXPath, xPathMap, modelElement, direction));
            ++i;
        }
    }

    private AccessPointType createElementAccessPoint(TypedXPath xPath, IXPathMap xPathMap, IModelElement modelElement, DirectionType direction) {
        DataTypeType dataType = null;
        dataType = xPath.getType() == -1 ? ModelUtils.getDataType((IModelElement)modelElement, (String)"struct") : ModelUtils.getDataType((IModelElement)modelElement, (String)"primitive");
        PlainXMLAccessPointType accessPoint = new PlainXMLAccessPointType(xPath, xPathMap);
        String name = StructuredDataXPathUtils.getLastXPathPart((String)xPath.getXPath());
        accessPoint.setId(name);
        accessPoint.setName(name);
        accessPoint.setType(dataType);
        accessPoint.setDirection(direction);
        AttributeUtil.setAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:path:separator", (String)SEPARATOR);
        AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:browsable", (Boolean)true);
        if (xPath.isList()) {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:data:indexed", (Boolean)true);
        }
        AttributeUtil.setBooleanAttribute((IExtensibleElement)accessPoint, (String)"carnot:engine:data:bidirectional", (Boolean)true);
        return accessPoint;
    }

    public String[] splitAccessPath(String accessPath) {
        String[] stringArray;
        int ix = accessPath.indexOf(SEPARATOR);
        if (ix < 0) {
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            stringArray2[0] = accessPath;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = accessPath.substring(0, ix);
            stringArray = stringArray3;
            stringArray3[1] = accessPath.substring(ix + SEPARATOR.length());
        }
        return stringArray;
    }

    public boolean supportsBrowsing() {
        return false;
    }
}

