/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.properties.ModelElementsTableContentProvider;
import org.eclipse.stardust.modeling.core.spi.triggerTypes.ParameterMappingPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ParameterMappingTablePage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String PARAMETER_MAPPING_TABLE_ID = "_cwm_parameter_mapping_table_";
    private static final String[] labelProperties = new String[]{"data", "parameter"};
    private static final int[] elementFeatureIds = new int[]{1, 3};
    private Button[] buttons;
    private Object selection;
    private TableViewer viewer;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;
    private EObjectLabelProvider labelProvider;

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    @Override
    public void dispose() {
        this.outlineSynchronizer.dispose();
        super.dispose();
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.viewer.setInput((Object)element);
        this.outlineSynchronizer.init((EObject)element);
        this.updateButtons(null, this.buttons);
        this.expandTree();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        Table table = new Table(composite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterMappingTablePage.this.updateButtons(ParameterMappingTablePage.this.getSelectedItem(), ParameterMappingTablePage.this.buttons);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = ParameterMappingTablePage.this.getSelectedItem();
                if (selection instanceof ParameterMappingType) {
                    ParameterMappingTablePage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TableViewer(table);
        TableUtil.createColumns(table, new String[]{Diagram_Messages.LB_Data, Diagram_Messages.LB_Parameter});
        TableUtil.setInitialColumnSizes(table, new int[]{50, 50});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(Object element) {
                if (element instanceof ParameterMappingType) {
                    return this.getText("data", element);
                }
                return super.getText(element);
            }

            @Override
            public String getText(String name, Object element) {
                if (name.equals("data") && element instanceof ParameterMappingType) {
                    DataType data = ((ParameterMappingType)element).getData();
                    return data != null ? this.getText(data) : Diagram_Messages.TXT_undefined;
                }
                if (name.equals("parameter") && element instanceof ParameterMappingType) {
                    String param = ((ParameterMappingType)element).getParameter();
                    if (param == null || param.length() == 0) {
                        return Diagram_Messages.TXT_undefined;
                    }
                    TriggerType trigger = (TriggerType)((ParameterMappingType)element).eContainer();
                    AccessPointType ap = (AccessPointType)ModelUtils.findIdentifiableElement((List)trigger.getAccessPoint(), (String)param);
                    return ap != null ? this.getText(ap) : param;
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)this.labelProvider, labelProperties);
        this.viewer.setContentProvider((IContentProvider)new ModelElementsTableContentProvider((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTriggerType_ParameterMapping(), elementFeatureIds, labelProperties));
        DefaultOutlineProvider op = new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTriggerType_ParameterMapping(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIModelElement_ElementOid(), null, PARAMETER_MAPPING_TABLE_ID, this.getParameterMappingPageClass()){

            @Override
            public String getName(IModelElement element) {
                return ParameterMappingTablePage.this.labelProvider.getText(element);
            }

            @Override
            public void addNodeTo(String parentNodeId, CarnotPreferenceNode node) {
                ParameterMappingTablePage.this.addNodeTo(parentNodeId, node, new EObjectLabelProvider(this.getEditor()){

                    @Override
                    public String getText(String name, Object element) {
                        return ParameterMappingTablePage.this.labelProvider.getText(element);
                    }
                });
            }
        };
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(op);
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        return composite;
    }

    protected Class<? extends ParameterMappingPage> getParameterMappingPageClass() {
        return ParameterMappingPage.class;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        buttons[0].setEnabled(true);
        buttons[1].setEnabled(selection instanceof ParameterMappingType);
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterMappingTablePage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterMappingTablePage.this.performDelete(buttons);
            }
        })};
        return buttons;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    protected void performAdd(Button[] buttons) {
        ParameterMappingType parameterMappingType = CarnotWorkflowModelFactory.eINSTANCE.createParameterMappingType();
        TriggerType trigger = (TriggerType)this.getModelElement();
        trigger.getParameterMapping().add((Object)parameterMappingType);
        this.selectPageForObject(parameterMappingType);
    }

    protected void performDelete(Button[] buttons) {
        ParameterMappingType parameterMappingType = (ParameterMappingType)this.getSelection();
        TriggerType trigger = (TriggerType)this.getModelElement();
        trigger.getParameterMapping().remove((Object)parameterMappingType);
        this.updateButtons(null, buttons);
        this.selectPage(PARAMETER_MAPPING_TABLE_ID);
    }
}

