/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.jms.app.DefaultMessageAcceptor;
import org.eclipse.stardust.engine.extensions.jms.app.JMSLocation;
import org.eclipse.stardust.engine.extensions.jms.app.MessageType;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IMessageAcceptor;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.properties.ModelElementsTableContentProvider;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.triggerTypes.ParameterMappingTablePage;
import org.eclipse.stardust.modeling.core.spi.triggerTypes.jms.JMSTriggerAccessPointPropertyPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class JmsPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String PARAMETER_MAPPING_TABLE_ID = "_cwm_parameter_mapping_table_";
    private static final String PARAMETER_MAPPING_TABLE_LABEL = Diagram_Messages.PARAMETER_MAPPING_TABLE_LABEL;
    private static final String MESSAGE_ACCEPTOR = "carnot:engine:messageAcceptor";
    private static final String MESSAGE_TYPE_NAME_ATT = "carnot:engine:messageType";
    private static final String MESSAGE_TYPE_ATT = MessageType.class.getName();
    private static final String[] types = new String[]{MessageType.MAP.getId(), MessageType.OBJECT.getId(), MessageType.TEXT.getId(), MessageType.STREAM.getId()};
    private static final String[] classNames;
    private static final int[] elementFeatureIds;
    private static final String[] labelProperties;
    private static final String JMS_LOCATION_ATT = "carnot:engine:jms.location";
    private Button[] buttons;
    private Object selection;
    private EObjectLabelProvider labelProvider;
    private TableViewer viewer;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;
    private ComboViewer messageTypeCombo;
    private ComboViewer acceptorCombo;

    static {
        String[] stringArray = new String[4];
        stringArray[1] = Object.class.getName();
        stringArray[2] = String.class.getName();
        classNames = stringArray;
        elementFeatureIds = new int[]{1, 2, 5, 6};
        labelProperties = new String[]{"name", "value"};
    }

    @Override
    public void dispose() {
        this.outlineSynchronizer.dispose();
        super.dispose();
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        Collection acceptors = this.getAcceptors();
        this.acceptorCombo.setInput((Object)acceptors);
        String acceptorClass = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MESSAGE_ACCEPTOR);
        IMessageAcceptor acceptor = this.findAcceptor(acceptors, acceptorClass);
        this.acceptorCombo.setSelection((ISelection)(acceptor == null ? null : new StructuredSelection((Object)acceptor)));
        String messageType = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)MESSAGE_TYPE_NAME_ATT);
        this.messageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)(messageType == null ? types[0] : messageType)));
        this.resetContent();
    }

    private IMessageAcceptor findAcceptor(Collection acceptors, String acceptorClass) {
        for (IMessageAcceptor msgAcceptor : acceptors) {
            if (!msgAcceptor.getRuntimeClassName().equals(acceptorClass)) continue;
            return msgAcceptor;
        }
        return acceptorClass == null && acceptors.size() == 1 ? acceptors.iterator().next() : null;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    private IMessageAcceptor getSelectedAcceptor() {
        IStructuredSelection selection = (IStructuredSelection)this.acceptorCombo.getSelection();
        IMessageAcceptor acceptor = null;
        if (selection != null && !selection.isEmpty()) {
            acceptor = (IMessageAcceptor)selection.getFirstElement();
        }
        return acceptor;
    }

    private String getSelectedMessageType() {
        IStructuredSelection selection = (IStructuredSelection)this.messageTypeCombo.getSelection();
        String messageType = null;
        if (selection != null && !selection.isEmpty()) {
            messageType = (String)selection.getFirstElement();
        }
        return messageType;
    }

    private Collection getAcceptors() {
        TreeMap<String, IMessageAcceptor> acceptors = new TreeMap<String, IMessageAcceptor>();
        Map extensions = SpiExtensionRegistry.instance().getExtensions("triggerMessageAcceptors");
        for (IConfigurationElement config : extensions.values()) {
            try {
                IMessageAcceptor acceptor = (IMessageAcceptor)config.createExecutableExtension("acceptorClass");
                acceptors.put(acceptor.getName(), acceptor);
            }
            catch (CoreException coreException) {}
        }
        IMessageAcceptor defaultAcceptor = new IMessageAcceptor(){

            public String getName() {
                return Diagram_Messages.NAME_ACCEPTOR_Default;
            }

            public Collection getMessageTypes() {
                return Arrays.asList(types);
            }

            public String getRuntimeClassName() {
                return DefaultMessageAcceptor.class.getName();
            }

            public Collection getPredefinedAccessPoints(String messageType) {
                int i = 1;
                while (i < 3) {
                    if (types[i].equals(messageType)) {
                        return Collections.singletonList(JmsPropertyPage.this.getAccessPoint(classNames[i]));
                    }
                    ++i;
                }
                return Collections.EMPTY_LIST;
            }
        };
        acceptors.put(defaultAcceptor.getName(), defaultAcceptor);
        return acceptors.values();
    }

    private Object getAccessPoint(String classname) {
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)"content", (String)Diagram_Messages.NAME_ACCESSPOINT_Content, (String)classname, (DirectionType)DirectionType.OUT_LITERAL, (boolean)true, null, (DataTypeType)ModelUtils.getDataType((IModelElement)this.getTrigger(), (String)"serializable"));
        AttributeUtil.setAttribute((IExtensibleElement)ap, (String)JMS_LOCATION_ATT, (String)JMSLocation.class.getName(), (String)JMSLocation.BODY.getId());
        return ap;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_MessageAcceptor);
        this.acceptorCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.acceptorCombo.setSorter(new ViewerSorter());
        this.acceptorCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.acceptorCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IMessageAcceptor)element).getName();
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_MessageType);
        this.messageTypeCombo = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.messageTypeCombo.setSorter(new ViewerSorter());
        this.messageTypeCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.acceptorCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JmsPropertyPage.this.acceptorChanged();
            }
        });
        this.messageTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JmsPropertyPage.this.messageTypeChanged();
            }
        });
        Table table = new Table(composite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData((int)2));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.updateButtons(JmsPropertyPage.this.getSelectedItem(), JmsPropertyPage.this.buttons);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = JmsPropertyPage.this.getSelectedItem();
                if (selection instanceof AccessPointType) {
                    JmsPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TableViewer(table);
        TableUtil.createColumns(table, new String[]{Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_Location});
        TableUtil.setInitialColumnSizes(table, new int[]{70, 29});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(String name, Object element) {
                if (name.equals("value") && element instanceof AccessPointType) {
                    return AttributeUtil.getAttributeValue((IExtensibleElement)((AccessPointType)element), (String)JmsPropertyPage.JMS_LOCATION_ATT);
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)this.labelProvider, labelProperties);
        ModelElementsTableContentProvider provider = new ModelElementsTableContentProvider((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIAccessPointOwner_AccessPoint(), elementFeatureIds, labelProperties);
        provider.setLabelChangingAttributes(new String[]{JMS_LOCATION_ATT});
        this.viewer.setContentProvider((IContentProvider)provider);
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIAccessPointOwner_AccessPoint(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name(), this.getParentNodeId(), JMSTriggerAccessPointPropertyPage.class.getName()){

            protected List retrievePagesFor(ModelElementAdaptable adaptable) {
                IModelElement accessPoint = (IModelElement)adaptable.getAdapter(IModelElement.class);
                if (accessPoint instanceof AccessPointType) {
                    CarnotPreferenceNode node = new CarnotPreferenceNode(this.createPageConfiguration(accessPoint), adaptable, "propertyPageClass", 0);
                    return Collections.singletonList(node);
                }
                return super.retrievePagesFor(adaptable);
            }
        });
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        this.addParameterMappingTablePage();
        return composite;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        buttons[0].setEnabled(true);
        buttons[1].setEnabled(selection instanceof AccessPointType);
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.performDelete(buttons);
            }
        })};
        return buttons;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    private void performDelete(Button[] buttons) {
        AccessPointType ap = (AccessPointType)this.getSelection();
        if (ap != null) {
            TriggerType triggerType = this.getTrigger();
            triggerType.getAccessPoint().remove((Object)ap);
            this.updateButtons(null, buttons);
            this.selectPage(this.getParentNodeId());
        }
    }

    private void performAdd(Button[] buttons) {
        TriggerType triggerType = this.getTrigger();
        IMessageAcceptor acceptor = this.getSelectedAcceptor();
        String messageType = this.getSelectedMessageType();
        acceptor.getPredefinedAccessPoints(messageType);
        EList points = triggerType.getAccessPoint();
        IdFactory factory = new IdFactory("out", Diagram_Messages.BASENAME_OutAccessPoint);
        factory.computeNames((List)points);
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)factory.getId(), (String)factory.getName(), null, (DirectionType)DirectionType.OUT_LITERAL, (boolean)true, null, (DataTypeType)ModelUtils.getDataType((IModelElement)this.getTrigger(), (String)"serializable"));
        triggerType.getAccessPoint().add((Object)ap);
        this.selectPageForObject(ap);
    }

    private void addParameterMappingTablePage() {
        CarnotPreferenceNode node = new CarnotPreferenceNode(ConfigurationElement.createPageConfiguration(PARAMETER_MAPPING_TABLE_ID, PARAMETER_MAPPING_TABLE_LABEL, null, ParameterMappingTablePage.class.getName()), this.getElement(), -2);
        this.addNodeTo(null, node, null);
        this.refreshTree();
    }

    private void acceptorChanged() {
        IMessageAcceptor acceptor;
        TriggerType trigger = this.getTrigger();
        String currentMessageType = this.getSelectedMessageType();
        if (StringUtils.isEmpty((String)currentMessageType)) {
            currentMessageType = AttributeUtil.getAttributeValue((IExtensibleElement)trigger, (String)MESSAGE_TYPE_NAME_ATT);
        }
        AttributeUtil.setAttribute((IExtensibleElement)trigger, (String)MESSAGE_ACCEPTOR, (String)((acceptor = this.getSelectedAcceptor()) == null ? null : acceptor.getRuntimeClassName()));
        IMessageAcceptor provider = this.getSelectedAcceptor();
        if (provider != null) {
            Collection messageTypes = provider.getMessageTypes();
            this.messageTypeCombo.setInput((Object)messageTypes);
            if (!messageTypes.isEmpty()) {
                this.messageTypeCombo.setSelection((ISelection)new StructuredSelection((Object)(messageTypes.contains(currentMessageType) ? currentMessageType : messageTypes.iterator().next())));
            }
        } else {
            this.messageTypeCombo.setInput(null);
        }
        this.messageTypeChanged();
    }

    private void messageTypeChanged() {
        String currentMessageType;
        TriggerType trigger = this.getTrigger();
        String configuredMessageType = AttributeUtil.getAttributeValue((IExtensibleElement)trigger, (String)MESSAGE_TYPE_NAME_ATT);
        if (!CompareHelper.areEqual((Object)configuredMessageType, (Object)(currentMessageType = this.getSelectedMessageType()))) {
            AttributeUtil.setAttribute((IExtensibleElement)trigger, (String)MESSAGE_TYPE_NAME_ATT, (String)MESSAGE_TYPE_ATT, (String)currentMessageType);
            EList aps = trigger.getAccessPoint();
            int i = aps.size() - 1;
            while (i >= 0) {
                AccessPointType ap = (AccessPointType)aps.get(i);
                String locationValue = AttributeUtil.getAttributeValue((IExtensibleElement)ap, (String)JMS_LOCATION_ATT);
                if (JMSLocation.BODY.getId().equals(locationValue)) {
                    aps.remove(ap);
                }
                --i;
            }
            IMessageAcceptor acceptor = this.getSelectedAcceptor();
            if (acceptor != null) {
                String messageType = this.getSelectedMessageType();
                aps.addAll(acceptor.getPredefinedAccessPoints(messageType));
            }
            this.resetContent();
        }
    }

    private TriggerType getTrigger() {
        Object element = this.getElement();
        if (element instanceof EditPart) {
            element = ((EditPart)element).getModel();
        }
        if (element instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        return element instanceof TriggerType ? (TriggerType)element : null;
    }

    private void resetContent() {
        TriggerType element = this.getTrigger();
        this.viewer.setInput((Object)element);
        this.outlineSynchronizer.init((EObject)element);
        this.updateButtons(null, this.buttons);
        this.expandTree();
    }

    private String getParentNodeId() {
        return this.getTrigger().getType().getId();
    }
}

