/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.mail;

import java.util.HashMap;
import org.eclipse.gef.EditPart;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.triggerTypes.ParameterMappingTablePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class MailPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String REMOVE = Diagram_Messages.REMOVE;
    private static final String SEEN = Diagram_Messages.SEEN;
    private static final String LEAVE = Diagram_Messages.LEAVE;
    private static final String NEW_MAILS = Diagram_Messages.NEW_MAILS;
    private static final String NOT_SEEN = Diagram_Messages.NOT_SEEN;
    private static final String EXISTING = Diagram_Messages.EXISTING;
    private static final String IMAP = "IMAP4";
    private static final String POP = "POP3";
    private static final String HOST = "carnot:engine:host";
    private static final String MAIL_TRIGGER_PROVIDER = "ag.carnot.workflow.spi.providers.triggers.mail.";
    private static final String FLAGS = "carnot:engine:mailFlags";
    private static final String FLAGS_TYPE = "ag.carnot.workflow.spi.providers.triggers.mail.MailTriggerMailFlags";
    private static final String SENDER_PREDICATE = "carnot:engine:mailSenderPredicate";
    private static final String SUBJECT_PREDICATE = "carnot:engine:mailSubjectPredicate";
    private static final String SELECTOR_PREDICATE = "carnot:engine:selectorPredicate";
    private static final String MAILBOX_ACTION = "carnot:engine:mailboxAction";
    private static final String MAILBOX_ACTION_TYPE = "ag.carnot.workflow.spi.providers.triggers.mail.MailTriggerMailboxAction";
    private static final String PASSWORD = "carnot:engine:password";
    private static final String PROTOCOL = "carnot:engine:protocol";
    private static final String PROTOCOL_TYPE = "ag.carnot.workflow.spi.providers.triggers.mail.MailProtocol";
    private static final String MAIL_CLASS_ATT = "ag.carnot.workflow.runtime.Mail";
    private static final String USER = "carnot:engine:user";
    public static final String PARAMETER_MAPPING_TABLE_ID = "_cwm_parameter_mapping_table_";
    private static final String PARAMETER_MAPPING_TABLE_LABEL = Diagram_Messages.PARAMETER_MAPPING_TABLE_LABEL;
    private Combo protocolCombo;
    private Text hostText;
    private Text usrText;
    private Text passwdText;
    private Combo flagsCombo;
    private Text senderPredicateText;
    private Text subjectPredicateText;
    private Text selectorPredicateText;
    private Combo mailboxActionCombo;
    private IExtensibleElement extensibleElement;
    private HashMap comboValueMap;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.extensibleElement = (IExtensibleElement)element;
        this.getAttributeValue(PROTOCOL, (Control)this.protocolCombo);
        this.getAttributeValue(HOST, (Control)this.hostText);
        this.getAttributeValue(USER, (Control)this.usrText);
        this.getAttributeValue(PASSWORD, (Control)this.passwdText);
        this.getAttributeValue(FLAGS, (Control)this.flagsCombo);
        this.getAttributeValue(SENDER_PREDICATE, (Control)this.senderPredicateText);
        this.getAttributeValue(SUBJECT_PREDICATE, (Control)this.subjectPredicateText);
        this.getAttributeValue(SELECTOR_PREDICATE, (Control)this.selectorPredicateText);
        this.getAttributeValue(MAILBOX_ACTION, (Control)this.mailboxActionCombo);
        ((TriggerType)element).getAccessPoint().clear();
        ((TriggerType)element).getAccessPoint().add((Object)this.createMailAccessPoint());
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.extensibleElement = (IExtensibleElement)element;
        if (this.extensibleElement != null) {
            this.extensibleElement.getAttribute().clear();
            this.setAttributeValue(PROTOCOL, PROTOCOL_TYPE, (Control)this.protocolCombo);
            this.setAttributeValue(HOST, null, (Control)this.hostText);
            this.setAttributeValue(USER, null, (Control)this.usrText);
            this.setAttributeValue(PASSWORD, null, (Control)this.passwdText);
            this.setAttributeValue(FLAGS, FLAGS_TYPE, (Control)this.flagsCombo);
            this.setAttributeValue(SENDER_PREDICATE, null, (Control)this.senderPredicateText);
            this.setAttributeValue(SUBJECT_PREDICATE, null, (Control)this.subjectPredicateText);
            this.setAttributeValue(SELECTOR_PREDICATE, null, (Control)this.selectorPredicateText);
            this.setAttributeValue(MAILBOX_ACTION, MAILBOX_ACTION_TYPE, (Control)this.mailboxActionCombo);
        }
    }

    private void setAttributeValue(String attrName, String attrType, Control control) {
        if (control instanceof Text) {
            AttributeUtil.setAttribute((IExtensibleElement)this.extensibleElement, (String)attrName, (String)((Text)control).getText());
        } else if (control instanceof Combo) {
            AttributeUtil.setAttribute((IExtensibleElement)this.extensibleElement, (String)attrName, (String)attrType, (String)((String)this.comboValueMap.get(((Combo)control).getText())));
        }
    }

    private void getAttributeValue(String attrName, Control control) {
        String value = AttributeUtil.getAttributeValue((IExtensibleElement)this.extensibleElement, (String)attrName);
        if (value != null) {
            if (control instanceof Text) {
                ((Text)control).setText(value);
            } else if (control instanceof Combo) {
                ((Combo)control).setText((String)this.comboValueMap.get(value));
            }
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Group serverSettingsGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.GROUP_ServerSettings, (int)2);
        FormBuilder.createLabel((Composite)serverSettingsGroup, (String)Diagram_Messages.LB_Protocol);
        this.protocolCombo = FormBuilder.createCombo((Composite)serverSettingsGroup);
        this.protocolCombo.add(POP);
        this.protocolCombo.add(IMAP);
        this.protocolCombo.setText(POP);
        FormBuilder.createLabel((Composite)serverSettingsGroup, (String)Diagram_Messages.LB_Server);
        this.hostText = FormBuilder.createText((Composite)serverSettingsGroup);
        FormBuilder.createLabel((Composite)serverSettingsGroup, (String)Diagram_Messages.LB_Name);
        this.usrText = FormBuilder.createText((Composite)serverSettingsGroup);
        FormBuilder.createLabel((Composite)serverSettingsGroup, (String)Diagram_Messages.LB_Password);
        this.passwdText = new Text((Composite)serverSettingsGroup, 0x400800);
        GridData passwdTextGridData = new GridData(4);
        passwdTextGridData.grabExcessHorizontalSpace = true;
        passwdTextGridData.horizontalAlignment = 4;
        passwdTextGridData.widthHint = FormBuilder.getDefaultTextSize((Control)composite);
        this.passwdText.setLayoutData((Object)passwdTextGridData);
        Group mailSettingsGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.GROUP_MailSettings, (int)2);
        FormBuilder.createLabel((Composite)mailSettingsGroup, (String)Diagram_Messages.LB_CandidateMails);
        this.flagsCombo = FormBuilder.createCombo((Composite)mailSettingsGroup);
        this.flagsCombo.add(EXISTING);
        this.flagsCombo.add(NOT_SEEN);
        this.flagsCombo.add(NEW_MAILS);
        this.flagsCombo.setText(EXISTING);
        this.flagsCombo.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        FormBuilder.createLabel((Composite)mailSettingsGroup, (String)Diagram_Messages.LB_SenderPredicates);
        this.senderPredicateText = FormBuilder.createText((Composite)mailSettingsGroup);
        FormBuilder.createLabel((Composite)mailSettingsGroup, (String)Diagram_Messages.LB_SubjectPredicate);
        this.subjectPredicateText = FormBuilder.createText((Composite)mailSettingsGroup);
        FormBuilder.createLabel((Composite)mailSettingsGroup, (String)Diagram_Messages.LB_BodyPredicate);
        this.selectorPredicateText = FormBuilder.createText((Composite)mailSettingsGroup);
        FormBuilder.createLabel((Composite)mailSettingsGroup, (String)Diagram_Messages.LB_MailboxAction);
        this.mailboxActionCombo = FormBuilder.createCombo((Composite)mailSettingsGroup);
        this.mailboxActionCombo.add(LEAVE);
        this.mailboxActionCombo.add(SEEN);
        this.mailboxActionCombo.add(REMOVE);
        this.mailboxActionCombo.setText(LEAVE);
        this.initComboValueMap();
        this.addParameterMappingTablePage();
        return composite;
    }

    private void initComboValueMap() {
        this.comboValueMap = new HashMap();
        this.comboValueMap.put("pop3", POP);
        this.comboValueMap.put("imap", IMAP);
        this.comboValueMap.put("recent", NEW_MAILS);
        this.comboValueMap.put("notSeen", NOT_SEEN);
        this.comboValueMap.put("any", EXISTING);
        this.comboValueMap.put("remove", REMOVE);
        this.comboValueMap.put("read", SEEN);
        this.comboValueMap.put("leave", LEAVE);
        this.comboValueMap.put(POP, "pop3");
        this.comboValueMap.put(IMAP, "imap");
        this.comboValueMap.put(NEW_MAILS, "recent");
        this.comboValueMap.put(NOT_SEEN, "notSeen");
        this.comboValueMap.put(EXISTING, "any");
        this.comboValueMap.put(REMOVE, "remove");
        this.comboValueMap.put(SEEN, "read");
        this.comboValueMap.put(LEAVE, "leave");
    }

    private void addParameterMappingTablePage() {
        CarnotPreferenceNode node = new CarnotPreferenceNode(ConfigurationElement.createPageConfiguration(PARAMETER_MAPPING_TABLE_ID, PARAMETER_MAPPING_TABLE_LABEL, null, ParameterMappingTablePage.class.getName()), new ModelElementAdaptable(IModelElement.class, this.getTrigger(), EditPart.class, this.getElement()), -2);
        this.addNodeTo(null, node, null);
        this.refreshTree();
    }

    private TriggerType getTrigger() {
        Object element = this.getElement();
        if (element instanceof EditPart) {
            element = ((EditPart)element).getModel();
        }
        if (element instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        return element instanceof TriggerType ? (TriggerType)element : null;
    }

    private AccessPointType createMailAccessPoint() {
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)"mail", (String)"mail", (String)MAIL_CLASS_ATT, (DirectionType)DirectionType.OUT_LITERAL, (boolean)true, null, (DataTypeType)ModelUtils.getDataType((IModelElement)this.getTrigger(), (String)"serializable"));
        return ap;
    }
}

