/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.triggerTypes.scan;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.properties.LaneParticipantCommandFactory;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.SpiPropertyPage;
import org.eclipse.stardust.modeling.core.utils.IdentifiableViewerSorter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ParticipantPropertyPage
extends AbstractModelElementPropertyPage {
    private LabeledViewer labeledWidget;
    private WidgetBindingManager wBndMgr = null;
    private IModelParticipant originalPerformer = null;
    private TriggerType trigger = null;
    private SpiPropertyPage spiPage;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.trigger = (TriggerType)element;
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        TableViewer viewer = (TableViewer)this.labeledWidget.getViewer();
        viewer.getTable().removeAll();
        ArrayList participants = new ArrayList();
        participants.addAll(model.getRole());
        participants.addAll(model.getOrganization());
        viewer.add(participants.toArray());
        this.wBndMgr = this.getWidgetBindingManager();
        this.wBndMgr.bind(this.labeledWidget, (IExtensibleElement)element, "carnot:engine:participant", participants);
        this.wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        TriggerType trigger = (TriggerType)element;
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)trigger, (String)"carnot:engine:participant");
        if (attribute != null) {
            this.originalPerformer = (IModelParticipant)AttributeUtil.getReferenceElement((AttributeType)attribute);
        }
        this.validate(this.originalPerformer);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        CompoundCommand command = new CompoundCommand();
        IModelParticipant newPerformer = null;
        TriggerType trigger = (TriggerType)element;
        AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)trigger, (String)"carnot:engine:participant");
        if (attribute != null) {
            newPerformer = (IModelParticipant)AttributeUtil.getReferenceElement((AttributeType)attribute);
        }
        LaneParticipantCommandFactory.addSetPerformerCommands(command, trigger, newPerformer, this.originalPerformer, attribute, true, null);
        command.execute();
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_Participants);
        Table table = new Table(composite, 2048);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        tableViewer.setSorter((ViewerSorter)new IdentifiableViewerSorter());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IModelParticipant participant = (IModelParticipant)((IStructuredSelection)event.getSelection()).getFirstElement();
                    ParticipantPropertyPage.this.validate(participant);
                }
            }
        });
        this.labeledWidget = new LabeledViewer((StructuredViewer)tableViewer, label);
        return composite;
    }

    public boolean performCancel() {
        AttributeUtil.setReference((IExtensibleElement)this.trigger, (String)"carnot:engine:participant", (EObject)this.originalPerformer);
        return super.performCancel();
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
        this.spiPage = (SpiPropertyPage)page;
    }

    private void validate(IModelParticipant performer) {
        if (performer != null) {
            this.setParticipantValidationState(IQuickValidationStatus.OK);
            ModelType model = ModelUtils.findContainingModel((EObject)performer);
            HashSet scoped = ScopeUtils.findScopedParticipants((ModelType)model);
            if (scoped.contains(performer)) {
                ScopeUtils.isValidScopedParticipantForManualTrigger((IModelParticipant)performer);
            }
        } else {
            this.setParticipantValidationState(IQuickValidationStatus.ERRORS);
        }
    }

    private void setParticipantValidationState(IQuickValidationStatus state) {
        CarnotPreferenceNode preferenceNode = (CarnotPreferenceNode)this.getPreferenceManager().find("org~eclipse~stardust~modeling~core~spi~triggerTypes~scan~ParticipantPropertyPage");
        preferenceNode.updatePageStatus(state);
        TreeViewer parentTreeViewer = (TreeViewer)Reflect.getFieldValue((Object)this.getContainer(), (String)"treeViewer");
        parentTreeViewer.refresh(true);
        this.labeledWidget.getLabel().setValidationStatus(state);
        if (state == IQuickValidationStatus.ERRORS) {
            this.labeledWidget.getLabel().setToolTipText(Validation_Messages.MSG_Scantrigger_UnspecifiedParticipant);
        } else {
            this.labeledWidget.getLabel().setToolTipText(null);
        }
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.UncheckButton, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IModelElement modelElement = (IModelElement)ParticipantPropertyPage.this.getModelElement();
                if (modelElement instanceof TriggerType) {
                    AttributeUtil.setReference((IExtensibleElement)ParticipantPropertyPage.this.trigger, (String)"carnot:engine:participant", null);
                    ParticipantPropertyPage.this.wBndMgr.getModelBindingManager().updateWidgets((Object)ParticipantPropertyPage.this.trigger);
                }
            }
        });
    }
}

