/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;

public class AccessPathBrowserContentProvider
implements ITreeContentProvider {
    private DirectionType direction;
    private Map childrenCache = new HashMap();
    private Map parentCache = new HashMap();
    private Object root;

    public AccessPathBrowserContentProvider(DirectionType direction) {
        this.direction = direction;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = (Object[])this.childrenCache.get(parentElement);
        if (children == null) {
            children = new Object[]{};
            ITypedElement accessPoint = (ITypedElement)parentElement;
            IMetaType type = accessPoint.getMetaType();
            if (type instanceof DataTypeType) {
                DataTypeType dataType = (DataTypeType)accessPoint.getMetaType();
                IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
                List aps = editor.getAccessPoints(null, (IExtensibleElement)accessPoint, this.direction);
                if (AccessPointUtil.isIn((DirectionType)this.direction)) {
                    List inAPs = editor.getAccessPoints(null, (IExtensibleElement)accessPoint, DirectionType.OUT_LITERAL);
                    int i = 0;
                    while (i < inAPs.size()) {
                        IExtensibleElement element = (IExtensibleElement)inAPs.get(i);
                        if (AttributeUtil.getBooleanValue((IExtensibleElement)element, (String)"carnot:engine:browsable") && !aps.contains(element)) {
                            aps.add(element);
                        }
                        ++i;
                    }
                }
                if (aps != null) {
                    children = aps.toArray();
                }
            }
            this.childrenCache.put(parentElement, children);
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                this.parentCache.put(child, parentElement);
                ++i;
            }
        }
        return children;
    }

    public Object getParent(Object element) {
        return this.parentCache.get(element);
    }

    public boolean hasChildren(Object element) {
        if (!(element instanceof AccessPointType)) {
            return false;
        }
        if (DirectionType.IN_LITERAL.equals((Object)((AccessPointType)element).getDirection())) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = (Object[])this.childrenCache.get(inputElement);
        if (children == null) {
            if (inputElement instanceof ITypedElement && inputElement instanceof IExtensibleElement) {
                ITypedElement accessPoint = (ITypedElement)inputElement;
                children = this.getChildren(accessPoint);
            } else {
                children = new Object[]{};
                this.childrenCache.put(inputElement, children);
            }
        }
        return children;
    }

    public void dispose() {
        this.childrenCache.clear();
        this.parentCache.clear();
        this.childrenCache = null;
        this.parentCache = null;
        this.root = null;
        this.direction = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.childrenCache.clear();
        this.parentCache.clear();
        this.root = newInput;
    }

    public ISelection parseSelection(String selectedMethod) {
        AccessPointType selection = null;
        if (this.root instanceof ITypedElement && this.root instanceof IExtensibleElement) {
            selection = this.parseSelection((ITypedElement)this.root, selectedMethod);
        }
        return selection == null ? null : new StructuredSelection(selection);
    }

    private AccessPointType parseSelection(ITypedElement accessPoint, String selectedMethod) {
        DataTypeType dataType;
        IAccessPathEditor editor;
        String[] splitted;
        IMetaType type = accessPoint.getMetaType();
        if (type instanceof DataTypeType && this.exists((splitted = (editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)(dataType = (DataTypeType)accessPoint.getMetaType()))).splitAccessPath(selectedMethod))[0])) {
            Object[] children = this.getChildren(accessPoint);
            int i = 0;
            while (i < children.length) {
                AccessPointType child = (AccessPointType)children[i];
                if (splitted[0].equals(child.getId())) {
                    return this.exists(splitted[1]) ? this.parseSelection((ITypedElement)child, splitted[1]) : child;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean exists(String string) {
        return string != null && string.length() > 0;
    }
}

