/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IAccessPathEditor;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.spi.dataTypes.primitive.PrimitiveAccessPathEditor;
import org.eclipse.stardust.modeling.core.spi.dataTypes.struct.StructAccessPointType;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.util.Path;
import org.eclipse.stardust.modeling.validation.util.PathEntry;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

public class AccessPathWizard
extends Dialog {
    private static final int CUT_ID = 1025;
    private String title;
    private Path path;
    private PathEntry selectedPath;
    private PathEntry selectedPath_;
    private ITypedElement ap;
    private String transformerKey = null;
    private StyledText pathViewer;
    private Label typeViewer;
    private TableViewer childrenViewer;
    private Group detailsArea;
    private Composite xomDomArea;
    private Button allRadio;
    private Button indexedRadio;
    private Button collectionAPIRadio;
    private Button domRadio;
    private LabeledText indexText;
    private boolean isLego;
    private boolean isIndexed;
    private boolean cutPressed;
    private IXPathMap xPathMap;
    private DirectionType direction;

    public AccessPathWizard(WorkflowModelEditor editor, String title, ITypedElement accessPoint, DirectionType direction) {
        super(editor.getSite().getShell());
        this.ap = accessPoint;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.direction = direction;
        if (this.ap.getMetaType().getId().startsWith("struct")) {
            try {
                if (this.ap instanceof DataType) {
                    this.initializeForDataType();
                }
                if (this.ap instanceof AccessPointType) {
                    this.initializeForAccessPointType(editor, accessPoint);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        PathEntry root = new PathEntry(this.ap, direction);
        this.path = new Path(root);
        String label = root.getLabel();
        this.title = label == null ? title : String.valueOf(title) + ' ' + label;
    }

    private void initializeForDataType() {
        DataType dataType = (DataType)this.ap;
        this.xPathMap = StructuredTypeUtils.getXPathMap((DataType)dataType);
        this.isLego = true;
    }

    private void initializeForAccessPointType(WorkflowModelEditor editor, ITypedElement accessPoint) {
        ModelType modelType = editor.getWorkflowModel();
        AccessPointType apt = (AccessPointType)this.ap;
        String type = AttributeUtil.getAttributeValue((List)apt.getAttribute(), (String)"carnot:engine:dataType");
        TypeDeclarationType decl = modelType.getTypeDeclarations().getTypeDeclaration(type);
        this.xPathMap = StructuredTypeUtils.getXPathMap((TypeDeclarationType)decl);
        this.isLego = true;
        this.ap = new StructAccessPointType(this.xPathMap.getRootXPath(), this.xPathMap);
        ((AccessPointType)this.ap).setType((DataTypeType)accessPoint.getMetaType());
        IIdentifiableElement d = (IIdentifiableElement)accessPoint;
        ((AccessPointType)this.ap).setId(d.getId());
        ((AccessPointType)this.ap).setName(d.getName());
    }

    public void setMethod(String method) {
        try {
            if (this.isLego && method.matches(StructuredTypeUtils.TRANSFORMATION_PATTERN.pattern())) {
                if (StructuredTypeUtils.isValidDomAccessPath((DataType)((DataType)this.ap), (String)method) && method.startsWith("DOM")) {
                    this.transformerKey = "DOM";
                }
                method = method.substring(4);
                method = method.substring(0, method.length() - 1);
            }
            this.path.setMethod(method == null ? "" : method.trim());
        }
        catch (ValidationException ex) {
            ex.printStackTrace();
        }
    }

    public String getSelectedMethod() {
        if (this.isLego && this.transformerKey != null) {
            return String.valueOf(this.transformerKey) + "(" + this.path.getMethod() + ")";
        }
        return this.path.getMethod();
    }

    protected void buttonPressed(int buttonId) {
        if (16 == buttonId) {
            this.okPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        } else if (1025 == buttonId) {
            this.cutPressed();
        } else if (15 == buttonId) {
            this.nextPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.cutPressed = false;
        if (this.selectedPath != null) {
            this.selectedPath = this.path.push(this.selectedPath);
            this.updateViewers();
        }
        if (this.selectedPath_ != null) {
            this.selectedPath = this.path.push(this.selectedPath_);
            this.updateViewers();
        }
        super.okPressed();
    }

    protected void nextPressed() {
        this.cutPressed = false;
        if (this.selectedPath != null) {
            this.selectedPath = this.path.push(this.selectedPath);
        }
        this.updateViewers();
    }

    protected void backPressed() {
        this.cutPressed = false;
        this.selectedPath = this.path.pop();
        this.updateViewers();
    }

    protected void cutPressed() {
        this.cutPressed = true;
        this.path.cut();
        this.updateViewers();
        this.childrenViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void updateViewers() {
        this.updateChildren();
        this.updateDetails();
        this.updatePathViewer();
        this.updateButtons();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
        this.createButton(parent, 1025, Diagram_Messages.BUT_CUT, false);
        this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Path);
        this.pathViewer = new StyledText(composite, 2048);
        this.pathViewer.setBackground(composite.getBackground());
        this.pathViewer.setCursor(this.pathViewer.getDisplay().getSystemCursor(0));
        this.pathViewer.getCaret().setVisible(false);
        this.pathViewer.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)1));
        FormBuilder.applyDefaultTextControlWidth((Control)this.pathViewer);
        this.pathViewer.setEditable(false);
        this.pathViewer.setSelectionBackground(this.pathViewer.getBackground());
        this.pathViewer.setSelectionForeground(this.pathViewer.getForeground());
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Type);
        this.typeViewer = FormBuilder.createLabel((Composite)composite, (String)"");
        this.typeViewer.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)1));
        FormBuilder.applyDefaultTextControlWidth((Control)this.typeViewer);
        this.updatePathViewer();
        FormBuilder.createHorizontalSeparator((Composite)composite, (int)2);
        this.detailsArea = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.LB_DetailsFor, (int)3, (int)2);
        GridData gd = (GridData)this.detailsArea.getLayoutData();
        gd.grabExcessVerticalSpace = false;
        if (this.isLego) {
            this.xomDomArea = FormBuilder.createComposite((Composite)this.detailsArea, (int)3, (int)3);
            GridLayout gridLayout = (GridLayout)this.xomDomArea.getLayout();
            gridLayout.marginLeft = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginBottom = 0;
            gridLayout.marginTop = 0;
            this.domRadio = FormBuilder.createRadioButton((Composite)this.xomDomArea, (String)Diagram_Messages.BUT_DOM);
            this.collectionAPIRadio = FormBuilder.createRadioButton((Composite)this.xomDomArea, (String)Diagram_Messages.BUT_STANDARD_API);
            this.domRadio.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.getSource()).getSelection()) {
                        AccessPathWizard.this.transformerKey = "DOM";
                    }
                    AccessPathWizard.this.updatePathViewer();
                }
            });
            this.collectionAPIRadio.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.getSource()).getSelection()) {
                        AccessPathWizard.this.transformerKey = null;
                    }
                    AccessPathWizard.this.updatePathViewer();
                }
            });
        }
        this.indexedRadio = FormBuilder.createRadioButton((Composite)this.detailsArea, (String)Diagram_Messages.LB_Indexed);
        this.indexText = FormBuilder.createLabeledText((Composite)this.detailsArea, (String)"");
        this.allRadio = FormBuilder.createRadioButton((Composite)this.detailsArea, (String)Diagram_Messages.LB_All, (int)3);
        this.updateDetails();
        Table rawTable = FormBuilder.createTable((Composite)composite, (int)67584, (String[])new String[]{Diagram_Messages.COL_Element, Diagram_Messages.COL_Type}, (int[])new int[]{49, 49}, (int)2);
        gd = (GridData)rawTable.getLayoutData();
        gd.heightHint = 100;
        this.childrenViewer = new TableViewer(rawTable);
        this.childrenViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.childrenViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.childrenViewer.setSorter(new ViewerSorter());
        this.updateChildren();
        this.childrenViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AccessPathWizard.this.pathChanged(event.getSelection());
            }
        });
        this.childrenViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                AccessPathWizard.this.nextPressed();
            }
        });
        this.allRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AccessPathWizard.this.path.setIndex(-1L);
                AccessPathWizard.this.indexText.getText().setEnabled(false);
                AccessPathWizard.this.indexText.getText().setText("");
                AccessPathWizard.this.isIndexed = false;
                AccessPathWizard.this.updateViewers();
            }
        });
        this.indexedRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AccessPathWizard.this.indexText.getText().setEnabled(true);
                if (AccessPathWizard.this.path.getIndex() == -1L) {
                    AccessPathWizard.this.path.setIndex(1L);
                }
                AccessPathWizard.this.isIndexed = true;
                AccessPathWizard.this.indexText.getText().setText(Long.toString(AccessPathWizard.this.path.getIndex()));
                AccessPathWizard.this.updateViewers();
            }
        });
        this.indexText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String index = AccessPathWizard.this.indexText.getText().getText().trim();
                if (index.length() > 0) {
                    try {
                        AccessPathWizard.this.path.setIndex(Long.parseLong(index));
                        AccessPathWizard.this.indexText.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                        AccessPathWizard.this.indexText.getLabel().setToolTipText(null);
                    }
                    catch (Exception exception) {
                        AccessPathWizard.this.indexText.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
                        String msg = MessageFormat.format(Diagram_Messages.MSG_InvalidIndex, index);
                        AccessPathWizard.this.indexText.getLabel().setToolTipText(msg);
                    }
                } else {
                    AccessPathWizard.this.indexText.getLabel().setValidationStatus(IQuickValidationStatus.OK);
                    AccessPathWizard.this.indexText.getLabel().setToolTipText(null);
                }
                AccessPathWizard.this.updatePathViewer();
            }
        });
        this.pathViewer.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int offset = AccessPathWizard.this.pathViewer.getCaretOffset();
                AccessPathWizard.this.selectPathEntry(offset);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        return composite;
    }

    private void selectPathEntry(int offset) {
        this.selectedPath = this.path.selectPathEntry(offset);
        this.updateViewers();
    }

    private void pathChanged(ISelection selection) {
        this.selectedPath = null;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selectedPath = (PathEntry)((IStructuredSelection)selection).getFirstElement();
            this.selectedPath_ = null;
            if (this.isLego && this.selectedPath != null) {
                String xPath;
                TypedXPath path_;
                String method = this.path.getMethod();
                if (!StringUtils.isEmpty(method)) {
                    method = String.valueOf(method) + "/";
                }
                if ((path_ = this.xPathMap.getXPath(xPath = StructuredDataXPathUtils.getXPathWithoutIndexes((String)(String.valueOf(method) + this.selectedPath.getId())))) != null) {
                    if (path_.getChildXPaths().isEmpty()) {
                        this.selectedPath_ = this.selectedPath;
                        this.selectedPath = null;
                    }
                } else {
                    this.selectedPath = null;
                }
            } else if (this.selectedPath != null && this.ap instanceof DataType) {
                DataTypeType dataType = (DataTypeType)this.ap.getMetaType();
                IAccessPathEditor editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)dataType);
                String className = null;
                if (editor instanceof PrimitiveAccessPathEditor) {
                    Class type = Reflect.getClassFromAbbreviatedName((String)AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)this.ap), (String)"carnot:engine:type"));
                    String string = className = type != null ? type.getName() : null;
                }
                if (className != null) {
                    String id = null;
                    String path = this.selectedPath.getFullId();
                    ITypedElement element = this.ap;
                    if (path != null && path.length() == 0) {
                        path = null;
                    }
                    block0: while (element != null && editor != null && path != null) {
                        String[] splitted = editor.splitAccessPath(path);
                        id = splitted[0];
                        path = splitted[1];
                        DirectionType segmentDirection = DirectionType.IN_LITERAL.equals((Object)this.direction) && !StringUtils.isEmpty(path) ? DirectionType.OUT_LITERAL : this.direction;
                        List accessPoints = editor.getAccessPoints(id, (IExtensibleElement)element, segmentDirection);
                        element = null;
                        int i = 0;
                        while (i < accessPoints.size()) {
                            AccessPointType ap = (AccessPointType)accessPoints.get(i);
                            if (ap.getId().equals(id)) {
                                element = ap;
                                editor = AccessPointUtil.getSPIAccessPathEditor((DataTypeType)ap.getType());
                                continue block0;
                            }
                            ++i;
                        }
                    }
                    if (element == null) {
                        this.selectedPath = null;
                    }
                }
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.getButton(14).setEnabled(!this.path.isRootSelected());
        this.getButton(15).setEnabled(this.selectedPath != null);
        this.getButton(1025).setEnabled(!this.path.isLastItem());
        if (this.isLego) {
            this.getButton(16).setEnabled(this.selectedPath != null || this.selectedPath_ != null || this.cutPressed || this.isIndexed);
        } else {
            this.getButton(16).setEnabled(this.path.matchesDirection());
        }
    }

    private void updateDetails() {
        boolean indexed = this.path.isIndexed();
        if (this.isLego && this.path.getLabel() != null) {
            String xPathString = this.path.getLabel();
            xPathString = xPathString.substring(xPathString.indexOf("/") + 1);
            TypedXPath xPath = this.xPathMap.getXPath(xPathString);
            this.xomDomArea.setVisible(this.isLego && xPath != null);
            this.domRadio.setVisible(this.isLego && xPath != null);
            this.collectionAPIRadio.setVisible(this.isLego && xPath != null);
            if (xPath != null) {
                boolean listOrPrimitive;
                boolean bl = listOrPrimitive = StructuredDataXPathUtils.canReturnList((String)xPathString, (IXPathMap)this.xPathMap) || StructuredDataXPathUtils.returnsSinglePrimitive((String)xPathString, (IXPathMap)this.xPathMap);
                if (listOrPrimitive) {
                    this.transformerKey = null;
                }
                this.domRadio.setSelection(this.transformerKey != null && this.transformerKey.equalsIgnoreCase("DOM") && !listOrPrimitive);
                this.collectionAPIRadio.setSelection(this.transformerKey == null || listOrPrimitive);
                this.domRadio.setEnabled(!listOrPrimitive);
                this.collectionAPIRadio.setEnabled(true);
            } else {
                this.transformerKey = null;
            }
        }
        this.allRadio.setVisible(indexed);
        this.indexedRadio.setVisible(indexed);
        this.indexText.getText().setVisible(indexed);
        if (indexed) {
            if (!this.path.isIndexed() || this.path.getIndex() == -1L) {
                this.indexedRadio.setSelection(false);
                this.allRadio.setSelection(true);
                this.indexText.getText().setText("");
                this.indexText.getText().setEnabled(false);
            } else {
                this.allRadio.setSelection(false);
                this.indexedRadio.setSelection(true);
                this.isIndexed = true;
                this.indexText.getText().setText(Long.toString(this.path.getIndex()));
                this.indexText.getText().setEnabled(true);
            }
        }
        String detailsTitle = MessageFormat.format(Diagram_Messages.LB_DetailsFor, this.path.getSelection().getLabel());
        this.detailsArea.setText(detailsTitle);
    }

    private void updatePathViewer() {
        String label = this.path.getLabel();
        if (this.isLego && this.transformerKey != null) {
            label = String.valueOf(this.transformerKey) + "(" + label + ")";
        }
        this.pathViewer.setText(label);
        StyleRange unstyled = new StyleRange();
        unstyled.start = 0;
        unstyled.length = label.length();
        this.pathViewer.setStyleRange(unstyled);
        StyleRange styled = new StyleRange();
        styled.fontStyle = 1;
        styled.start = this.path.getSelectionStart();
        styled.length = this.path.getSelectionLength();
        this.pathViewer.setStyleRange(styled);
        this.typeViewer.setText(this.path.getType());
    }

    private void updateChildren() {
        ArrayList children = null;
        try {
            children = this.path.getChildren();
        }
        catch (RuntimeException runtimeException) {
            children = new ArrayList();
        }
        boolean hasChildren = !children.isEmpty();
        PathEntry selection = this.selectedPath;
        this.childrenViewer.setInput(children);
        this.childrenViewer.setSelection((ISelection)(selection == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)selection)));
        this.childrenViewer.getTable().setEnabled(hasChildren);
        if (this.getDialogArea() != null) {
            ((Composite)this.getDialogArea()).layout();
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                PathEntry entry = (PathEntry)element;
                String image = entry.getIcon();
                return DiagramPlugin.getImage(image);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PathEntry entry = (PathEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.getLabel();
                }
                case 1: {
                    return entry.getTypeName();
                }
            }
            return "";
        }
    }
}

