/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.ui;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class DereferencePathBrowserContentProvider
implements ITreeContentProvider {
    private final TypeFinder finder;
    private boolean isConstructor = false;
    private boolean isDeep = true;

    public DereferencePathBrowserContentProvider(TypeFinder finder, boolean isConstructor, boolean deep) {
        this.finder = finder;
        this.isConstructor = isConstructor;
        this.isDeep = deep;
    }

    public Object[] getChildren(Object parentElement) {
        MethodInfo[] methods = null;
        try {
            String returnType;
            TypeInfo type;
            if (parentElement instanceof TypeInfo) {
                methods = this.sort((this.isConstructor ? this.finder.getConstructors((TypeInfo)parentElement) : this.finder.getMethods((TypeInfo)parentElement)).toArray());
            } else if (parentElement instanceof MethodInfo && (type = this.finder.findType(returnType = ((MethodInfo)parentElement).getReturnType())) != null) {
                methods = this.sort(type.getMethods().toArray());
            }
        }
        catch (JavaModelException javaModelException) {}
        return methods;
    }

    private MethodInfo[] sort(Object[] objects) {
        Map methodMap = CollectionUtils.newMap();
        Object[] methodNames = new String[objects.length];
        int i = 0;
        while (i < objects.length) {
            String methodName = ((MethodInfo)objects[i]).getLabel();
            methodMap.put(methodName, objects[i]);
            methodNames[i] = methodName;
            ++i;
        }
        Arrays.sort(methodNames);
        MethodInfo[] sortedMethods = new MethodInfo[objects.length];
        int i2 = 0;
        while (i2 < methodNames.length) {
            sortedMethods[i2] = (MethodInfo)methodMap.get(methodNames[i2]);
            ++i2;
        }
        return sortedMethods;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TypeInfo) {
            if (this.isConstructor) {
                return true;
            }
            try {
                return !((TypeInfo)element).getMethods().isEmpty();
            }
            catch (JavaModelException javaModelException) {
            }
        } else if (element instanceof MethodInfo && this.isDeep) {
            String returnType = ((MethodInfo)element).getReturnType();
            return !StringUtils.isEmpty(returnType) && this.isNoPrimitiveType(returnType);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.hasChildren(inputElement)) {
            return this.getChildren(inputElement);
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isNoPrimitiveType(String returnType) {
        return !returnType.equalsIgnoreCase("void") && !returnType.equals("int") && !returnType.equals("long") && !returnType.equals("double") && !returnType.equals("boolean") && !returnType.equals("char") && !returnType.equals("byte") && !StringUtils.isEmpty(returnType);
    }
}

