/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.stardust.modeling.core.utils.FileResourceChangeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class FileEditorInputTracker
extends FileResourceChangeListener {
    private final IEditorPart editor;
    private final ListenerList listeners;

    public FileEditorInputTracker(IEditorPart editor) {
        this.editor = editor;
        this.listeners = new ListenerList();
    }

    @Override
    public IFile getFile() {
        return ((FileEditorInput)this.editor.getEditorInput()).getFile();
    }

    public void addChangeVisitor(IResourceDeltaVisitor visitor) {
        this.listeners.add((Object)visitor);
    }

    public void removeChangeVisitor(IResourceDeltaVisitor visitor) {
        this.listeners.remove((Object)visitor);
    }

    @Override
    public boolean fileChanged(IResourceDelta delta) {
        boolean result = false;
        Object[] listeners = this.listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            try {
                result |= ((IResourceDeltaVisitor)listeners[i]).visit(delta);
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return result;
    }
}

