/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkspaceManager;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.ui.PlatformUI;

public class GenericUtils {
    private static final String[] EMPTY = new String[0];

    public static String getLocationRelativeToClasspath(IFile file) {
        String fileName = file.toString().substring(1);
        try {
            IProject project = file.getProject();
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject rootJavaProject = JavaCore.create((IProject)project);
                ArrayList<IJavaProject> javaProjectsToScan = new ArrayList<IJavaProject>();
                javaProjectsToScan.add(rootJavaProject);
                javaProjectsToScan.addAll(GenericUtils.getRequiredProjects(rootJavaProject));
                for (IJavaProject javaProject : javaProjectsToScan) {
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String parent;
                        IResource resource = roots[i].getCorrespondingResource();
                        if (resource instanceof IFolder && fileName.startsWith(parent = resource.toString().substring(1))) {
                            return fileName.substring(parent.length());
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception exception) {}
        return fileName;
    }

    public static IFile cleanFileStructure(EObject modelElement, String filename) {
        ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
        IProject project = WorkspaceUtils.getProjectFromEObject((EObject)modelElement);
        EditorUtils.deleteFileStructure((IProject)project, (ModelType)model);
        try {
            EditorUtils.addJSSupport((IProject)project, (ModelType)model);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return EditorUtils.createFileStructure((IProject)project, (ModelType)model, (String)filename);
    }

    public static WorkflowModelEditor getWorkflowModelEditor(ModelType model) {
        IWorkflowModelEditor editor = BpmUiActivator.findWorkflowModelEditor((ModelType)model);
        return editor instanceof WorkflowModelEditor ? (WorkflowModelEditor)editor : null;
    }

    public static String getElementId(EObject eObject) {
        if (eObject instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)eObject).getId();
        }
        if (eObject instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)eObject).getId();
        }
        if (eObject instanceof DiagramType) {
            return ((DiagramType)eObject).getName();
        }
        return null;
    }

    public static IModelParticipant getLanePerformerForActivity(ActivityType activity) {
        IModelParticipant performer = null;
        EList symbols = activity.getActivitySymbols();
        for (ActivitySymbolType symbol : symbols) {
            IModelParticipant laneParticpant;
            EObject container = symbol.eContainer();
            if (!(container instanceof LaneSymbol) || (laneParticpant = ((LaneSymbol)container).getParticipantReference()) == null) continue;
            if (performer == null) {
                performer = laneParticpant;
                continue;
            }
            if (performer.equals(laneParticpant)) continue;
            performer = null;
            break;
        }
        return performer;
    }

    public static EditPart isValidTargetEditPart(EditPart targetEP) {
        if (targetEP != null && (targetEP instanceof LaneEditPart || targetEP instanceof PoolEditPart || targetEP instanceof DiagramEditPart || targetEP instanceof DiagramRootEditPart)) {
            if (targetEP instanceof DiagramRootEditPart) {
                targetEP = (DiagramEditPart)((DiagramRootEditPart)((Object)targetEP)).getChildren().get(0);
            }
            EditPart iterateEP = targetEP;
            while (!(iterateEP instanceof DiagramEditPart)) {
                iterateEP = iterateEP.getParent();
            }
            DiagramEditPart diagramEP = (DiagramEditPart)iterateEP;
            DiagramType diagram = (DiagramType)diagramEP.getModel();
            if (ModelUtils.findContainingProcess((EObject)diagram) != null) {
                if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                    if (targetEP instanceof AbstractSwimlaneEditPart) {
                        if (PoolLaneUtils.containsLanes(targetEP)) {
                            return null;
                        }
                        if (targetEP instanceof LaneEditPart && ((LaneEditPart)targetEP).getLaneFigure().isCollapsed()) {
                            return null;
                        }
                    }
                    if (targetEP instanceof DiagramEditPart) {
                        return null;
                    }
                } else if (targetEP instanceof DiagramEditPart) {
                    targetEP = ((DiagramEditPart)targetEP).getPoolDelegate();
                }
            }
            return targetEP;
        }
        return null;
    }

    public static EditPart getTargetEditPart(WorkflowModelEditor editor) {
        EditPart targetEP = PoolLaneUtils.findTargetEditPart(editor);
        return GenericUtils.isValidTargetEditPart(targetEP);
    }

    public static IFile getFile(List<IJavaProject> projectsToScan, String url) {
        IFile file = null;
        try {
            for (IJavaProject projectToScan : projectsToScan) {
                IPackageFragmentRoot[] roots = projectToScan.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IResource resource = roots[i].getCorrespondingResource();
                    if (resource instanceof IFolder) {
                        IFolder folder = (IFolder)resource;
                        file = folder.getFile(url);
                        if (file.exists()) {
                            return file;
                        }
                        file = null;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            file = null;
        }
        return file;
    }

    public static IFile getFile(IJavaProject javaProject, String url, boolean scanRequiredProjects) {
        ArrayList<IJavaProject> projectsToScan = new ArrayList<IJavaProject>();
        projectsToScan.add(javaProject);
        if (scanRequiredProjects) {
            projectsToScan.addAll(GenericUtils.getRequiredProjects(javaProject));
        }
        return GenericUtils.getFile(projectsToScan, url);
    }

    public static IFile getFile(IProject targetProject, String url) {
        IFile file = null;
        try {
            if (targetProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)targetProject);
                return GenericUtils.getFile(javaProject, url, false);
            }
        }
        catch (Exception exception) {
            file = null;
        }
        return file;
    }

    public static Rectangle getSymbolRectangle(EditPart editPart) {
        if (editPart instanceof DiagramEditPart) {
            Figure figure = (Figure)((GraphicalEditPart)editPart).getFigure();
            return figure.getBounds().getCopy();
        }
        INodeSymbol symbol = (INodeSymbol)editPart.getModel();
        Figure figure = (Figure)((GraphicalEditPart)editPart).getFigure();
        Rectangle symbolRectangle = new Rectangle(new Long(symbol.getXPos()).intValue(), new Long(symbol.getYPos()).intValue(), symbol.getWidth(), symbol.getHeight());
        if (symbolRectangle.height == -1 || symbolRectangle.width == -1) {
            Dimension preferenceSize = figure.getPreferredSize();
            if (symbolRectangle.height == -1) {
                symbolRectangle.height = preferenceSize.height;
            }
            if (symbolRectangle.width == -1) {
                symbolRectangle.width = preferenceSize.width;
            }
        }
        return symbolRectangle;
    }

    public static boolean isXMLDataType(DataType data) {
        if (data.eIsProxy()) {
            data = (DataType)WorkspaceManager.getInstance().findElement((EObject)data);
        }
        return data.getType().getId().equals("plainXML");
    }

    public static boolean isDMSDataType(DataType data) {
        if (data.eIsProxy()) {
            data = (DataType)WorkspaceManager.getInstance().findElement((EObject)data);
        }
        return data.getType().getId().equals("dms-document") || data.getType().getId().equals("dms-document-set") || data.getType().getId().equals("dmsDocument") || data.getType().getId().equals("dmsDocumentList") || data.getType().getId().equals("dmsFolder") || data.getType().getId().equals("dmsFolderList");
    }

    public static boolean isStructuredDataType(DataType data) {
        EObject resolvedElement;
        if (data.eIsProxy() && (resolvedElement = WorkspaceManager.getInstance().findElement((EObject)data)) != null) {
            return ((DataType)resolvedElement).getType().getId().equals("struct");
        }
        return data.getType().getId().equals("struct");
    }

    public static String getReferenceClassName(DataType data) {
        String[] names = GenericUtils.getReferenceClassNames(data);
        return names.length == 0 ? null : names[0];
    }

    public static String[] getReferenceClassNames(DataType data) {
        String id;
        if (data.eIsProxy()) {
            data = (DataType)WorkspaceManager.getInstance().findElement((EObject)data);
        }
        if (data.getType().getId().equals("dms-document") || data.getType().getId().equals("dms-document-set") || data.getType().getId().equals("dmsDocument") || data.getType().getId().equals("dmsDocumentList") || data.getType().getId().equals("dmsFolder") || data.getType().getId().equals("dmsFolderList")) {
            return new String[]{AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:className")};
        }
        if (data.getType().getId().equals("primitive")) {
            String type = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:type");
            if (Type.Enumeration.getId().equals(type)) {
                String enumClass;
                TypeDeclarationType typeDeclaration;
                String typeDeclarationId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType");
                if (typeDeclarationId != null && (typeDeclaration = StructuredTypeUtils.getTypeDeclaration((DataType)data)) != null && (enumClass = ExtendedAttributeUtil.getAttributeValue((Extensible)typeDeclaration, (String)"carnot:engine:className")) != null) {
                    return new String[]{enumClass, String.class.getName()};
                }
                return new String[]{String.class.getName()};
            }
            return new String[]{Reflect.getClassFromAbbreviatedName((String)type).getName()};
        }
        if (data.getType().getId().equals("hibernate")) {
            return new String[]{AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:className")};
        }
        if (data.getType().getId().equals("serializable")) {
            return new String[]{AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:className")};
        }
        if (data.getType().getId().equals("entity")) {
            String version = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:ejbVersion");
            if (version == null || version.equals("sessionBean20")) {
                return new String[]{AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:remoteInterface")};
            }
            return new String[]{AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:className")};
        }
        if (data.getType().getId().equals("struct") && !StringUtils.isEmpty((String)(id = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType")))) {
            return new String[]{id};
        }
        return EMPTY;
    }

    public static boolean isConnected(ActivityType processActivity, String accessPointId) {
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)processActivity);
        for (ActivityType activity : process.getActivity()) {
            for (DataMappingType dm : activity.getDataMapping()) {
                String accessPoint = dm.getApplicationAccessPoint();
                if (accessPoint == null || !accessPoint.equals(accessPointId)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean dataHasClassAssigned(DataType data) {
        if (data.eIsProxy()) {
            data = (DataType)WorkspaceManager.getInstance().findElement((EObject)data);
        }
        return data.getType().getId().equals("primitive") || data.getType().getId().equals("hibernate") || data.getType().getId().equals("serializable") || data.getType().getId().equals("entity");
    }

    public static List<IJavaProject> getRequiredProjects(IJavaProject javaProject) {
        ArrayList<IJavaProject> requiredProjects = new ArrayList<IJavaProject>();
        try {
            String[] requiredProjectNames = javaProject.getRequiredProjectNames();
            IWorkspace workSpace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workSpaceRoot = workSpace.getRoot();
            String[] stringArray = requiredProjectNames;
            int n = requiredProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProjectName = stringArray[n2];
                IProject project = workSpaceRoot.getProject(requiredProjectName);
                if (project.hasNature("org.eclipse.jdt.core.javanature") && project.exists()) {
                    IJavaProject requiredProject = JavaCore.create((IProject)project);
                    requiredProjects.add(requiredProject);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return requiredProjects;
    }

    public static boolean getAutoIdValue() {
        return PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration");
    }

    public static DataTypeType getDataTypeType(ModelType model, String type) {
        return (DataTypeType)ModelUtils.findIdentifiableElement((EObject)model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), (String)type);
    }

    public static IFile getModelFile(ModelType model) {
        Resource eResource = model.eResource();
        if (eResource != null) {
            URI eUri = eResource.getURI();
            return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)eUri.toPlatformString(true)));
        }
        return null;
    }
}

