/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;

public class HierarchyUtils {
    public static List getTopLevelChildParticipants(LaneSymbol laneSymbol) {
        ArrayList<IModelParticipant> participants = new ArrayList<IModelParticipant>();
        if (!laneSymbol.getChildLanes().isEmpty()) {
            EList children = laneSymbol.getChildLanes();
            int i = 0;
            while (i < children.size()) {
                LaneSymbol childSymbol = (LaneSymbol)children.get(i);
                IModelParticipant laneParticipant = childSymbol.getParticipantReference();
                if (laneParticipant != null) {
                    participants.add(laneParticipant);
                } else {
                    List childParticipants = HierarchyUtils.getTopLevelChildParticipants(childSymbol);
                    if (childParticipants != null) {
                        participants.addAll(childParticipants);
                    }
                }
                ++i;
            }
        }
        if (participants.isEmpty()) {
            return null;
        }
        return participants;
    }

    public static Map createHierarchy(ModelType model) {
        HashMap allOrganizationsSource = new HashMap();
        HashMap<OrganizationType, List> allOrganizations = null;
        EList organizations = model.getOrganization();
        int i = 0;
        while (i < organizations.size()) {
            OrganizationType organization = (OrganizationType)organizations.get(i);
            EList contentObjects = organization.eContents();
            if (contentObjects.size() == 0) {
                allOrganizationsSource.put(organization, null);
            } else {
                ArrayList<IModelParticipant> childParticipants = new ArrayList<IModelParticipant>();
                int c = 0;
                while (c < contentObjects.size()) {
                    EObject content = (EObject)contentObjects.get(c);
                    if (content instanceof ParticipantType) {
                        IModelParticipant childParticipant = ((ParticipantType)content).getParticipant();
                        childParticipants.add(childParticipant);
                    }
                    ++c;
                }
                allOrganizationsSource.put(organization, childParticipants);
            }
            ++i;
        }
        allOrganizations = new HashMap<OrganizationType, List>(allOrganizationsSource);
        for (Map.Entry entry : allOrganizationsSource.entrySet()) {
            OrganizationType organization = (OrganizationType)entry.getKey();
            Object children = entry.getValue();
            if (!allOrganizations.containsKey(organization) || children == null) continue;
            List organizationTree = HierarchyUtils.createTree(allOrganizations, organization);
            allOrganizations.put(organization, organizationTree);
        }
        return allOrganizations;
    }

    public static List createTree(Map allOrganizations, OrganizationType organization) {
        Object children = allOrganizations.get(organization);
        allOrganizations.remove(organization);
        ArrayList newChildren = null;
        if (children != null) {
            newChildren = new ArrayList();
            HashMap organizationContainer = new HashMap();
            int c = 0;
            while (c < ((List)children).size()) {
                Object childParticipant = ((List)children).get(c);
                if (childParticipant instanceof OrganizationType) {
                    List organizationTree = HierarchyUtils.createTree(allOrganizations, (OrganizationType)childParticipant);
                    if (organizationTree != null) {
                        organizationContainer.put(childParticipant, organizationTree);
                    } else {
                        newChildren.add(childParticipant);
                    }
                } else {
                    newChildren.add(childParticipant);
                }
                ++c;
            }
            if (organizationContainer.size() > 0) {
                newChildren.add(organizationContainer);
            }
        }
        return newChildren;
    }

    public static List getChildHierarchy(Map organizationTree, OrganizationType laneParticipant) {
        for (Map.Entry entry : organizationTree.entrySet()) {
            OrganizationType organization = (OrganizationType)entry.getKey();
            Object children = entry.getValue();
            if (organization.equals(laneParticipant)) {
                return (List)children;
            }
            if (children != null) {
                int c = 0;
                while (c < ((List)children).size()) {
                    Object child = ((List)children).get(c);
                    if (child instanceof Map) {
                        return HierarchyUtils.getChildHierarchy((Map)child, laneParticipant);
                    }
                    if (child.equals(laneParticipant)) {
                        return null;
                    }
                    ++c;
                }
                continue;
            }
            return null;
        }
        return null;
    }

    public static List getParticipants(List organizationChildren) {
        ArrayList<Object> allParticipants = new ArrayList<Object>();
        int c = 0;
        while (c < organizationChildren.size()) {
            Object child = organizationChildren.get(c);
            if (child instanceof Map) {
                for (Map.Entry entry : ((Map)child).entrySet()) {
                    List childOrganizations;
                    OrganizationType organization = (OrganizationType)entry.getKey();
                    allParticipants.add(organization);
                    Object children = entry.getValue();
                    if (children == null || (childOrganizations = HierarchyUtils.getParticipants((List)children)) == null) continue;
                    allParticipants.addAll(childOrganizations);
                }
            } else if (child instanceof IModelParticipant) {
                allParticipants.add(child);
            }
            ++c;
        }
        if (allParticipants.size() == 0) {
            allParticipants = null;
        }
        return allParticipants;
    }

    public static List getAllParticipants(ModelType model) {
        ArrayList allParticipants = new ArrayList();
        allParticipants.addAll(model.getRole());
        allParticipants.addAll(model.getConditionalPerformer());
        allParticipants.addAll(model.getOrganization());
        return allParticipants;
    }

    public static List getParticipants(LaneSymbol lane, ModelType model) {
        if (lane != null) {
            IModelParticipant laneParticipant = null;
            Map organizationTree = HierarchyUtils.createHierarchy(model);
            ISwimlaneSymbol parent = lane.getParentLane();
            IModelParticipant parentParticipant = null;
            while (parent != null) {
                parentParticipant = parent.getParticipantReference();
                if (parentParticipant != null) {
                    laneParticipant = parentParticipant;
                    break;
                }
                ISwimlaneSymbol iSwimlaneSymbol = parent = parent instanceof LaneSymbol ? ((LaneSymbol)parent).getParentLane() : null;
            }
            if (laneParticipant == null) {
                return HierarchyUtils.getAllParticipants(model);
            }
            if (!(parentParticipant instanceof OrganizationType)) {
                return Collections.EMPTY_LIST;
            }
            List organizationChildren = HierarchyUtils.getChildHierarchy(organizationTree, (OrganizationType)laneParticipant);
            List participants = new ArrayList();
            if (organizationChildren != null && HierarchyUtils.getParticipants(organizationChildren) != null) {
                participants = HierarchyUtils.getParticipants(organizationChildren);
            }
            return participants;
        }
        return HierarchyUtils.getAllParticipants(model);
    }

    public static boolean hasChildLanesParticipant(LaneSymbol lane) {
        EList lanes = lane.getChildLanes();
        if (!lanes.isEmpty()) {
            int i = 0;
            while (i < lanes.size()) {
                LaneSymbol childLane = (LaneSymbol)lanes.get(i);
                if (childLane.getParticipantReference() != null) {
                    return true;
                }
                if (HierarchyUtils.hasChildLanesParticipant(childLane)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static IModelParticipant hasParentLanesParticipant(LaneSymbol lane) {
        if (lane.getParticipantReference() != null) {
            return lane.getParticipantReference();
        }
        ISwimlaneSymbol parent = lane.getParentLane();
        if (parent instanceof PoolSymbol) {
            return null;
        }
        return HierarchyUtils.hasParentLanesParticipant((LaneSymbol)parent);
    }
}

